/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chat.box;

import com.paterva.maltego.chat.ChatRoomRegistry;
import com.paterva.maltego.chat.ChatRoomTopComponentRegistry;
import com.paterva.maltego.chat.box.Bundle;
import com.paterva.maltego.chat.box.ChatHistoryPanel;
import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.ChatRoomCookie;
import com.paterva.maltego.chatapi.msg.ChatMessageHandler;
import com.paterva.maltego.chatapi.msg.ChatMessageHandlerRegistry;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.chatapi.user.User;
import com.paterva.maltego.util.output.OutputMessage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.RetainLocation;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ChatBoxTopComponent", iconBase="", persistenceType=2)
@RetainLocation(value="output")
public final class ChatBoxTopComponent
extends TopComponent {
    private final Map<ChatRoom, ChatHistoryPanel> _chatWindows = new HashMap<ChatRoom, ChatHistoryPanel>();
    private ChatRoomRegistryListener _registryListener;
    private JPanel _chatHistoryPanel;
    private ChatRoomRegistry _chatRoomRegistry;
    private ChatRoom _currentChatRoom;

    public ChatBoxTopComponent() {
        this(ChatRoomTopComponentRegistry.getDefault());
    }

    public ChatBoxTopComponent(ChatRoom chatRoom) {
        this(new ChatRoomRegistry.Singleton(chatRoom));
        this.associateLookup(Lookups.fixed((Object[])new Object[]{new ChatRoomCookie(chatRoom)}));
    }

    public ChatBoxTopComponent(ChatRoomRegistry chatRoomRegistry) {
        this._chatRoomRegistry = chatRoomRegistry;
        this.initComponents();
        this.setName(Bundle.CTL_ChatBoxTopComponent());
        this.setToolTipText(Bundle.HINT_ChatBoxTopComponent());
        this.setLayout(new BorderLayout());
        this._chatHistoryPanel = new JPanel(new CardLayout());
        this.add(this._chatHistoryPanel);
        Action[] toolbarActions = this.getToolbarActions();
        if (toolbarActions != null && toolbarActions.length > 0) {
            JToolBar toolBar = new JToolBar(1);
            toolBar.setFloatable(false);
            for (Action action : toolbarActions) {
                toolBar.add(action);
            }
            this.add(toolBar, "West");
        }
        this._registryListener = new ChatRoomRegistryListener();
        this._chatRoomRegistry.addPropertyChangeListener(this._registryListener);
        ChatMessageHandlerRegistry.getDefault().add((ChatMessageHandler)new MessageHandler());
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void componentOpened() {
        super.componentActivated();
        ChatRoom chatRoom = this._chatRoomRegistry.getActiveChatRoom();
        if (chatRoom != null) {
            this.onChatRoomChanged(chatRoom);
        }
    }

    public void componentClosed() {
    }

    protected void componentActivated() {
        ChatHistoryPanel panel;
        super.componentActivated();
        if (this._currentChatRoom != null && (panel = this._chatWindows.get(this._currentChatRoom)) != null) {
            panel.requestInputFocus();
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void onChatRoomChanged(ChatRoom chatRoom) {
        String cardID = this.getCardId(chatRoom);
        ChatHistoryPanel chatHistoryPanel = this._chatWindows.get(chatRoom);
        if (chatHistoryPanel == null) {
            this.createHistoryPanel(chatRoom, cardID);
        }
        CardLayout layout = (CardLayout)this._chatHistoryPanel.getLayout();
        layout.show(this._chatHistoryPanel, cardID);
        this._currentChatRoom = chatRoom;
        this._chatHistoryPanel.revalidate();
    }

    private void onChatRoomRemoved(ChatRoom chatRoom) {
        ChatHistoryPanel chatHistoryPanel = this._chatWindows.get(chatRoom);
        if (chatHistoryPanel != null) {
            this._chatWindows.remove(chatRoom);
            this._chatHistoryPanel.remove(chatHistoryPanel);
        }
        if (Utilities.compareObjects((Object)chatRoom, (Object)this._currentChatRoom)) {
            this._currentChatRoom = null;
        }
    }

    private ChatHistoryPanel createHistoryPanel(ChatRoom chatRoom, String cardID) {
        ChatHistoryPanel chatHistoryPanel = new ChatHistoryPanel(chatRoom);
        this._chatHistoryPanel.add((Component)chatHistoryPanel, cardID);
        this._chatWindows.put(chatRoom, chatHistoryPanel);
        return chatHistoryPanel;
    }

    private String getCardId(ChatRoom chatRoom) {
        return Integer.toHexString(System.identityHashCode(chatRoom));
    }

    private ChatHistoryPanel getOrCreateHistoryPanel(ChatRoom chatRoom) {
        ChatHistoryPanel chatHistoryPanel = this._chatWindows.get(chatRoom);
        if (chatHistoryPanel == null) {
            String cardId = this.getCardId(chatRoom);
            chatHistoryPanel = this.createHistoryPanel(chatRoom, cardId);
            if (this._chatWindows.size() == 1) {
                CardLayout layout = (CardLayout)this._chatHistoryPanel.getLayout();
                layout.show(this._chatHistoryPanel, cardId);
                this._chatHistoryPanel.revalidate();
            }
        }
        return chatHistoryPanel;
    }

    private Action[] getToolbarActions() {
        Action[] actions = null;
        Lookup lookup = Lookups.forPath((String)"Maltego/Chat/ChatWindow/Actions");
        if (lookup != null) {
            actions = lookup.lookupAll(Action.class).toArray(new Action[0]);
        }
        return actions;
    }

    private class MessageHandler
    implements ChatMessageHandler {
        private MessageHandler() {
        }

        public void chatMessage(ChatRoom chatRoom, User user, OutputMessage message, Date date) {
            ChatHistoryPanel historyPanel = ChatBoxTopComponent.this.getOrCreateHistoryPanel(chatRoom);
            historyPanel.chatMessage(user, message, date);
            this.requestAttention();
        }

        public void logMessage(ChatRoom chatRoom, LogMessageLevel level, OutputMessage message, Date date) {
            ChatHistoryPanel historyPanel = ChatBoxTopComponent.this.getOrCreateHistoryPanel(chatRoom);
            historyPanel.logMessage(level, message, date);
            this.requestAttention();
        }

        public void logMessage(ChatRoom chatRoom, LogMessageLevel level, OutputMessage message, Color color, Date date) {
            ChatHistoryPanel historyPanel = ChatBoxTopComponent.this.getOrCreateHistoryPanel(chatRoom);
            historyPanel.logMessage(level, message, color, date);
            this.requestAttention();
        }

        private void requestAttention() {
            ChatBoxTopComponent.this.requestAttention(true);
        }
    }

    private class ChatRoomRegistryListener
    implements PropertyChangeListener {
        private ChatRoomRegistryListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue;
            ChatRoom chatRoom;
            if ("chatRoomActiveChanged".equals(evt.getPropertyName())) {
                Object newValue2 = evt.getNewValue();
                ChatRoom chatRoom2 = this.getChatRoom(newValue2);
                if (chatRoom2 != null) {
                    ChatBoxTopComponent.this.onChatRoomChanged(chatRoom2);
                }
            } else if ("chatRoomRemoved".equals(evt.getPropertyName()) && (chatRoom = this.getChatRoom(newValue = evt.getNewValue())) != null) {
                ChatBoxTopComponent.this.onChatRoomRemoved(chatRoom);
            }
        }

        private ChatRoom getChatRoom(Object obj) {
            TopComponent tc;
            ChatRoomCookie cookie;
            ChatRoom chatRoom = null;
            if (obj instanceof ChatRoom) {
                chatRoom = (ChatRoom)obj;
            } else if (obj instanceof TopComponent && (cookie = (ChatRoomCookie)(tc = (TopComponent)obj).getLookup().lookup(ChatRoomCookie.class)) != null) {
                chatRoom = cookie.getChatRoom();
            }
            return chatRoom;
        }
    }
}

