/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.lucene.serialize.AbstractTypeConverter;
import com.pinkmatter.pandora.lucene.serialize.FilterHelper;
import com.pinkmatter.pandora.lucene.serialize.SortHelper;
import com.pinkmatter.pandora.lucene.serialize.StringConverter;
import java.math.BigInteger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;

class BigIntegerConverter
extends AbstractTypeConverter<BigInteger> {
    protected static final String ANALYZED_COLUMN = "*analyzed";
    private FieldType _analyzedType;

    public BigIntegerConverter() {
        super("bigint", BigInteger.class);
    }

    @Override
    protected void writeImpl(BigInteger value, String property, Document to) throws PandoraException {
        String paddedValue = String.format("%0256d", value);
        String fieldName = this.getIndexField(property);
        String keyword = StringConverter.limit(value + "").toLowerCase();
        StringField indexField = new StringField(fieldName, keyword, Field.Store.NO);
        to.add((IndexableField)indexField);
        to.add(SortHelper.createStringDocValueField(fieldName, paddedValue));
        StoredField storeField = new StoredField(fieldName, value + "");
        to.add((IndexableField)storeField);
        Field analyzedField = new Field(this.getAnalyzedField(property), value + "", this.getAnalyzedFieldType());
        to.add((IndexableField)analyzedField);
    }

    @Override
    protected BigInteger readImpl(IndexableField field) throws PandoraException {
        return new BigInteger(field.stringValue());
    }

    private String getAnalyzedField(String field) {
        StringBuilder builder = new StringBuilder(this.getIndexField(field));
        builder.append("|");
        builder.append(ANALYZED_COLUMN);
        return builder.toString();
    }

    private FieldType getAnalyzedFieldType() {
        if (this._analyzedType == null) {
            this._analyzedType = new FieldType();
            this._analyzedType.setStored(false);
            this._analyzedType.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
            this._analyzedType.setTokenized(true);
            this._analyzedType.setStoreTermVectors(true);
            this._analyzedType.setStoreTermVectorPositions(true);
            this._analyzedType.setStoreTermVectorOffsets(true);
            this._analyzedType.freeze();
        }
        return this._analyzedType;
    }

    @Override
    protected Query createFilterImpl(PandoraFilter.Simple parameters) throws PandoraException {
        if (parameters instanceof PandoraFilter.Like) {
            String field = this.getAnalyzedField(parameters.getProperty());
            PandoraFilter.Like params = (PandoraFilter.Like)parameters;
            return FilterHelper.createLikeQuery(field, (String)params.getValue());
        }
        String field = this.getIndexField(parameters.getProperty());
        StringConverter.checkLimit(parameters, "BigIntegers");
        return FilterHelper.createSimpleQuery(field, this.getClassType(), parameters);
    }

    @Override
    protected SortField[] getSortFieldsImpl(String property, boolean reverse, boolean emptyFirst) {
        return new SortField[]{SortHelper.createStringSortField(this.getIndexField(property), reverse, emptyFirst)};
    }
}

