/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.ArtifactData;
import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.lucene.serialize.AbstractTypeConverter;
import com.pinkmatter.pandora.lucene.serialize.FilterHelper;
import com.pinkmatter.pandora.lucene.serialize.SortHelper;
import com.pinkmatter.pandora.lucene.serialize.TypeConverter;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;

@Deprecated
class ArtifactDataConverter
extends AbstractTypeConverter<ArtifactData> {
    protected static final String ANALYZED_COLUMN = "*analyzed";
    private FieldType _analyzedType;

    public ArtifactDataConverter() {
        super("artifact", ArtifactData.class);
    }

    @Override
    protected void writeImpl(ArtifactData value, String field, Document to) {
        String fieldName = this.getIndexField(field);
        String storeValue = this.toStoreValue(value);
        StringField indexField = new StringField(fieldName, storeValue.toLowerCase(), Field.Store.NO);
        to.add((IndexableField)indexField);
        StoredField storeField = new StoredField(fieldName, storeValue);
        to.add((IndexableField)storeField);
        to.add(SortHelper.createStringDocValueField(fieldName, storeValue));
        Field analyzedField = new Field(this.getAnalyzedField(field), this.toAnalyzedValue(value), this.getAnalyzedFieldType());
        to.add((IndexableField)analyzedField);
    }

    @Override
    protected ArtifactData readImpl(IndexableField field) throws PandoraException {
        return this.fromStoreValue(field.stringValue());
    }

    private String getAnalyzedField(String field) {
        StringBuilder builder = new StringBuilder(this.getIndexField(field));
        builder.append("|");
        builder.append(ANALYZED_COLUMN);
        return builder.toString();
    }

    private FieldType getAnalyzedFieldType() {
        if (this._analyzedType == null) {
            this._analyzedType = new FieldType();
            this._analyzedType.setStored(false);
            this._analyzedType.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
            this._analyzedType.setTokenized(true);
            this._analyzedType.setStoreTermVectors(true);
            this._analyzedType.setStoreTermVectorPositions(true);
            this._analyzedType.setStoreTermVectorOffsets(true);
            this._analyzedType.freeze();
        }
        return this._analyzedType;
    }

    protected String toAnalyzedValue(ArtifactData artifact) {
        StringBuilder builder = new StringBuilder();
        builder.append("type=");
        builder.append(artifact.getType());
        builder.append(" ");
        builder.append("store=");
        builder.append(artifact.getStore());
        builder.append(" ");
        builder.append("id=");
        builder.append(artifact.getID());
        builder.append(" ");
        builder.append("name=");
        builder.append(artifact.getName());
        return builder.toString();
    }

    protected String toStoreValue(ArtifactData artifact) {
        StringBuilder builder = new StringBuilder();
        builder.append("type=");
        this.appendMaybeNull(builder, artifact.getType());
        builder.append("|");
        builder.append("store=");
        this.appendMaybeNull(builder, artifact.getStore());
        builder.append("|");
        builder.append("id=");
        this.appendMaybeNull(builder, artifact.getID());
        builder.append("|");
        builder.append("name=");
        this.appendMaybeNull(builder, artifact.getName());
        return builder.toString();
    }

    private void appendMaybeNull(StringBuilder builder, String val) {
        if (val != null) {
            builder.append(val);
        }
    }

    protected ArtifactData fromStoreValue(String artifact) {
        int start = artifact.indexOf("=");
        int end = artifact.indexOf("|", start + 1);
        String type = this.readMaybeNull(artifact.substring(start + 1, end));
        start = artifact.indexOf("=", end + 1);
        end = artifact.indexOf("|", start + 1);
        String store = this.readMaybeNull(artifact.substring(start + 1, end));
        start = artifact.indexOf("=", end + 1);
        end = artifact.indexOf("|", start + 1);
        String id = this.readMaybeNull(artifact.substring(start + 1, end));
        start = artifact.indexOf("=", end + 1);
        String name = this.readMaybeNull(artifact.substring(start + 1));
        return new ArtifactData(type, store, id, name);
    }

    private String readMaybeNull(String val) {
        if (val.isEmpty()) {
            return null;
        }
        return val;
    }

    @Override
    public SortField[] getSortFieldsImpl(String property, boolean reverse, boolean emptyFirst) {
        return TypeConverter.get(String.class).getSortFields(this.getIndexField(property), reverse, emptyFirst);
    }

    @Override
    protected Query createFilterImpl(PandoraFilter.Simple parameters) {
        if (ArtifactData.class.isAssignableFrom(parameters.getType())) {
            PandoraFilter.Contains filter;
            PandoraFilter.Contains params;
            if (parameters instanceof PandoraFilter.Contains) {
                params = (PandoraFilter.Contains)parameters;
                filter = new PandoraFilter.Contains(params.getProperty(), (Object[])new String[]{this.get((ArtifactData)params.getValue())});
            } else if (parameters instanceof PandoraFilter.Between) {
                params = (PandoraFilter.Between)parameters;
                filter = new PandoraFilter.Between(params.getProperty(), (Object)this.get((ArtifactData)params.getFrom()), (Object)this.get((ArtifactData)params.getTo()), params.isIncluding());
            } else if (parameters instanceof PandoraFilter.GreaterThan) {
                params = (PandoraFilter.GreaterThan)parameters;
                filter = new PandoraFilter.GreaterThan(params.getProperty(), (Object)this.get((ArtifactData)params.getValue()), params.isIncluding());
            } else if (parameters instanceof PandoraFilter.LessThan) {
                params = (PandoraFilter.LessThan)parameters;
                filter = new PandoraFilter.LessThan(params.getProperty(), (Object)this.get((ArtifactData)params.getValue()), params.isIncluding());
            } else {
                return null;
            }
            String field = this.getIndexField(parameters.getProperty());
            return FilterHelper.createSimpleQuery(field, filter);
        }
        return null;
    }

    private String get(ArtifactData a) {
        return this.toStoreValue(a).toLowerCase();
    }

    private String[] get(ArtifactData[] a) {
        String[] strings = new String[a.length];
        for (int i = 0; i < a.length; ++i) {
            strings[i] = this.get(a[i]);
        }
        return strings;
    }
}

