/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.ui.details;

import com.paterva.maltego.graph.table.io.TabularGraphFileImporterFactory;
import com.paterva.maltego.transforms.tabular.TabularTransformSourceRepository;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.transforms.tabular.ui.details.entities.TabularTransformEntitiesPanel;
import com.paterva.maltego.transforms.tabular.ui.details.files.TabularFilesPanel;
import com.paterva.maltego.transforms.tabular.ui.details.links.TabularTransformLinksPanel;
import com.paterva.maltego.typing.editing.form.InputFormController;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.repository.FunctionalRepositoryListener;
import com.paterva.maltego.util.repository.RepositoryListener;
import com.paterva.maltego.util.ui.components.HeadingTextAndIcon;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class TabularTransformSourceDetailsPanel
extends JPanel {
    private final TabularFilesPanel filesPanel = new TabularFilesPanel();
    private final TabularTransformEntitiesPanel entitiesPanel = new TabularTransformEntitiesPanel();
    private final TabularTransformLinksPanel transformsPanel = new TabularTransformLinksPanel();
    private final String transformSourceName;
    private FunctionalRepositoryListener listener;
    private JPanel entitiesTabPanel;
    private JPanel filesTabPanel;
    private HeadingTextAndIcon headingTextIcon;
    private JButton nameButton;
    private JLabel nameLabel;
    private JPanel namePanel;
    private JTextField nameTextField;
    private JTabbedPane tabPane;
    private JPanel transformsTabPanel;

    public TabularTransformSourceDetailsPanel(String transformSourceName) {
        Args.notNullOrBlank((String)transformSourceName, (String)"transformSourceName");
        this.transformSourceName = transformSourceName;
        this.initComponents();
        this.filesTabPanel.add(this.filesPanel);
        this.entitiesTabPanel.add(this.entitiesPanel);
        this.transformsTabPanel.add(this.transformsPanel);
        this.setBackground(MaltegoLAF.getLookAndFeelDefaults().getColor("3-main-dark-color"));
        this.initHeadingPanel();
        this.updateAll();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.listener = ignored -> this.updateAll();
        TabularTransformSourceRepository.getInstance().addRepositoryListener((RepositoryListener)this.listener);
    }

    @Override
    public void removeNotify() {
        TabularTransformSourceRepository.getInstance().removeRepositoryListener((RepositoryListener)this.listener);
        this.listener = null;
        super.removeNotify();
    }

    private void initHeadingPanel() {
        File dsf;
        Optional importerFactoryOpt;
        List txSourceFiles;
        TabularTransformSource transformSource = this.getTransformSource();
        this.headingTextIcon.setText("Customize column to entity mappings and links between the entities that will be used to generate transforms.");
        this.headingTextIcon.setInsets(new Insets(0, 0, 6, 0));
        if (transformSource != null && (txSourceFiles = transformSource.getSourceFiles()).size() > 0 && (importerFactoryOpt = TabularGraphFileImporterFactory.get((File)(dsf = new File((String)txSourceFiles.get(0))))).isPresent()) {
            this.headingTextIcon.addIcon((Object)((TabularGraphFileImporterFactory)importerFactoryOpt.get()).getImageIcon());
        }
    }

    private void updateAll() {
        TabularTransformSource transformSource = this.getTransformSource();
        this.nameTextField.setText(transformSource.getDisplayName());
        this.filesPanel.setTabularSource(transformSource);
        this.entitiesPanel.setTabularSource(transformSource);
        this.transformsPanel.setTabularSource(transformSource);
    }

    private TabularTransformSource getTransformSource() {
        return (TabularTransformSource)TabularTransformSourceRepository.getInstance().get(this.transformSourceName).orElseThrow(() -> new IllegalStateException("Transform Source no longer exist: " + this.transformSourceName));
    }

    private void initComponents() {
        this.headingTextIcon = new HeadingTextAndIcon();
        this.namePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.nameButton = new JButton();
        this.tabPane = new JTabbedPane();
        this.filesTabPanel = new JPanel();
        this.entitiesTabPanel = new JPanel();
        this.transformsTabPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.headingTextIcon, gridBagConstraints);
        this.namePanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(TabularTransformSourceDetailsPanel.class, (String)"TabularTransformSourceDetailsPanel.nameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.namePanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField.setEditable(false);
        this.nameTextField.setText(NbBundle.getMessage(TabularTransformSourceDetailsPanel.class, (String)"TabularTransformSourceDetailsPanel.nameTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.namePanel.add((Component)this.nameTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.nameButton, (String)NbBundle.getMessage(TabularTransformSourceDetailsPanel.class, (String)"TabularTransformSourceDetailsPanel.nameButton.text"));
        this.nameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabularTransformSourceDetailsPanel.this.nameButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 3, 6, 6);
        this.namePanel.add((Component)this.nameButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.namePanel, gridBagConstraints);
        this.filesTabPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.filesTabPanel.setPreferredSize(new Dimension(600, 400));
        this.filesTabPanel.setLayout(new BorderLayout());
        this.tabPane.addTab(NbBundle.getMessage(TabularTransformSourceDetailsPanel.class, (String)"TabularTransformSourceDetailsPanel.filesTabPanel.TabConstraints.tabTitle"), this.filesTabPanel);
        this.entitiesTabPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.entitiesTabPanel.setLayout(new BorderLayout(6, 6));
        this.tabPane.addTab(NbBundle.getMessage(TabularTransformSourceDetailsPanel.class, (String)"TabularTransformSourceDetailsPanel.entitiesTabPanel.TabConstraints.tabTitle"), this.entitiesTabPanel);
        this.transformsTabPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.transformsTabPanel.setLayout(new BorderLayout(6, 6));
        this.tabPane.addTab(NbBundle.getMessage(TabularTransformSourceDetailsPanel.class, (String)"TabularTransformSourceDetailsPanel.transformsTabPanel.TabConstraints.tabTitle"), this.transformsTabPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabPane, gridBagConstraints);
    }

    private void nameButtonActionPerformed(ActionEvent evt) {
        TabularTransformSource transformSource = this.getTransformSource();
        String propName = "Name";
        InputFormController controller = new InputFormController(propName, (Object)transformSource.getDisplayName());
        EditDialogDescriptor dialogDescriptor = new EditDialogDescriptor("Edit Transform Source Name", (WizardDescriptor.Panel)controller, true);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (NotifyDescriptor.OK_OPTION.equals(result)) {
            try {
                String displayName = (String)controller.getValue(propName);
                TabularTransformSourceRepository.getInstance().update((Object)transformSource.setDisplayName(displayName));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

