/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout.view;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.layout.IncrementalLayoutSettings;
import com.paterva.maltego.layout.view.LayoutHandler;
import com.paterva.maltego.layout.view.ViewLayouter;
import com.paterva.maltego.ui.graph.GraphType;
import com.paterva.maltego.ui.graph.actions.PlaceLabelsAction;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutMode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.util.actions.SystemAction;
import yguard.A.A.D;
import yguard.A.A.Y;
import yguard.A.J.SA;
import yguard.A.J.U;

public class OnceOffLayoutViewHandler
implements LayoutHandler {
    private static final Logger LOG = Logger.getLogger(OnceOffLayoutViewHandler.class.getName());
    public static final String PROP_LAYOUTING = "isLayouting";
    private final U _view;
    private boolean _isLayouting = false;
    private boolean _needsLayouting = false;
    private final Set<Y> _nodesToLayout = new HashSet<Y>();
    private LayoutMode _layoutMode;
    private boolean _layoutAll;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

    OnceOffLayoutViewHandler(U view) {
        this._view = view;
    }

    public void setLayoutMode(LayoutMode newLayoutMode, boolean layoutAll, boolean relayout) {
        this._layoutMode = newLayoutMode;
        this._layoutAll = layoutAll;
        if (relayout) {
            this.scheduleLayout(false, false);
        }
    }

    @Override
    public void onGraphChanged(SA oldGraph, final SA newGraph) {
        if (newGraph != null) {
            final GraphID graphID = GraphIDProvider.forGraph((SA)newGraph);
            LOG.log(Level.FINE, "adding showing listener {0}", graphID);
            GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    LOG.log(Level.FINE, "event {0}", evt.getPropertyName());
                    if ("graphShowing".equals(evt.getPropertyName()) && graphID.equals(evt.getNewValue())) {
                        LOG.log(Level.FINE, "removing listener {0}", graphID);
                        OnceOffLayoutViewHandler.this.placeLabels(newGraph);
                        GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
            });
        }
    }

    @Override
    public void onGraphUpdated(Set<Y> newNodes) {
        this._nodesToLayout.addAll(newNodes);
        this.scheduleLayout(true, this.isIncremental());
    }

    protected void placeLabels(SA graph2D) {
        PlaceLabelsAction action = (PlaceLabelsAction)SystemAction.get(PlaceLabelsAction.class);
        if (action != null) {
            action.perform(graph2D, null);
        }
    }

    protected void scheduleLayout(boolean keepZoom, boolean incremental) {
        if (!this._isLayouting) {
            this.doLayout(keepZoom, incremental);
        } else {
            this._needsLayouting = true;
        }
    }

    protected void doLayout(boolean keepZoom, boolean incremental) {
        if (this._layoutMode == null) {
            this.setLayouting(false);
            return;
        }
        this.setLayouting(true);
        if (!this._layoutAll) {
            ViewLayouter.layoutNodes(this._view, this._nodesToLayout, this._layoutMode, keepZoom, new LayoutDoneHandler(), false);
        } else {
            ViewLayouter.layoutAll(this._view, this._layoutMode, keepZoom, incremental, this._nodesToLayout, new LayoutDoneHandler(), false);
        }
        this._nodesToLayout.clear();
    }

    protected void doneLayouting() {
        if (this._needsLayouting) {
            this._needsLayouting = false;
            this.doLayout(true, this.isIncremental());
        } else {
            this.setLayouting(false);
        }
    }

    public boolean isLayouting() {
        return this._isLayouting;
    }

    private void setLayouting(boolean layouting) {
        if (this._isLayouting != layouting) {
            this._isLayouting = layouting;
            this._changeSupport.firePropertyChange(PROP_LAYOUTING, !this._isLayouting, this._isLayouting);
        }
    }

    private boolean isIncremental() {
        return IncrementalLayoutSettings.getDefault().isIncremental(GraphType.getType((D)this._view.getGraph2D()));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void prepareToShow() {
    }

    @Override
    public void onComponentShowing() {
    }

    @Override
    public void onComponentHidden() {
    }

    @Override
    public void onComponentClosed() {
    }

    protected class LayoutDoneHandler
    implements Runnable {
        protected LayoutDoneHandler() {
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OnceOffLayoutViewHandler.this.doneLayouting();
                }
            });
        }
    }
}

