/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.forms;

import com.paterva.maltego.entity.api.EntityConverter;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.manager.forms.AdvancedSettingsController;
import com.paterva.maltego.entity.manager.forms.DisplayDescriptorEditController;
import com.paterva.maltego.entity.manager.forms.DisplayInfoFormController;
import com.paterva.maltego.entity.manager.forms.EntityInfoFormController;
import com.paterva.maltego.entity.manager.forms.EntityRegistryAction;
import com.paterva.maltego.entity.manager.forms.MainPropertyFormController;
import com.paterva.maltego.entity.registry.converter.AllEntityConverter;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class NewEntityTypeAction
extends EntityRegistryAction {
    public static final String ICON_RESOURCE = "com/paterva/maltego/entity/manager/resources/AddEntity.png";
    private static final String NULL_CATEGORY = "My Entities";

    public String getName() {
        return "New Entity Type (Advanced)";
    }

    public void performAction() {
        MaltegoEntitySpec spec = this.createEntity();
        if (spec != null) {
            if (StringUtilities.isNullOrEmpty((String)spec.getDefaultCategory())) {
                spec.setDefaultCategory(NULL_CATEGORY);
            }
            this.registry().put((TypeSpec)spec);
        }
    }

    protected String getWizardTitle() {
        return "New Entity Wizard (Advanced)";
    }

    private MaltegoEntitySpec createEntity() {
        WizardDescriptor.Panel[] panels = this.getPanels();
        WizardDescriptor wizardDescriptor = new WizardDescriptor(panels);
        wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
        wizardDescriptor.putProperty("entitySpec", (Object)this.getNewEntitySpec());
        wizardDescriptor.putProperty("editMode", (Object)Boolean.FALSE);
        wizardDescriptor.putProperty("entityRegistry", (Object)this.registry());
        wizardDescriptor.putProperty("categories", (Object)this.registry().allCategories());
        wizardDescriptor.setTitleFormat(new MessageFormat("New Entity - {0}"));
        wizardDescriptor.setTitle(this.getWizardTitle());
        if (WizardUtilities.runWizard((WizardDescriptor)wizardDescriptor)) {
            return (MaltegoEntitySpec)wizardDescriptor.getProperty("entitySpec");
        }
        return null;
    }

    protected WizardDescriptor.Panel[] getPanels() {
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{new EntityInfoFormController(), new MainPropertyFormController(), new DisplayDescriptorEditController(), new DisplayInfoFormController(false), new AdvancedSettingsController()};
        return this.initPanels(panels);
    }

    private MaltegoEntitySpec getNewEntitySpec() {
        MaltegoEntitySpec spec = null;
        try {
            FileObject fo = FileUtil.getConfigRoot().getFileObject("Templates/Entity/EntityTemplate.entity");
            DataObject template = DataObject.find((FileObject)fo);
            spec = (MaltegoEntitySpec)template.getLookup().lookup(MaltegoEntitySpec.class);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (spec == null) {
            spec = new MaltegoEntitySpec();
        }
        spec.setConverter((EntityConverter)AllEntityConverter.instance());
        return spec;
    }

    public void actionPerformed(ActionEvent e) {
        this.performAction();
    }
}

