/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.imex.sets;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigExporter;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.manager.imex.sets.TransformSetConfig;
import com.paterva.maltego.transform.manager.imex.sets.TransformSetEntry;
import com.paterva.maltego.util.FileUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;

public class TransformSetExporter
extends ConfigExporter {
    public Config getCurrentConfig() {
        Set sets = TransformSetRepository.getDefault().allSets();
        if (sets.size() > 0) {
            return new TransformSetConfig(sets.toArray(new TransformSet[sets.size()]));
        }
        return null;
    }

    public int saveConfig(MaltegoArchiveWriter writer, Config config) throws IOException {
        TransformSetConfig setConfig = (TransformSetConfig)config;
        TransformSet[] sets = (TransformSet[])setConfig.getSelected();
        ArrayList<String> names = new ArrayList<String>(sets.length);
        for (TransformSet set : sets) {
            String name = FileUtilities.createUniqueLegalFilename(names, (String)set.getName());
            names.add(name);
            writer.write((Entry)new TransformSetEntry(set, name));
        }
        return sets.length;
    }
}

