/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager;

import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.manager.nodes.AllTasesChildFactory;
import com.paterva.maltego.transform.manager.nodes.TransformProperties;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.AbstractNodeSelector;
import com.paterva.maltego.util.ui.outline.OutlineViewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.ActionMap;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeListener;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public class TasManagerTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private final OutlineViewPanel _view = new OutlineViewPanel("Name");
    private final ExplorerManager _explorer = new ExplorerManager();

    public TasManagerTopComponent() {
        this(null);
    }

    public TasManagerTopComponent(String selectTas) {
        this.initComponents();
        this.add((Component)this._view, "Center");
        AbstractNode root = new AbstractNode(Children.create((ChildFactory)new AllTasesChildFactory(), (boolean)false));
        root.addNodeListener((NodeListener)new NodeSelector(selectTas));
        this._explorer.setRootContext((Node)root);
        this._view.getView().setProperties(new Node.Property[]{TransformProperties.status(), TransformProperties.inputConstraint(), TransformProperties.hubItems(), TransformProperties.description()});
        this._view.getView().getOutline().setAutoResizeMode(3);
        this._view.getView().getOutline().getColumnModel().getColumn(0).setPreferredWidth(200);
        this._view.getView().getOutline().getColumnModel().getColumn(1).setPreferredWidth(60);
        this._view.getView().getOutline().getColumnModel().getColumn(2).setPreferredWidth(60);
        this._view.getView().getOutline().getColumnModel().getColumn(3).setPreferredWidth(100);
        this._view.getView().getOutline().getColumnModel().getColumn(4).setPreferredWidth(330);
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this._explorer));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this._explorer));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this._explorer));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this._explorer, (boolean)true));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this._explorer, (ActionMap)map));
        this._explorer.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    Node[] oldSelection = (Node[])evt.getOldValue();
                    TasManagerTopComponent.this.saveTasSettings(oldSelection);
                }
            }
        });
    }

    public ExplorerManager getExplorerManager() {
        return this._explorer;
    }

    private void saveTasSettings(Node[] items) {
        for (Node item : items) {
            this.saveTasSetting(item);
        }
    }

    protected void saveTasSettings() {
        Node[] allNodes = this._explorer.getRootContext().getChildren().getNodes();
        this.saveTasSettings(allNodes);
    }

    private void saveTasSetting(Node item) {
        TransformServerRegistry registry = TransformServerRegistry.getDefault();
        TransformServerInfo info = (TransformServerInfo)item.getLookup().lookup(TransformServerInfo.class);
        if (info != null) {
            registry.put(info);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private void doSelectTas(String tasName) {
        try {
            if (!StringUtilities.isNullOrEmpty((String)tasName)) {
                Node[] allNodes;
                for (Node node : allNodes = this._explorer.getRootContext().getChildren().getNodes()) {
                    TransformServerInfo tas = (TransformServerInfo)node.getLookup().lookup(TransformServerInfo.class);
                    if (tas == null || !tas.getDisplayName().equals(tasName)) continue;
                    this._explorer.setSelectedNodes(new Node[]{node});
                    return;
                }
            }
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void refresh(String selectTas) {
        AbstractNode root = new AbstractNode(Children.create((ChildFactory)new AllTasesChildFactory(), (boolean)false));
        if (selectTas != null) {
            root.addNodeListener((NodeListener)new NodeSelector(selectTas));
        }
        this._explorer.setRootContext((Node)root);
    }

    public void refresh() {
        TransformServerInfo tas;
        String selectedTas = null;
        Node[] node = this._explorer.getSelectedNodes();
        if (node.length > 0 && (tas = (TransformServerInfo)node[0].getLookup().lookup(TransformServerInfo.class)) != null) {
            selectedTas = tas.getDisplayName();
        }
        this.refresh(selectedTas);
    }

    private class NodeSelector
    extends AbstractNodeSelector {
        public NodeSelector(String defaultSelection) {
            super(defaultSelection);
        }

        public void doSelection(String nodeName) {
            TasManagerTopComponent.this.doSelectTas(nodeName);
        }
    }
}

