/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.notifications;

import com.paterva.maltego.notifications.ServerNotificationActionRequest;
import com.paterva.maltego.notifications.data.ServerNotification;
import com.paterva.maltego.notifications.data.ServerNotificationButton;
import java.net.URL;
import org.openide.LifecycleManager;
import org.openide.util.Exceptions;

public class ServerNotificationActionHandler {
    private static final String EXIT_BUTTON_ID = "exit";

    public void handle(ServerNotification notification, ServerNotificationButton button) {
        String buttonID = button.getId();
        if (EXIT_BUTTON_ID.equals(buttonID)) {
            LifecycleManager.getDefault().exit();
        }
        if (button.getUrl().isPresent()) {
            String urlStr = button.getUrl().get();
            try {
                URL url = new URL(urlStr);
                this.sendPost(buttonID, url);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void sendPost(String id, URL url) {
        Thread thread = new Thread(() -> {
            try {
                ServerNotificationActionRequest request = new ServerNotificationActionRequest();
                request.send(id, url);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }, "Notification Action");
        thread.setDaemon(true);
        thread.start();
    }
}

