/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.attachments;

import com.paterva.maltego.core.PropertyBag;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.editing.AttachmentUtils;
import com.paterva.maltego.typing.editing.attachments.AttachmentChildFactory;
import com.paterva.maltego.typing.editing.attachments.AttachmentsAddAction;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.FileSize;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.openide.actions.PasteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class AttachmentsNode
extends AbstractNode {
    private PropertyChangeListener _listener;
    private PropertyBag _propertyBag;
    private PropertyDescriptor _pd;

    public AttachmentsNode(PropertyBag propertyBag, PropertyDescriptor pd, ActionMap am) {
        this(propertyBag, pd, am, new InstanceContent());
    }

    public AttachmentsNode(PropertyBag propertyBag, PropertyDescriptor pd, ActionMap am, InstanceContent content) {
        super(Children.create((ChildFactory)new AttachmentChildFactory(propertyBag, pd), (boolean)true), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.init(content, propertyBag, pd, am);
    }

    private void init(InstanceContent content, PropertyBag propertyBag, PropertyDescriptor pd, ActionMap am) {
        content.add((Object)this);
        content.add((Object)propertyBag);
        content.add((Object)pd);
        if (am != null) {
            content.add((Object)am);
        }
        this._propertyBag = propertyBag;
        this._pd = pd;
        this.updateName();
        this._listener = new AttachmentsListener();
        propertyBag.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._listener, (Object)propertyBag));
    }

    private void updateName() {
        this.setName(this._pd.getDisplayName() + " (" + this.getOrCreateAttachments().size() + ")");
    }

    private Attachments getOrCreateAttachments() {
        return AttachmentUtils.getCopyOrCreateAttachments(this._propertyBag, this._pd);
    }

    public void addFile(File file, FastURL source) throws IOException {
        AttachmentUtils.attachFile(this._propertyBag, this._pd, file, source);
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"com/paterva/maltego/util/ui/FolderClosed.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"com/paterva/maltego/util/ui/FolderOpen.png");
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(AttachmentsAddAction.class), null, SystemAction.get(PasteAction.class)};
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new SizeProperty());
        sheet.put(set);
        return sheet;
    }

    public void addPasteTypes(Transferable t, List<PasteType> s) {
        Node[] cutNodes;
        Node[] copyNodes = NodeTransfer.nodes((Transferable)t, (int)1);
        if (copyNodes != null && copyNodes.length > 0) {
            s.add(new AttachmentPasteType(copyNodes, 1));
        }
        if ((cutNodes = NodeTransfer.nodes((Transferable)t, (int)6)) != null && cutNodes.length > 0) {
            s.add(new AttachmentPasteType(cutNodes, 6));
        }
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            s.add(new FilePasteType(t));
        }
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        super.createPasteTypes(t, s);
        this.addPasteTypes(t, s);
    }

    private class FilePasteType
    extends PasteType {
        private final Transferable _t;

        public FilePasteType(Transferable t) {
            this._t = t;
        }

        public Transferable paste() throws IOException {
            try {
                List fileList = (List)this._t.getTransferData(DataFlavor.javaFileListFlavor);
                AttachmentsAddAction action = (AttachmentsAddAction)SystemAction.get(AttachmentsAddAction.class);
                action.perform(AttachmentsNode.this, fileList);
            }
            catch (UnsupportedFlavorException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }
    }

    private class AttachmentPasteType
    extends PasteType {
        private final Node[] _nodes;
        private int _action;

        public AttachmentPasteType(Node[] nodes, int action) {
            this._nodes = nodes;
            this._action = action;
        }

        public Transferable paste() throws IOException {
            Attachments atts = AttachmentsNode.this.getOrCreateAttachments();
            for (Node node : this._nodes) {
                boolean movingToSameNode;
                boolean bl = movingToSameNode = this._action == 6 && AttachmentsNode.this.equals(node.getParentNode());
                if (movingToSameNode) continue;
                Attachment att = (Attachment)node.getLookup().lookup(Attachment.class);
                if (att != null) {
                    atts.add((Object)att);
                }
                if (this._action != 6) continue;
                node.destroy();
            }
            AttachmentsNode.this._propertyBag.setValue(AttachmentsNode.this._pd, (Object)atts);
            return null;
        }
    }

    private class AttachmentsListener
    implements PropertyChangeListener {
        private AttachmentsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AttachmentsNode.this.updateName();
        }
    }

    public class SizeProperty
    extends PropertySupport.ReadOnly {
        public static final String NAME = "Size";
        public static final String DISPLAYNAME = "Size";

        public SizeProperty() {
            super("Size", Long.TYPE, "Size", "Size of all files");
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            Attachments atts = AttachmentsNode.this.getOrCreateAttachments();
            return new FileSize(AttachmentUtils.getSize((List<Attachment>)atts));
        }
    }
}

