/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.attachments;

import com.paterva.maltego.core.PropertyBag;
import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.editing.attachments.AttachmentsExportAction;
import com.paterva.maltego.typing.editing.attachments.AttachmentsNode;
import com.paterva.maltego.typing.editing.attachments.AttachmentsOpenAction;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.FileSize;
import com.paterva.maltego.util.FileStore;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ImageCallback;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.Action;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class AttachmentNode
extends AbstractNode {
    private PropertyBag _propertyBag;
    private PropertyDescriptor _pd;
    private Attachment _att;
    private PropertyChangeListener _listener;

    public AttachmentNode(PropertyBag propertyBag, PropertyDescriptor pd, Attachment att) {
        this(propertyBag, pd, att, new InstanceContent());
    }

    public AttachmentNode(PropertyBag propertyBag, PropertyDescriptor pd, Attachment att, InstanceContent content) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this._propertyBag = propertyBag;
        this._pd = pd;
        this._att = att;
        this.init(content, propertyBag, att);
    }

    private void init(InstanceContent content, PropertyBag propertyBag, Attachment att) {
        content.add((Object)this);
        content.add((Object)att);
        this.setName(att.getFileName());
        this._listener = new AttachmentsListener();
        propertyBag.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._listener, (Object)propertyBag));
    }

    public Image getIcon(int type) {
        int size = 48;
        if (type == 1 || type == 3) {
            size = 16;
        } else if (type == 2 || type == 4) {
            size = 32;
        }
        Image image = ImageFactory.getDefault().getImage((Object)this._att, size, size, (ImageCallback)new AttachmentImageCallback());
        if (image == null) {
            image = ImageUtilities.loadImage((String)("com/paterva/maltego/util/ui/EmptyImage" + size + ".png"));
        }
        return image;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        Attachments atts = new Attachments(this.getParent());
        atts.remove((Object)this._att);
        this.setParent(atts);
    }

    private Attachments getParent() {
        return (Attachments)this._propertyBag.getValue(this._pd);
    }

    private void setParent(Attachments atts) {
        this._propertyBag.setValue(this._pd, (Object)atts);
    }

    public Action getPreferredAction() {
        return SystemAction.get(AttachmentsOpenAction.class);
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(AttachmentsOpenAction.class), null, SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), null, SystemAction.get(AttachmentsExportAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new SourceProperty());
        set.put((Node.Property)new SizeProperty());
        set.put((Node.Property)new TypeProperty());
        set.put((Node.Property)new PrimaryImageProperty());
        sheet.put(set);
        return sheet;
    }

    public Transferable drag() throws IOException {
        return this.clipboardCut();
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        super.createPasteTypes(t, s);
        Node parentNode = this.getParentNode();
        if (parentNode instanceof AttachmentsNode) {
            AttachmentsNode attsNode = (AttachmentsNode)parentNode;
            attsNode.addPasteTypes(t, s);
        }
    }

    private class AttachmentsListener
    implements PropertyChangeListener {
        private AttachmentsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AttachmentNode.this.fireIconChange();
        }
    }

    public class PrimaryImageProperty
    extends PropertySupport.ReadWrite {
        public static final String NAME = "PrimaryImage";
        public static final String DISPLAYNAME = "<html><center>Primary<br>Image</center></html>";

        public PrimaryImageProperty() {
            super(NAME, Boolean.TYPE, DISPLAYNAME, "Thumbnail image when selecting this property as the image property");
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return AttachmentNode.this._att.equals((Object)AttachmentNode.this.getParent().getPrimaryImage());
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean && !this.getValue().equals(val)) {
                boolean isPrimaryImage = (Boolean)val;
                Attachment att = null;
                if (isPrimaryImage) {
                    att = AttachmentNode.this._att;
                }
                Attachments atts = new Attachments(AttachmentNode.this.getParent());
                atts.setPrimaryImage(att);
                AttachmentNode.this.setParent(atts);
            }
        }
    }

    public class TypeProperty
    extends PropertySupport.ReadOnly {
        public static final String NAME = "Type";
        public static final String DISPLAYNAME = "Type";

        public TypeProperty() {
            super("Type", Long.TYPE, "Type", "File Type");
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return FileUtilities.getFileType((String)AttachmentNode.this._att.getFileName());
        }
    }

    public class SizeProperty
    extends PropertySupport.ReadOnly {
        public static final String NAME = "Size";
        public static final String DISPLAYNAME = "Size";

        public SizeProperty() {
            super("Size", Long.TYPE, "Size", "File Size");
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new FileSize(FileStore.getDefault().getSize(AttachmentNode.this._att.getId()));
        }
    }

    public class SourceProperty
    extends PropertySupport.ReadOnly {
        public static final String NAME = "Source";
        public static final String DISPLAYNAME = "Source";

        public SourceProperty() {
            super("Source", String.class, "Source", "Source");
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            String source;
            FastURL src = AttachmentNode.this._att.getSource();
            String string = source = src != null ? src.toString() : null;
            if (source != null && source.startsWith("file:")) {
                try {
                    File file = new File(new URI(source));
                    source = file.getAbsolutePath();
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return source != null ? source : "";
        }
    }

    private class AttachmentImageCallback
    implements ImageCallback {
        private AttachmentImageCallback() {
        }

        public void imageReady(Image image) {
            AttachmentNode.this.fireIconChange();
        }

        public boolean needAwtThread() {
            return false;
        }
    }
}

