/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tx.inputs.global.ui.view;

import com.paterva.maltego.tx.inputs.global.GlobalTransformInputProvider;
import com.paterva.maltego.tx.inputs.global.ui.view.Bundle;
import com.paterva.maltego.tx.inputs.global.ui.view.GlobalInputsController;
import com.paterva.maltego.util.ui.EmptyPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="GlobalInputsTopComponent", iconBase="", persistenceType=0)
public class GlobalInputsTopComponent
extends TopComponent {
    private static final String PREFERRED_ID = "GlobalInputsTopComponent";
    private static final String EMPTY_VIEW = "empty";
    private static final String GLOBAL_INPUTS_VIEW = "global-inputs";
    private static GlobalInputsTopComponent instance;
    private final GlobalInputsController _controller = new GlobalInputsController();
    private String _currentCard;

    public GlobalInputsTopComponent() {
        instance = this;
        this.setName(Bundle.CTL_GlobalInputsTopComponent());
        this.setToolTipText(Bundle.HINT_GlobalInputsTopComponent());
        this.setLayout(new CardLayout());
        JPanel globalInputsPanel = this._controller.getComponent();
        JScrollPane scrollPane = new JScrollPane(globalInputsPanel, 20, 31);
        this.add((Component)new EmptyPanel("<No Hub Item Global Transform Inputs>"), EMPTY_VIEW);
        scrollPane.getViewport().setBackground(globalInputsPanel.getBackground());
        this.add(scrollPane, GLOBAL_INPUTS_VIEW);
        this.updateCards();
        GlobalTransformInputProvider.getDefault().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlobalInputsTopComponent.this.updateCards();
            }
        });
    }

    private void updateCards() {
        GlobalTransformInputProvider provider = GlobalTransformInputProvider.getDefault();
        int groups = provider.getGlobalInputs().getGroups().size();
        this.showCard(groups == 0 ? EMPTY_VIEW : GLOBAL_INPUTS_VIEW);
    }

    private void showCard(String card) {
        if (!card.equals(this._currentCard)) {
            CardLayout layout = (CardLayout)this.getLayout();
            layout.show((Container)((Object)this), card);
        }
    }

    public static synchronized GlobalInputsTopComponent getDefault() {
        if (instance == null) {
            instance = new GlobalInputsTopComponent();
        }
        return instance;
    }

    public static synchronized GlobalInputsTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(GlobalInputsTopComponent.class.getName()).warning("Cannot find GlobalInputsTopComponent component. It will not be located properly in the window system.");
            return GlobalInputsTopComponent.getDefault();
        }
        if (win instanceof GlobalInputsTopComponent) {
            return (GlobalInputsTopComponent)win;
        }
        Logger.getLogger(GlobalInputsTopComponent.class.getName()).warning("There seem to be multiple components with the 'GlobalInputsTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return GlobalInputsTopComponent.getDefault();
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        GlobalInputsTopComponent singleton = GlobalInputsTopComponent.getDefault();
        singleton.readPropertiesImpl(p);
        return singleton;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }
}

