/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.awt.Font;
import javax.swing.UIDefaults;
import org.openide.util.Lookup;

public class NodeRealizerSettings {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private static final String _overviewFogColor = "graph-overview-fog-color";
    private static final String _valueLinkFont = "graph-link-value-font";
    private static final String _linkSelectionColor = "graph-link-selection-color";
    private static final String _selectionBallBackgroundColor1 = "graph-entity-ball-selection-bg1";
    private static final String _selectionBackgroundColor1 = "graph-entity-selection-bg1";
    private static final String _selectionBorderColor = "graph-entity-selection-ball-border-color";
    private static final String _selectionBorderColor1 = "graph-entity-selection-border-color1";
    private static final String _selectionSloppyBorderColor = "graph-entity-selection-sloppy-border-color";
    private static final String _ballSelectionBorderDraw = "graph-entity-ball-selection-border-draw";
    private static final String _selectionBorderStrokeWidth = "graph-entity-selection-border-stroke-width";
    private static final String _ballBorderStrokeWidth = "graph-entity-ball-border-stroke-width";
    private static final String _valueLabelColor = "graph-entity-label-value-color";
    private static final String _valueLabelFont = "graph-entity-label-value-font";
    private static NodeRealizerSettings _default;

    public static synchronized NodeRealizerSettings getDefault() {
        if (_default == null && (_default = (NodeRealizerSettings)Lookup.getDefault().lookup(NodeRealizerSettings.class)) == null) {
            _default = new NodeRealizerSettings();
        }
        return _default;
    }

    private NodeRealizerSettings() {
    }

    public Color getOverviewFogColor() {
        return LAF.getColor(_overviewFogColor);
    }

    public Color getLinkSelectionColor() {
        return LAF.getColor(_linkSelectionColor);
    }

    public Color getSelectionBallBackgroundColor1() {
        return LAF.getColor(_selectionBallBackgroundColor1);
    }

    public Color getSelectionBackgroundColor1() {
        return LAF.getColor(_selectionBackgroundColor1);
    }

    public Color getSelectionBorderColor() {
        return LAF.getColor(_selectionBorderColor);
    }

    public Color getSelectionBorderColor1() {
        return LAF.getColor(_selectionBorderColor1);
    }

    public Color getSelectionSloppyBorderColor() {
        return LAF.getColor(_selectionSloppyBorderColor);
    }

    public Boolean mustDrawBallSelectionBorder() {
        return LAF.getBoolean(_ballSelectionBorderDraw);
    }

    public float getSelectionBorderStrokeWidth() {
        return Float.parseFloat((String)LAF.get(_selectionBorderStrokeWidth));
    }

    public float getBallBorderStrokeWidth() {
        return Float.parseFloat((String)LAF.get(_ballBorderStrokeWidth));
    }

    public Color getValueLabelColor() {
        return LAF.getColor(_valueLabelColor);
    }

    private Font getFontScaled(String key) {
        Font font = LAF.getFont(key);
        return font;
    }

    public Font getValueLabelFont() {
        return this.getFontScaled(_valueLabelFont);
    }

    public Font getValueLinkFont() {
        return this.getFontScaled(_valueLinkFont);
    }
}

