/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.ui.graph.nodes.ChangeTypeUtil;
import java.awt.Component;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class ChangeTypePanel
extends JPanel {
    private final GraphID _graphID;
    private JList _specList;

    public ChangeTypePanel(GraphID graphID) {
        this._graphID = graphID;
        this.initComponents();
        this._specList.setCellRenderer(new SpecListCellRenderer());
        this._specList.setListData(ChangeTypeUtil.getSortedVisibleSpecs(this._graphID).toArray());
    }

    public MaltegoEntitySpec getEntitySpec() {
        return (MaltegoEntitySpec)this._specList.getSelectedValue();
    }

    public void setEntitySpec(MaltegoEntitySpec spec) {
        int index = 0;
        if (spec != null) {
            ListModel model = this._specList.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                Object listSpec = model.getElementAt(0);
                if (!spec.equals(listSpec)) continue;
                index = i;
                break;
            }
        }
        this._specList.setSelectedIndex(index);
    }

    private void initComponents() {
        JScrollPane jScrollPane1 = new JScrollPane();
        this._specList = new JList();
        this._specList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        jScrollPane1.setViewportView(this._specList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jScrollPane1, -2, 261, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jScrollPane1, -1, 278, Short.MAX_VALUE).addContainerGap()));
    }

    private class SpecListCellRenderer
    extends DefaultListCellRenderer {
        private SpecListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ImageIcon icon;
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            MaltegoEntitySpec spec = (MaltegoEntitySpec)value;
            if (spec != null && (icon = EntityImageFactory.forGraph((GraphID)ChangeTypePanel.this._graphID).getSmallTypeIcon(spec.getTypeName())) != null) {
                this.setIcon(icon);
            }
            return c;
        }
    }
}

