/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates;

import com.paterva.maltego.certificates.CertificateRepository;
import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.certificates.impl.MultiKeyStoreTrustManager;
import com.paterva.maltego.certificates.impl.SimpleX509TrustManager;
import java.io.IOException;
import java.net.Authenticator;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class Installer
extends ModuleInstall {
    public void restored() {
        HostnameVerifier allowSelected = (urlHost, session) -> urlHost.equalsIgnoreCase(CertificateUtils.getPeerHost(session));
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            KeyStore maltegoKeyStore = CertificateRepository.getDefault().getKeyStore(true);
            MultiKeyStoreTrustManager mkstm = new MultiKeyStoreTrustManager(false, false, false, maltegoKeyStore);
            SimpleX509TrustManager trustManager = new SimpleX509TrustManager(mkstm, false, false);
            trustManager.setRequireInCN(null);
            sc.init(null, new TrustManager[]{trustManager}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(allowSelected);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException | GeneralSecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Authenticator authenticator = (Authenticator)Lookup.getDefault().lookup(Authenticator.class);
        if (authenticator != null) {
            Authenticator.setDefault(authenticator);
        }
    }
}

