/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.paterva.maltego.util.ui.dialog.FileController;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardValidationException;

public abstract class SaveFileController
extends FileController {
    public SaveFileController(String fileType, String[] fileExtensions) {
        super(1, fileType, fileExtensions);
    }

    public void validate() throws WizardValidationException {
        String error = null;
        File file = this.getSelectedFile();
        if (file == null || file.isDirectory()) {
            error = "Please choose a file name";
        } else if (file.exists()) {
            if (!file.canWrite()) {
                error = "The selected file is not writable";
            } else {
                NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)"The file exists. Do you want to overwrite it?", "File Exists", 2);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) != NotifyDescriptor.OK_OPTION) {
                    error = " ";
                }
            }
        } else {
            try {
                if (file.createNewFile()) {
                    file.delete();
                } else {
                    error = "The directory is not writable";
                }
            }
            catch (IOException ex) {
                error = "The directory is not writable";
            }
        }
        if (error != null) {
            throw new WizardValidationException((JComponent)this.component(), error, error);
        }
    }
}

