/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.paterva.maltego.util.ui.dialog.ProgressControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;

public class ProgressControlDialog {
    private ProgressControlDialog() {
    }

    public static JDialog create(Window owner, String title, ProgressHandle handle) {
        Component progressBar = ProgressControlDialog.createProgressBar(handle, true);
        ProgressControl panel = new ProgressControl();
        panel.setProgressComponent(progressBar);
        JDialog jDialog = new JDialog(owner);
        jDialog.setDefaultCloseOperation(0);
        jDialog.setContentPane(panel);
        jDialog.setTitle(title);
        jDialog.pack();
        jDialog.setResizable(false);
        jDialog.setModal(true);
        jDialog.setLocationRelativeTo(owner);
        return jDialog;
    }

    protected static Component createProgressBar(ProgressHandle handle, boolean showDetail) {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setPreferredSize(new Dimension(400, 200));
        JLabel main = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)handle);
        JLabel detail = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)handle);
        detail.setText(" ");
        main.setText(" ");
        main.setHorizontalAlignment(2);
        detail.setHorizontalAlignment(4);
        panel.add((Component)main, "North");
        if (showDetail) {
            panel.add((Component)detail, "South");
        }
        panel.add((Component)ProgressHandleFactory.createProgressComponent((ProgressHandle)handle), "Center");
        return panel;
    }
}

