/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.paterva.maltego.util.ui.dialog.FloatingWindowDescriptor;
import com.paterva.maltego.util.ui.dialog.WindowHandle;
import java.awt.Window;
import org.openide.util.Lookup;
import org.openide.windows.WindowManager;

public abstract class FloatingWindowDisplayer {
    public static FloatingWindowDisplayer getDefault() {
        FloatingWindowDisplayer manager = (FloatingWindowDisplayer)Lookup.getDefault().lookup(FloatingWindowDisplayer.class);
        if (manager == null) {
            manager = new TrivialDisplayer();
        }
        return manager;
    }

    public void show(FloatingWindowDescriptor descriptor) {
        this.create(descriptor).setVisible(true);
    }

    public void show(Window parent, FloatingWindowDescriptor descriptor) {
        this.create(parent, descriptor).setVisible(true);
    }

    public WindowHandle create(FloatingWindowDescriptor descriptor) {
        return this.create(WindowManager.getDefault().getMainWindow(), descriptor);
    }

    public abstract WindowHandle create(Window var1, FloatingWindowDescriptor var2);

    private static class TrivialDisplayer
    extends FloatingWindowDisplayer {
        private TrivialDisplayer() {
        }

        @Override
        public WindowHandle create(Window parent, FloatingWindowDescriptor descriptor) {
            throw new UnsupportedOperationException("No WindowDisplayer registered.");
        }
    }
}

