/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.ctxmenu;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.ctxmenu.ContextMenuActionsProvider;
import com.paterva.maltego.util.ui.ctxmenu.PagedPopupMenu;
import com.paterva.maltego.util.ui.ctxmenu.WindowPopupMenu;
import com.paterva.maltego.util.ui.outline.TextQuickFilter;
import com.paterva.maltego.util.ui.treelist.TreeListItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;

public class WindowPopupManager {
    public static final String POPUP_CONTENT_SHOWN = "popupContentShown";
    private static WindowPopupManager _instance;
    private WindowPopupMenu _openMenu;

    private WindowPopupManager() {
    }

    public static synchronized WindowPopupManager getInstance() {
        if (_instance == null) {
            _instance = new WindowPopupManager();
        }
        return _instance;
    }

    public void show(final Set<EntityID> entities, final TreeListItem rootItem, final TextQuickFilter filter, final MouseEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            WindowUtil.showWaitCursor();
                            WindowPopupManager.this.close();
                            Action[] actions = WindowPopupManager.this.findActions(entities);
                            PagedPopupMenu popup = new PagedPopupMenu(actions, rootItem, filter);
                            WindowPopupMenu window = new WindowPopupMenu(){

                                @Override
                                public void removeNotify() {
                                    this.removeAll();
                                    super.removeNotify();
                                    WindowPopupManager.this._openMenu = null;
                                }
                            };
                            window.add(popup);
                            Point adjustedLocation = WindowPopupManager.adjustMouseEventLocation(e);
                            window.setLocation(adjustedLocation);
                            window.pack();
                            window.setVisible(true);
                            WindowPopupManager.this._openMenu = window;
                        }
                        finally {
                            WindowUtil.hideWaitCursor();
                        }
                    }
                });
            }
        });
    }

    public void show(final Component invoker, final JPanel popupContent, MouseEvent e, final int[] popupContentHeight) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WindowUtil.showWaitCursor();
                    WindowPopupManager.this.close();
                    if (WindowPopupManager.isGlobalInputsContent(invoker)) {
                        WindowPopupMenu window = new WindowPopupMenu(){

                            @Override
                            public void removeNotify() {
                                this.removeAll();
                                super.removeNotify();
                                WindowPopupManager.this._openMenu = null;
                            }
                        };
                        window.add(popupContent);
                        if (invoker.isDisplayable() && invoker.isShowing()) {
                            Point invokerOrigin = invoker.getLocationOnScreen();
                            Point p = WindowPopupManager.adjustPointLocation(invokerOrigin, 0, invoker.getPreferredSize().height);
                            Dimension contentSize = popupContent.getPreferredSize();
                            if (popupContentHeight[0] == -1) {
                                popupContentHeight[0] = contentSize.height;
                            } else {
                                contentSize.height = popupContentHeight[0];
                                popupContent.setPreferredSize(contentSize);
                            }
                            GraphicsConfiguration gfxConfig = PagedPopupMenu.getGfxConfig(invoker.getLocationOnScreen());
                            Rectangle screenRect = PagedPopupMenu.getScreenArea(gfxConfig);
                            if ((double)(contentSize.width + p.x) > screenRect.getMaxX()) {
                                p.x = Math.max(screenRect.x, screenRect.x + screenRect.width - contentSize.width);
                            }
                            if ((double)(contentSize.height + p.y) > screenRect.getMaxY()) {
                                p.y = Math.max(screenRect.y, WindowPopupManager.adjustPointLocation((Point)invokerOrigin, (int)0, (int)(-contentSize.height)).y);
                            }
                            window.setLocation(p);
                        }
                        window.pack();
                        window.setVisible(true);
                        WindowPopupManager.this._openMenu = window;
                        popupContent.firePropertyChange(WindowPopupManager.POPUP_CONTENT_SHOWN, false, true);
                    } else {
                        JButton closeButton = new JButton("Close");
                        DialogDescriptor dd = new DialogDescriptor((Object)popupContent, "Date Range", true, (Object[])new JButton[]{closeButton}, (Object)closeButton, 0, HelpCtx.DEFAULT_HELP, null);
                        popupContent.firePropertyChange(WindowPopupManager.POPUP_CONTENT_SHOWN, false, true);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                    }
                }
                finally {
                    WindowUtil.hideWaitCursor();
                }
            }
        });
    }

    private static boolean isGlobalInputsContent(Component c) {
        boolean b = false;
        Container parent = c.getParent();
        if (parent != null && parent instanceof JComponent) {
            b = parent.getClass().getName().contains("com.paterva.maltego.tx.inputs.global.ui.view.GlobalInputsTopComponent") ? true : WindowPopupManager.isGlobalInputsContent(parent);
        }
        return b;
    }

    public void close() {
        if (this._openMenu != null) {
            this._openMenu.close();
            this._openMenu = null;
        }
    }

    public boolean isOpen() {
        return this._openMenu != null && this._openMenu.isShowing();
    }

    private Action[] findActions(Set<EntityID> entities) {
        return ContextMenuActionsProvider.getDefault().getActions();
    }

    public static Point adjustMouseEventLocation(MouseEvent m) {
        Component invoker;
        Object source = m.getSource();
        Point p = null;
        if (source != null && source instanceof Component && (invoker = (Component)source).isDisplayable() && invoker.isShowing()) {
            Point invokerOrigin = invoker.getLocationOnScreen();
            p = WindowPopupManager.adjustPointLocation(invokerOrigin, m.getX(), m.getY());
        }
        p = p == null ? m.getLocationOnScreen() : p;
        return p;
    }

    public static Point adjustPointLocation(Point p, int x, int y) {
        long lx = (long)p.x + (long)x;
        long ly = (long)p.y + (long)y;
        if (lx > Integer.MAX_VALUE) {
            lx = Integer.MAX_VALUE;
        }
        if (lx < Integer.MIN_VALUE) {
            lx = Integer.MIN_VALUE;
        }
        if (ly > Integer.MAX_VALUE) {
            ly = Integer.MAX_VALUE;
        }
        if (ly < Integer.MIN_VALUE) {
            ly = Integer.MIN_VALUE;
        }
        return new Point((int)lx, (int)ly);
    }
}

