/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.button;

import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import javax.swing.UIDefaults;
import org.jdesktop.swingx.color.ColorUtil;

public class ButtonPainter {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    public static final String TEXT_COLOR = "ribbon-button-text-color";
    public static final String DISABLED_TEXT_COLOR = "ribbon-button-disabled-text-color";

    public static void paintSmallSelectedBackground(Graphics2D g2d, int x, int y, int width, int height, boolean rollover) {
        ButtonPainter.paintSmallSelectedBackground(g2d, x, y, width, height, false, false, rollover);
    }

    public static void paintSmallSelectedBackground(Graphics2D g2d, int x, int y, int width, int height, boolean inStrip, boolean firstInStrip, boolean rollover) {
        Color[] colorArray;
        float[] bgFractions;
        int bgy2;
        int bgy1;
        int bgx2;
        int bgx1;
        int r = x + width - 1;
        int b = y + height - 1;
        if (!inStrip) {
            bgx1 = x + 2;
            bgx2 = r - 2;
            bgy1 = y + 4;
            bgy2 = b - 2;
            bgFractions = new float[]{0.0f, 0.499f, 0.5f, 1.0f};
        } else {
            float[] fArray;
            bgx1 = firstInStrip ? x + 1 : x;
            bgx2 = r - 1;
            bgy1 = y + 1;
            bgy2 = b - 1;
            if (rollover) {
                float[] fArray2 = new float[4];
                fArray2[0] = 0.0f;
                fArray2[1] = 0.35f;
                fArray2[2] = 0.351f;
                fArray = fArray2;
                fArray2[3] = 1.0f;
            } else {
                float[] fArray3 = new float[4];
                fArray3[0] = 0.0f;
                fArray3[1] = 0.3f;
                fArray3[2] = 0.31f;
                fArray = fArray3;
                fArray3[3] = 1.0f;
            }
            bgFractions = fArray;
        }
        int bgw = bgx2 - bgx1 + 1;
        int bgh = bgy2 - bgy1 + 1;
        if (!inStrip) {
            // empty if block
        }
        if (rollover) {
            Color[] colorArray2 = new Color[4];
            colorArray2[0] = new Color(16165481);
            colorArray2[1] = new Color(15964500);
            colorArray2[2] = new Color(15761962);
            colorArray = colorArray2;
            colorArray2[3] = new Color(16029212);
        } else {
            Color[] colorArray3 = new Color[4];
            colorArray3[0] = new Color(16636593);
            colorArray3[1] = new Color(16499584);
            colorArray3[2] = new Color(16362312);
            colorArray = colorArray3;
            colorArray3[3] = new Color(16638612);
        }
        Color[] bgGradient = colorArray;
        g2d.setPaint(new LinearGradientPaint(bgx1, bgy1, bgx1, bgy2, bgFractions, bgGradient));
        g2d.fillRect(bgx1, bgy1, bgw, bgh);
    }

    public static void paintBigSelectedBackground(Graphics2D g2d, int x, int y, int width, int height, boolean rollover) {
        Color[] colorArray;
        int r = x + width - 1;
        int b = y + height - 1;
        if (rollover) {
            Color[] colorArray2 = new Color[4];
            colorArray2[0] = new Color(16366209);
            colorArray2[1] = new Color(14912334);
            colorArray2[2] = new Color(14578988);
            colorArray = colorArray2;
            colorArray2[3] = new Color(16039003);
        } else {
            Color[] colorArray3 = new Color[4];
            colorArray3[0] = new Color(16768441);
            colorArray3[1] = new Color(16427099);
            colorArray3[2] = new Color(16289065);
            colorArray = colorArray3;
            colorArray3[3] = new Color(16639129);
        }
        Color[] bgGradient = colorArray;
        g2d.setPaint(new LinearGradientPaint(x + 1, y + 1, x + 1, b - 1, new float[]{0.0f, 0.39f, 0.391f, 1.0f}, bgGradient));
        g2d.fillRect(x + 1, y + 1, width - 2, height - 2);
    }

    public static void paintSmallPressedBackground(Graphics2D g2d, int x, int y, int width, int height) {
        ButtonPainter.paintSmallPressedBackground(g2d, x, y, width, height, false, false, false);
    }

    public static void paintSmallPressedBackground(Graphics2D g2d, int x, int y, int width, int height, boolean inStrip, boolean firstInStrip, boolean lastInStrip) {
        int r = x + width - 1;
        int b = y + height - 1;
        int bx1 = inStrip && !firstInStrip ? x : x + 1;
        int bx2 = r - 1;
        int bw = bx2 - bx1 + 1;
        Color[] pressed1 = RolloverColors.getColoursFromResource(RolloverColors.PRESSED1);
        g2d.setPaint(pressed1[0]);
        g2d.fillRect(bx1, y + 1, bw, height - 2);
    }

    public static void paintBigPressedBackground(Graphics2D g2d, int x, int y, int width, int height) {
        int r = x + width - 1;
        int b = y + height - 1;
        Color[] pressed1 = RolloverColors.getColoursFromResource(RolloverColors.PRESSED1);
        g2d.setPaint(pressed1[0]);
        g2d.fillRect(x + 1, y + 1, width - 2, height - 2);
    }

    public static void paintNormalBackground(Graphics2D g2d, int x, int y, int width, int height) {
        ButtonPainter.paintNormalBackground(g2d, x, y, width, height, false, false, false, false);
    }

    public static void paintNormalBackground(Graphics2D g2d, int x, int y, int width, int height, boolean inStrip, boolean stripVertical, boolean firstInStrip, boolean lastInStrip) {
        int r = x + width - 1;
        int b = y + height - 1;
        int x1 = inStrip && !stripVertical && !firstInStrip ? x : x + 1;
        int y1 = y;
        int x2 = inStrip && !lastInStrip && !stripVertical ? r : r - 1;
        int y2 = inStrip && !lastInStrip && stripVertical ? b : b - 1;
        g2d.setPaint(new LinearGradientPaint(x1, y1, x1, y2, new float[]{0.0f, 0.4f, 0.41f, 1.0f}, new Color[]{new Color(14081759), new Color(14410468), new Color(13818331), new Color(14738919)}));
        g2d.fillRect(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
    }

    public static void paintBigRolloverBackground(Graphics2D g, int x, int y, int width, int height, boolean overlay, boolean paintAsEnabled) {
        Graphics2D g2d = g;
        BufferedImage img = null;
        if (!paintAsEnabled) {
            img = g.getDeviceConfiguration().createCompatibleImage(width, height, 3);
            g2d = img.createGraphics();
            g2d.setClip(g.getClip());
        }
        int r = x + width - 1;
        int b = y + height - 1;
        Color[] bgColors = RolloverColors.getColoursFromResource(RolloverColors.BG);
        if (overlay && paintAsEnabled) {
            g2d.setPaint(RolloverColors.getBgSplitDimColor());
            g2d.fillRect(x + 1, y + 1, width - 2, height - 2);
        } else {
            g2d.setPaint(bgColors[0]);
            g2d.fillRect(x + 1, y + 1, width - 2, height - 2);
        }
        if (!paintAsEnabled) {
            g2d.dispose();
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            ColorConvertOp op = new ColorConvertOp(colorSpace, null);
            g.drawImage(img, op, x, y);
        }
    }

    public static void paintSmallRolloverBackground(Graphics2D g, int x, int y, int width, int height, boolean overlay, boolean paintAsEnabled) {
        ButtonPainter.paintSmallRolloverBackground(g, x, y, width, height, overlay, paintAsEnabled, false, false, false);
    }

    public static void paintSmallRolloverBackground(Graphics2D g, int x, int y, int width, int height, boolean overlay, boolean paintAsEnabled, boolean inStrip, boolean firstInStrip, boolean lastInStrip) {
        Graphics2D g2d = g;
        BufferedImage img = null;
        if (!paintAsEnabled) {
            img = g.getDeviceConfiguration().createCompatibleImage(width, height, 3);
            g2d = img.createGraphics();
            g2d.setClip(g.getClip());
        }
        int r = x + width - 1;
        int b = y + height - 1;
        int x1 = inStrip && !firstInStrip ? x : x + 1;
        int x2 = r - 1;
        int y1 = y + 1;
        int y2 = b - 1;
        int bgw = x2 - x1 + 1;
        int bgh = y2 - y1 + 1;
        if (overlay && paintAsEnabled) {
            g2d.setPaint(RolloverColors.getBgSplitDimColor());
            g2d.fillRect(x1, y1, bgw, bgh);
        } else {
            g2d.setPaint(RolloverColors.getColoursFromResource(RolloverColors.BG)[0]);
            g2d.fillRect(x1, y1, bgw, bgh);
        }
        if (!paintAsEnabled) {
            g2d.dispose();
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            ColorConvertOp op = new ColorConvertOp(colorSpace, null);
            g.drawImage(img, op, x, y);
        }
    }

    protected static Composite setAlpha(Graphics2D g2d, float alpha) {
        Composite oldComposite = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        return oldComposite;
    }

    protected static void resetAlpha(Graphics2D g2d, Composite oldComposite) {
        g2d.setComposite(oldComposite);
    }

    static class RolloverColors {
        protected static String BG = "ribbon-button-bg";
        protected static String BG_SPLIT_DIM = "ribbon-button-bg-dim";
        protected static String PRESSED1 = "ribbon-button-pressed1";

        RolloverColors() {
        }

        private static Color[] getColoursFromResource(String resourceKey) {
            Color[] colours = new Color[LAF.getInt(resourceKey + "-count")];
            for (int i = 0; i < colours.length; ++i) {
                colours[i] = LAF.getColor(resourceKey + "-color" + (i + 1));
            }
            return colours;
        }

        private static Color[] getColourWithAlphaFromResource(String resourceKey) {
            Color[] colours = new Color[LAF.getInt(resourceKey + "-count")];
            for (int i = 0; i < colours.length; ++i) {
                colours[i] = ColorUtil.setAlpha((Color)LAF.getColor(resourceKey + "-color" + (i + 1)), (int)LAF.getInt(resourceKey + "-alpha" + (i + 1)));
            }
            return colours;
        }

        private static Color getBgSplitDimColor() {
            return LAF.getColor(BG_SPLIT_DIM);
        }
    }
}

