/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.query.CommentSet;

class AssignComments
extends ErrorAwareTreeScanner<Void, Void> {
    private static final EnumSet<Tree.Kind> JAVADOC_KINDS = EnumSet.of(Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM, Tree.Kind.METHOD, Tree.Kind.VARIABLE);
    private final CompilationInfo info;
    private final CompilationUnitTree unit;
    private final Tree commentMapTarget;
    private final TokenSequence<JavaTokenId> seq;
    private final CommentHandlerService commentService;
    private final SourcePositions positions;
    private int tokenIndexAlreadyAdded = -1;
    private boolean mapComments;
    private Tree parent = null;
    private int limit = -1;
    private final Map<Tree, Integer> limitCache = new HashMap<Tree, Integer>();
    private static Logger log = Logger.getLogger(AssignComments.class.getName());
    private Set<Integer> mixedJDocTokenIndexes = new HashSet<Integer>();
    private int lastWhiteNewline;

    public AssignComments(CompilationInfo info, Tree commentMapTarget, TokenSequence<JavaTokenId> seq, CompilationUnitTree cut) {
        this(info, commentMapTarget, seq, cut, info.getTrees().getSourcePositions());
    }

    public AssignComments(CompilationInfo info, Tree commentMapTarget, TokenSequence<JavaTokenId> seq, SourcePositions positions) {
        this(info, commentMapTarget, seq, info.getCompilationUnit(), positions);
    }

    private AssignComments(CompilationInfo info, Tree commentMapTarget, TokenSequence<JavaTokenId> seq, CompilationUnitTree cut, SourcePositions positions) {
        this.info = info;
        this.unit = cut;
        this.seq = seq;
        this.commentMapTarget = commentMapTarget;
        this.commentService = CommentHandlerService.instance(info.impl.getJavacTask().getContext());
        this.positions = positions;
    }

    private int setupLimit(Tree t) {
        Tree child;
        int pos = ((JCTree)t).pos;
        switch (t.getKind()) {
            case ASSIGNMENT: {
                child = ((AssignmentTree)t).getVariable();
                break;
            }
            case AND_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                child = ((CompoundAssignmentTree)t).getVariable();
                break;
            }
            case AND: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: 
            case DIVIDE: 
            case EQUAL_TO: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LEFT_SHIFT: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case MINUS: 
            case MULTIPLY: 
            case NOT_EQUAL_TO: 
            case OR: 
            case PLUS: 
            case REMAINDER: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: {
                child = ((BinaryTree)t).getLeftOperand();
                break;
            }
            case INSTANCE_OF: {
                child = ((InstanceOfTree)t).getExpression();
                break;
            }
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: {
                child = ((UnaryTree)t).getExpression();
                break;
            }
            case CONDITIONAL_EXPRESSION: {
                child = ((ConditionalExpressionTree)t).getCondition();
                break;
            }
            case MEMBER_SELECT: {
                child = ((MemberSelectTree)t).getExpression();
                break;
            }
            case VARIABLE: {
                VariableTree varT = (VariableTree)t;
                if (varT.getModifiers() != null) {
                    child = varT.getModifiers();
                    break;
                }
                child = null;
                break;
            }
            case METHOD: {
                MethodTree mT = (MethodTree)t;
                if (mT.getModifiers() != null) {
                    child = mT.getModifiers();
                    break;
                }
                child = null;
                break;
            }
            case CLASS: {
                ClassTree cT = (ClassTree)t;
                if (cT.getModifiers() != null) {
                    child = cT.getModifiers();
                    break;
                }
                child = null;
                break;
            }
            case MODIFIERS: {
                ModifiersTree modT = (ModifiersTree)t;
                List<? extends AnnotationTree> annTs = modT.getAnnotations();
                if (annTs == null || annTs.isEmpty()) {
                    return pos;
                }
                int modPos = ((JCTree)((Object)annTs.get((int)0))).pos;
                if (modPos < pos) {
                    child = annTs.get(0);
                    break;
                }
                child = null;
                break;
            }
            default: {
                return pos;
            }
        }
        if (child != null) {
            Integer x = this.limitCache.get(t);
            if (x != null) {
                return x;
            }
            int l = this.setupLimit(child);
            this.limitCache.put(t, l);
            return l;
        }
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void scan(Tree tree, Void p) {
        if (tree == null) {
            return null;
        }
        boolean oldMapComments = this.mapComments;
        try {
            this.limit = -1;
            this.mapComments |= tree == this.commentMapTarget;
            if (this.commentMapTarget != null && this.info.getTreeUtilities().isSynthetic(new TreePath(new TreePath(this.unit), tree))) {
                Void void_ = null;
                return void_;
            }
            this.limit = this.setupLimit(tree);
            if (this.commentMapTarget != null) {
                this.mapComments2(tree, true, false);
            }
            Tree oldParent = this.parent;
            try {
                this.parent = tree;
                super.scan(tree, p);
            }
            finally {
                this.parent = oldParent;
            }
            if (this.commentMapTarget != null) {
                this.mapComments2(tree, false, tree.getKind() != Tree.Kind.BLOCK || this.parent == null || this.parent.getKind() != Tree.Kind.METHOD);
                if (this.mapComments) {
                    ((CommentSetImpl)this.createCommentSet(tree)).commentsMapped();
                }
            }
            Void void_ = null;
            return void_;
        }
        finally {
            this.mapComments = oldMapComments;
        }
    }

    private void mapComments2(Tree tree, boolean preceding, boolean trailing) {
        if (((JCTree)tree).pos <= 0) {
            return;
        }
        this.collect(tree, preceding, trailing);
    }

    private void collect(Tree tree, boolean preceding, boolean trailing) {
        if (this.isEvil(tree)) {
            return;
        }
        if (preceding) {
            int pos = this.findInterestingStart((JCTree)tree);
            if (pos >= 0) {
                this.seq.move(pos);
                this.lookForPreceedings(this.seq, tree);
            } else {
                pos = ((JCTree)tree).pos;
                this.seq.move(pos);
                this.seq.moveNext();
            }
            if (tree instanceof BlockTree) {
                BlockTree blockTree = (BlockTree)tree;
                if (blockTree.getStatements().isEmpty()) {
                    this.lookWithinEmptyBlock(this.seq, blockTree);
                }
            } else if (tree instanceof ClassTree) {
                Tree mt;
                ClassTree clazz = (ClassTree)tree;
                int cnt = clazz.getMembers().size();
                if (cnt == 1 && (mt = clazz.getMembers().get(0)).getKind() == Tree.Kind.METHOD && this.info.getTreeUtilities().isSynthetic(new TreePath(new TreePath(this.unit), mt))) {
                    --cnt;
                }
                if (cnt == 0) {
                    int cPos = ((JCTree)tree).pos;
                    this.seq.move(cPos);
                    if (this.seq.moveNext()) {
                        this.lookWithinEmptyBlock(this.seq, clazz);
                    }
                }
            }
        } else {
            this.lookForInline(this.seq, tree);
            if (trailing) {
                this.lookForTrailing(this.seq, tree);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "T: " + tree + "\nC: " + this.commentService.getComments(tree));
        }
    }

    private void lookForInline(TokenSequence<JavaTokenId> seq, Tree tree) {
        seq.move((int)this.positions.getEndPosition(this.unit, tree));
        CommentsCollection result = new CommentsCollection();
        while (seq.moveNext()) {
            if (seq.token().id() == JavaTokenId.WHITESPACE) {
                if (this.numberOfNL((Token<JavaTokenId>)seq.token()) <= 0) continue;
                break;
            }
            if (!this.isComment((JavaTokenId)seq.token().id())) break;
            if (this.alreadySeenJavadoc((Token<JavaTokenId>)seq.token(), seq)) continue;
            if (seq.index() > this.tokenIndexAlreadyAdded) {
                result.add((Token<JavaTokenId>)seq.token());
            }
            this.tokenIndexAlreadyAdded = seq.index();
            if (seq.token().id() != JavaTokenId.LINE_COMMENT) continue;
        }
        this.attachComments(tree, result, CommentSet.RelativePosition.INLINE);
    }

    private void attachComments(Tree tree, CommentsCollection result, CommentSet.RelativePosition position) {
        if (!this.mapComments) {
            return;
        }
        if (result.isEmpty()) {
            return;
        }
        CommentSetImpl cs = this.commentService.getComments(tree);
        for (Token<JavaTokenId> token : result) {
            this.attachComment(position, cs, token);
        }
    }

    private boolean isEvil(Tree tree) {
        Tree.Kind kind = tree.getKind();
        switch (kind) {
            case COMPILATION_UNIT: {
                CompilationUnitTree cut = (CompilationUnitTree)tree;
                return cut.getPackageName() == null;
            }
            case PRIMITIVE_TYPE: {
                return true;
            }
        }
        return false;
    }

    private boolean parentEatsTralingComment(TokenSequence<JavaTokenId> seq, Tree t) {
        boolean ok;
        if (this.parent == null || this.lastWhiteNewline == -1) {
            return false;
        }
        int commentIndent = seq.offset() - this.lastWhiteNewline;
        Tree.Kind k = this.parent.getKind();
        boolean bl = ok = k == Tree.Kind.WHILE_LOOP || k == Tree.Kind.DO_WHILE_LOOP || k == Tree.Kind.IF;
        if (!ok) {
            return false;
        }
        int treeIndent = this.countIndent(seq, t);
        return treeIndent < commentIndent;
    }

    private int countIndent(TokenSequence<JavaTokenId> seq, Tree tree) {
        int st = (int)this.positions.getStartPosition(this.unit, tree);
        int save = seq.offset();
        int nl = -1;
        seq.move(st);
        while (seq.movePrevious()) {
            Token tukac = seq.token();
            if (tukac.id() != JavaTokenId.WHITESPACE) {
                if (tukac.id() != JavaTokenId.LINE_COMMENT) break;
                nl = seq.offset() + tukac.length();
                break;
            }
            nl = tukac.text().toString().lastIndexOf(10);
            if (nl == -1) continue;
            break;
        }
        seq.move(save);
        if (!seq.moveNext()) {
            seq.movePrevious();
        }
        return nl == -1 ? -1 : st - nl;
    }

    private boolean alreadySeenJavadoc(Token<JavaTokenId> token, TokenSequence<JavaTokenId> seq) {
        return token.id() == JavaTokenId.JAVADOC_COMMENT && this.mixedJDocTokenIndexes.contains(seq.index());
    }

    private void lookForTrailing(TokenSequence<JavaTokenId> seq, Tree tree) {
        seq.move((int)this.positions.getEndPosition(this.unit, tree));
        LinkedList<TrailingCommentsDataHolder> comments = new LinkedList<TrailingCommentsDataHolder>();
        int maxLines = 0;
        int newlines = 0;
        int lastIndex = -1;
        while (seq.moveNext()) {
            Token t;
            if (lastIndex == -1) {
                lastIndex = seq.index();
            }
            if ((t = seq.token()).id() == JavaTokenId.WHITESPACE) {
                int nls = this.numberOfNL((Token<JavaTokenId>)t, seq.offset());
                newlines += nls;
                continue;
            }
            if (this.isComment((JavaTokenId)t.id())) {
                if (this.alreadySeenJavadoc((Token<JavaTokenId>)t, seq)) continue;
                if (newlines > 0 && this.parentEatsTralingComment(seq, tree)) {
                    return;
                }
                if (seq.index() > this.tokenIndexAlreadyAdded) {
                    comments.add(new TrailingCommentsDataHolder(newlines, (Token<JavaTokenId>)t, lastIndex));
                }
                maxLines = Math.max(maxLines, newlines);
                if (t.id() == JavaTokenId.LINE_COMMENT) {
                    newlines = 1;
                    this.lastWhiteNewline = seq.offset() + t.length();
                } else {
                    newlines = 0;
                    this.lastWhiteNewline = -1;
                }
                lastIndex = -1;
                continue;
            }
            if (t.id() != JavaTokenId.RBRACE && t.id() != JavaTokenId.ELSE) break;
            maxLines = Integer.MAX_VALUE;
            break;
        }
        int index = seq.index() - 1;
        maxLines = Math.max(maxLines, newlines);
        for (TrailingCommentsDataHolder h : comments) {
            boolean assign = false;
            if (h.newlines < maxLines) {
                assign = true;
                if (index >= 0 && maxLines < Integer.MAX_VALUE && seq.token().length() > 0 && h.comment.id() == JavaTokenId.JAVADOC_COMMENT) {
                    TreePath tp = this.info.getTreeUtilities().pathFor(seq.offset() + 1);
                    while (tp.getParentPath() != null && this.positions.getStartPosition(this.info.getCompilationUnit(), tp.getParentPath().getLeaf()) == (long)seq.offset()) {
                        tp = tp.getParentPath();
                    }
                    if (tp != null && JAVADOC_KINDS.contains((Object)tp.getLeaf().getKind())) {
                        assign = false;
                    }
                }
            }
            if (assign) {
                this.attachComments(Collections.singleton(h.comment), tree, CommentSet.RelativePosition.TRAILING);
                continue;
            }
            index = h.index - 1;
            seq.moveIndex(h.index);
            break;
        }
        this.tokenIndexAlreadyAdded = index;
    }

    private void lookWithinEmptyBlock(TokenSequence<JavaTokenId> seq, Tree tree) {
        if (this.moveTo(seq, JavaTokenId.LBRACE, true)) {
            int idx = -1;
            if (seq.moveNext()) {
                JavaTokenId id = (JavaTokenId)seq.token().id();
                idx = seq.index();
                if (id == JavaTokenId.WHITESPACE || this.isComment(id)) {
                    CommentsCollection cc = this.getCommentsCollection(seq, Integer.MAX_VALUE);
                    this.attachComments(tree, cc, CommentSet.RelativePosition.INNER);
                }
            }
            if (this.tokenIndexAlreadyAdded < idx) {
                this.tokenIndexAlreadyAdded = idx;
            }
        } else {
            int end = (int)this.positions.getEndPosition(this.unit, tree);
            seq.move(end);
            seq.moveNext();
        }
    }

    private boolean moveTo(TokenSequence<JavaTokenId> seq, JavaTokenId toToken, boolean forward) {
        if (seq.token() == null) {
            return false;
        }
        do {
            if (toToken != seq.token().id()) continue;
            return true;
        } while (!forward ? seq.movePrevious() : seq.moveNext());
        return false;
    }

    private void lookForPreceedings(TokenSequence<JavaTokenId> seq, Tree tree) {
        int reset;
        int plainCommentLimit = reset = ((JCTree)tree).pos;
        if (this.limit >= 0) {
            plainCommentLimit = Math.min(reset, this.limit);
        }
        CommentsCollection cc = null;
        while (seq.moveNext() && seq.offset() < plainCommentLimit) {
            JavaTokenId id = (JavaTokenId)seq.token().id();
            if (!this.isComment(id)) continue;
            if (cc == null) {
                cc = this.getCommentsCollection(seq, Integer.MAX_VALUE);
                continue;
            }
            cc.merge(this.getCommentsCollection(seq, Integer.MAX_VALUE));
        }
        this.tokenIndexAlreadyAdded = seq.index();
        if (plainCommentLimit < reset && JAVADOC_KINDS.contains((Object)tree.getKind())) {
            int start = reset;
            int end = 0;
            CommentsCollection result = new CommentsCollection();
            while (seq.moveNext() && seq.offset() < reset) {
                JavaTokenId id = (JavaTokenId)seq.token().id();
                if (id != JavaTokenId.JAVADOC_COMMENT) continue;
                this.mixedJDocTokenIndexes.add(seq.index());
                start = Math.min(seq.offset(), start);
                end = Math.max(seq.offset() + seq.token().length(), end);
                result.add((Token<JavaTokenId>)seq.token());
            }
            if (!result.isEmpty()) {
                if (cc == null) {
                    cc = result;
                } else {
                    cc.merge(result);
                }
            }
        }
        this.attachComments(cc, tree, CommentSet.RelativePosition.PRECEDING);
        seq.move(reset);
        seq.moveNext();
    }

    private int findInterestingStart(JCTree tree) {
        boolean previousSucceeded;
        int pos = (int)this.positions.getStartPosition(this.unit, tree);
        if (pos <= 0) {
            return 0;
        }
        this.seq.move(pos);
        boolean ranOnce = false;
        block4: while (previousSucceeded = this.seq.movePrevious() && this.tokenIndexAlreadyAdded < this.seq.index()) {
            ranOnce = true;
            switch ((JavaTokenId)this.seq.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case JAVADOC_COMMENT: 
                case BLOCK_COMMENT: {
                    continue block4;
                }
                case LBRACE: {
                    return this.seq.offset() + this.seq.token().length();
                }
            }
            return this.seq.offset() + this.seq.token().length();
        }
        if (!previousSucceeded && !ranOnce) {
            return -1;
        }
        return this.seq.offset() + (this.tokenIndexAlreadyAdded >= this.seq.index() ? this.seq.token().length() : 0);
    }

    private void attachComments(Iterable<? extends Token<JavaTokenId>> foundComments, Tree tree, CommentSet.RelativePosition positioning) {
        if (foundComments == null || !foundComments.iterator().hasNext() || !this.mapComments) {
            return;
        }
        CommentSetImpl set = (CommentSetImpl)this.createCommentSet(tree);
        if (set.areCommentsMapped()) {
            return;
        }
        for (Token<JavaTokenId> token : foundComments) {
            this.attachComment(positioning, set, token);
        }
    }

    private void attachComment(CommentSet.RelativePosition positioning, CommentSet set, Token<JavaTokenId> comment) {
        Comment c = Comment.create(this.getStyle((JavaTokenId)comment.id()), comment.offset(null), this.getEndPos(comment), -2, this.getText(comment));
        set.addComment(positioning, c);
    }

    private String getText(Token<JavaTokenId> comment) {
        return String.valueOf(comment.text());
    }

    private int getEndPos(Token<JavaTokenId> comment) {
        return comment.offset(null) + comment.length();
    }

    private Comment.Style getStyle(JavaTokenId id) {
        switch (id) {
            case JAVADOC_COMMENT: {
                return Comment.Style.JAVADOC;
            }
            case LINE_COMMENT: {
                return Comment.Style.LINE;
            }
            case BLOCK_COMMENT: {
                return Comment.Style.BLOCK;
            }
        }
        return Comment.Style.WHITESPACE;
    }

    private int numberOfNL(Token<JavaTokenId> t) {
        return this.numberOfNL(t, -1);
    }

    private int numberOfNL(Token<JavaTokenId> t, int offset) {
        int count = 0;
        CharSequence charSequence = t.text();
        for (int i = 0; i < charSequence.length(); ++i) {
            char a = charSequence.charAt(i);
            if ('\n' != a) continue;
            this.lastWhiteNewline = offset + i;
            ++count;
        }
        if (offset == -1) {
            this.lastWhiteNewline = -1;
        }
        return count;
    }

    private CommentsCollection getCommentsCollection(TokenSequence<JavaTokenId> ts, int maxTension) {
        CommentsCollection result = new CommentsCollection();
        Token t = ts.token();
        result.add((Token<JavaTokenId>)t);
        boolean isLC = t.id() == JavaTokenId.LINE_COMMENT;
        int lastCommentIndex = ts.index();
        int start = ts.offset();
        int end = ts.offset() + ts.token().length();
        while (ts.moveNext()) {
            if (ts.index() < this.tokenIndexAlreadyAdded) continue;
            t = ts.token();
            if (this.isComment((JavaTokenId)t.id())) {
                if (t.id() == JavaTokenId.JAVADOC_COMMENT && this.mixedJDocTokenIndexes.contains(ts.index())) continue;
                result.add((Token<JavaTokenId>)t);
                start = Math.min(ts.offset(), start);
                end = Math.max(ts.offset() + t.length(), end);
                isLC = t.id() == JavaTokenId.LINE_COMMENT;
                lastCommentIndex = ts.index();
                continue;
            }
            if (t.id() == JavaTokenId.WHITESPACE && this.numberOfNL((Token<JavaTokenId>)t) + (isLC ? 1 : 0) <= maxTension) continue;
        }
        ts.moveIndex(lastCommentIndex);
        ts.moveNext();
        this.tokenIndexAlreadyAdded = ts.index();
        result.setBounds(new int[]{start, end});
        return result;
    }

    private CommentSet createCommentSet(Tree lastTree) {
        return this.commentService.getComments(lastTree);
    }

    private boolean isComment(JavaTokenId tid) {
        switch (tid) {
            case LINE_COMMENT: 
            case JAVADOC_COMMENT: 
            case BLOCK_COMMENT: {
                return true;
            }
        }
        return false;
    }

    private static class CommentsCollection
    implements Iterable<Token<JavaTokenId>> {
        private final int[] bounds = new int[]{-2, -2};
        private final List<Token<JavaTokenId>> comments = new LinkedList<Token<JavaTokenId>>();

        private CommentsCollection() {
        }

        void add(Token<JavaTokenId> comment) {
            this.comments.add(comment);
        }

        boolean isEmpty() {
            return this.comments.isEmpty();
        }

        @Override
        public Iterator<Token<JavaTokenId>> iterator() {
            return this.comments.iterator();
        }

        void setBounds(int[] bounds) {
            this.bounds[0] = bounds[0];
            this.bounds[1] = bounds[1];
        }

        public int[] getBounds() {
            return (int[])this.bounds.clone();
        }

        public void merge(CommentsCollection cc) {
            this.comments.addAll(cc.comments);
            this.bounds[0] = Math.min(this.bounds[0], cc.bounds[0]);
            this.bounds[1] = Math.max(this.bounds[1], cc.bounds[1]);
        }
    }

    private static final class TrailingCommentsDataHolder {
        private final int newlines;
        private final Token<JavaTokenId> comment;
        private final int index;

        public TrailingCommentsDataHolder(int newlines, Token<JavaTokenId> comment, int index) {
            this.newlines = newlines;
            this.comment = comment;
            this.index = index;
        }
    }
}

