/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editors;

import com.paterva.maltego.typing.Converter;
import java.util.ArrayList;

public class ItemCollection {
    private Class _valueClass;
    private ArrayList<Pair> _pairs = new ArrayList();

    public ItemCollection(Class valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("Value type cannot be null");
        }
        this._valueClass = valueType;
    }

    public Class getType() {
        return this._valueClass;
    }

    public void add(String name, Object value) {
        this._pairs.add(new Pair(name, value));
    }

    public void add(Object value) {
        this._pairs.add(new Pair(value));
    }

    public Object getValue(Object item) {
        if (item instanceof Pair) {
            Pair pair = (Pair)item;
            return pair.getValue();
        }
        return item;
    }

    public Object getItem(Object value) {
        for (Pair p : this._pairs) {
            if (p == null || !(value == null ? p.getValue() == null : value.equals(p.getValue()))) continue;
            return p;
        }
        return null;
    }

    public Object[] toArray() {
        return this._pairs.toArray(new Pair[this._pairs.size()]);
    }

    private class Pair {
        private String _name;
        private Object _value;

        public Pair() {
        }

        public Pair(String name, Object value) {
            this._name = name;
            this._value = value;
        }

        public Pair(Object value) {
            this(null, value);
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public Object getValue() {
            return this._value;
        }

        public void setValue(Object value) {
            this._value = value;
        }

        public String toString() {
            if (this._name == null) {
                if (this._value == null) {
                    return "(null)";
                }
                return Converter.convertTo(this._value, ItemCollection.this._valueClass);
            }
            return this._name;
        }

        public int hashCode() {
            if (this._value == null) {
                return super.hashCode();
            }
            return this._value.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            return this._value == other._value || this._value != null && this._value.equals(other._value);
        }
    }
}

