/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.startup;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineDescriptorComparator;
import com.paterva.maltego.automation.MachineInput;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.view.MachineInputProvider;
import com.paterva.maltego.automation.view.startup.RunActions;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.util.StringUtilities;
import com.pinkmatter.api.flamingo.ResizableIcons;
import com.pinkmatter.api.flamingo.RibbonPresenter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;

public final class RunMachineMenuAction
extends TopGraphAction
implements RibbonPresenter.Button {
    private final Map<MachineDescriptor, JCommandMenuButton> _machines = new HashMap<MachineDescriptor, JCommandMenuButton>();
    private JCommandButton _button;
    private boolean _graphOpen = false;

    public RunMachineMenuAction() {
        LicenseManager.A().A(ignored -> this.update());
        this.update();
    }

    private void update() {
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public void actionPerformed(TopComponent tc) {
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.getRibbonButtonPresenter().setEnabled(value);
    }

    protected boolean isEnabled(TopComponent tc) {
        boolean enabled = super.isEnabled(tc);
        if (this._graphOpen != enabled) {
            this._graphOpen = enabled;
        }
        return super.isEnabled();
    }

    private void updateMenuButtons() {
        this._machines.entrySet().forEach(entry -> {
            JCommandMenuButton button;
            MachineInput machineInput;
            MachineInputProvider inputProvider;
            MachineDescriptor machine = (MachineDescriptor)entry.getKey();
            boolean enabled = true;
            if (machine != null && (inputProvider = MachineInputProvider.getDefault()).isNonInputEntityTypeMachines(machineInput = inputProvider.getInputDescriptor(machine))) {
                if (this._graphOpen) {
                    GraphID graphID = this.getTopGraphID();
                    if (GraphStoreHelper.getEntityIDs((GraphID)graphID).isEmpty() || GraphSelection.forGraph((GraphID)graphID).getSelectedModelEntities().isEmpty() && inputProvider.isLocalScope(machine)) {
                        enabled = false;
                    }
                } else {
                    enabled = false;
                }
            }
            if ((button = (JCommandMenuButton)entry.getValue()) != null) {
                button.setEnabled(enabled);
            }
        });
    }

    public String getName() {
        return "Run Machine";
    }

    public String iconResource() {
        return "com/paterva/maltego/automation/resources/MachineTaskBar.png";
    }

    public AbstractCommandButton getRibbonButtonPresenter() {
        if (this._button == null) {
            this._button = new JCommandButton(this.getName(), ResizableIcons.fromResource((String)this.iconResource()));
            this._button.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
            RichTooltip tooltip = new RichTooltip(this.getName(), "Run a machine in a new graph");
            tooltip.setMainImage(ImageUtilities.loadImage((String)this.iconResource().replace(".png", "48.png")));
            this.addFooter(tooltip);
            this._button.setActionRichTooltip(tooltip);
            this._button.setPopupRichTooltip(tooltip);
            this._button.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                    return RunMachineMenuAction.this.createPopup();
                }
            });
        }
        return this._button;
    }

    private JCommandPopupMenu createPopup() {
        this._machines.clear();
        JCommandPopupMenu menu = new JCommandPopupMenu();
        try {
            ArrayList<? extends MachineDescriptor> machines = new ArrayList<MachineDescriptor>(MachineRepository.getDefault().getAll(true));
            Collections.sort(machines, new MachineDescriptorComparator());
            for (MachineDescriptor machineDescriptor : machines) {
                menu.addMenuButton(this.createMachineMenuButton(machineDescriptor));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (menu.getMenuComponents().isEmpty()) {
            JCommandMenuButton button = new JCommandMenuButton("No machines available...", null);
            button.setEnabled(false);
            menu.addMenuButton(button);
        }
        this.updateMenuButtons();
        return menu;
    }

    private JCommandMenuButton createMachineMenuButton(final MachineDescriptor machine) {
        JCommandMenuButton menuButton = new JCommandMenuButton(machine.getDisplayName(), null);
        RichTooltip tooltip = this.createTooltip(machine);
        if (tooltip != null) {
            menuButton.setActionRichTooltip(tooltip);
        }
        menuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunActions.show(machine);
            }
        });
        this._machines.put(machine, menuButton);
        return menuButton;
    }

    private RichTooltip createTooltip(MachineDescriptor machine) {
        if (!StringUtilities.isNullOrEmpty((String)machine.getDisplayName()) && !StringUtilities.isNullOrEmpty((String)machine.getDescription())) {
            RichTooltip tooltip = new RichTooltip(machine.getDisplayName(), machine.getDescription());
            tooltip.setMainImage(ImageUtilities.loadImage((String)this.iconResource().replace(".png", "48.png")));
            this.addFooter(tooltip);
            return tooltip;
        }
        return null;
    }

    private void addFooter(RichTooltip tooltip) {
        tooltip.addFooterSection("Click the help button to get more help on Maltego features");
        tooltip.setFooterImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Help.png"));
    }
}

