/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.modules.flamingo;

import com.pinkmatter.modules.flamingo.ActionItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

class ActionItems {
    private ActionItems() {
    }

    public static List<? extends ActionItem> forPath(String rootPath) {
        ArrayList<ActionItem> actions = new ArrayList<ActionItem>();
        Map<String, FileObject> foMap = ActionItems.createFileObjectMap(rootPath);
        HashMap<String, Lookup> parentLookupMap = new HashMap<String, Lookup>();
        HashMap parentLookupChildActionItemsMap = new HashMap();
        ArrayList<Lookup.Item> items = new ArrayList<Lookup.Item>();
        ArrayList<String> itemsTempIds = new ArrayList<String>();
        for (Map.Entry<String, FileObject> entrySet : foMap.entrySet()) {
            String nonRootPath = entrySet.getKey();
            String rootPathNonRootPath = rootPath + "/" + nonRootPath;
            String rootPathNonRootPathParent = ActionItems.getParentName(rootPathNonRootPath);
            if (rootPathNonRootPathParent == null) continue;
            try {
                if (parentLookupMap.get(rootPathNonRootPathParent) == null) {
                    parentLookupMap.put(rootPathNonRootPathParent, Lookups.forPath((String)rootPathNonRootPathParent));
                    HashMap<String, Lookup.Result> m = new HashMap<String, Lookup.Result>();
                    m.put(rootPathNonRootPath, ((Lookup)parentLookupMap.get(rootPathNonRootPathParent)).lookup(new Lookup.Template(Object.class, rootPathNonRootPath, null)));
                    parentLookupChildActionItemsMap.put(rootPathNonRootPathParent, m);
                } else if (((Map)parentLookupChildActionItemsMap.get(rootPathNonRootPathParent)).get(rootPathNonRootPath) == null) {
                    ((Map)parentLookupChildActionItemsMap.get(rootPathNonRootPathParent)).put(rootPathNonRootPath, ((Lookup)parentLookupMap.get(rootPathNonRootPathParent)).lookup(new Lookup.Template(Object.class, rootPathNonRootPath, null)));
                }
                Collection itemsTemp = ((Lookup.Result)((Map)parentLookupChildActionItemsMap.get(rootPathNonRootPathParent)).get(rootPathNonRootPath)).allItems();
                for (Lookup.Item itemTemp : itemsTemp) {
                    if (itemsTemp.size() > 1) {
                        System.out.println("WARNING: More than one item returned for " + rootPathNonRootPath + " -- " + (itemTemp != null ? itemTemp.getId() : null));
                    }
                    if (itemTemp == null || itemsTempIds.contains(itemTemp.getId())) continue;
                    items.add(itemTemp);
                    itemsTempIds.add(itemTemp.getId());
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
        }
        TreeMap<String, ActionItem> actionMap = new TreeMap<String, ActionItem>();
        for (Lookup.Item item : items) {
            ActionItems.connectToParent((Lookup.Item<Object>)item, rootPath, actionMap, foMap);
            String rootItem = ActionItems.getRootName(ActionItems.makeRelative(item.getId(), rootPath));
            ActionItem actionItem = (ActionItem)actionMap.get(rootItem);
            if (actions.contains(actionItem)) continue;
            actions.add(actionItem);
        }
        return actions;
    }

    private static Map<String, FileObject> createFileObjectMap(String rootPath) {
        FileObject root = FileUtil.getConfigRoot();
        FileObject folder = root.getFileObject(rootPath);
        LinkedHashMap<String, FileObject> map = new LinkedHashMap<String, FileObject>();
        if (folder != null) {
            for (FileObject fo : FileUtil.getOrder(new ArrayList<FileObject>(Arrays.asList(folder.getChildren())), (boolean)false)) {
                ActionItems.addToMap("", fo, map);
            }
        }
        return map;
    }

    private static void addToMap(String path, FileObject folder, Map<String, FileObject> map) {
        String absolutePath = "";
        if (path.length() > 0) {
            absolutePath = absolutePath + path + "/";
        }
        absolutePath = absolutePath + folder.getName();
        map.put(absolutePath, folder);
        for (FileObject fo : FileUtil.getOrder(new ArrayList<FileObject>(Arrays.asList(folder.getChildren())), (boolean)false)) {
            ActionItems.addToMap(absolutePath, fo, map);
        }
    }

    private static void connectToParent(Lookup.Item<Object> item, String rootPath, Map<String, ActionItem> actionMap, Map<String, FileObject> foMap) {
        String parentName;
        String name = ActionItems.makeRelative(item.getId(), rootPath);
        ActionItem action = ActionItems.getOrCreateActionItem(item, name, actionMap, foMap);
        if (action != null && (parentName = ActionItems.getParentName(name)) != null) {
            ActionItem parent = ActionItems.getOrCreateFolderItem(parentName, actionMap, foMap);
            parent.addChild(action);
        }
    }

    private static String getRootName(String name) {
        int index = name.indexOf(47);
        if (index > 0) {
            return name.substring(0, index);
        }
        return name;
    }

    private static String getParentName(String name) {
        int index = name.lastIndexOf(47);
        if (index > 0) {
            String result = name.substring(0, index);
            return result;
        }
        return null;
    }

    private static ActionItem getOrCreateFolderItem(String name, Map<String, ActionItem> actionMap, Map<String, FileObject> foMap) {
        ActionItem item = actionMap.get(name);
        if (item == null) {
            item = new ActionItem.Compound();
            actionMap.put(name, item);
            ActionItems.addProperties(item, foMap.get(name));
            item.setText(foMap.get(name).getName());
            String parentName = ActionItems.getParentName(name);
            if (parentName != null) {
                ActionItem parent = ActionItems.getOrCreateFolderItem(parentName, actionMap, foMap);
                parent.addChild(item);
            }
        }
        return item;
    }

    private static ActionItem getOrCreateActionItem(Lookup.Item<Object> item, String name, Map<String, ActionItem> actionMap, Map<String, FileObject> foMap) {
        ActionItem actionItem = actionMap.get(name);
        if (actionItem == null) {
            if (Action.class.isAssignableFrom(item.getType())) {
                Action instance = (Action)item.getInstance();
                if (instance != null) {
                    actionItem = ActionItem.leaf(instance);
                }
            } else if (JSeparator.class.isAssignableFrom(item.getType())) {
                actionItem = ActionItem.separator();
                actionItem.setText(foMap.get(name).getName());
            } else if (JComponent.class.isAssignableFrom(item.getType())) {
                JComponent instance = (JComponent)item.getInstance();
                if (instance != null) {
                    actionItem = ActionItem.component(instance);
                }
            } else {
                System.out.println("Unknown item: " + item.getType());
            }
            if (actionItem != null) {
                ActionItems.addProperties(actionItem, foMap.get(name));
                actionMap.put(name, actionItem);
            }
        }
        return actionItem;
    }

    private static void addProperties(ActionItem action, FileObject fo) {
        Enumeration attrs = fo.getAttributes();
        while (attrs.hasMoreElements()) {
            String attr = (String)attrs.nextElement();
            if ("originalFile".equals(attr) || "position".equals(attr)) continue;
            Object value = fo.getAttribute(attr);
            action.putValue(attr, value);
        }
    }

    private static String makeRelative(String name, String rootPath) {
        String result = name.substring(rootPath.length(), name.length());
        if (result.startsWith("/")) {
            result = result.substring(1, result.length());
        }
        return result;
    }
}

