/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.rest;

import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.crypto.SignedData;
import com.paterva.maltego.rest.MaltegoRestRequest;
import com.paterva.maltego.rest.MaltegoRestResponse;
import com.paterva.maltego.rest.RestException;
import com.paterva.maltego.util.Args;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.logging.Logger;

public class MaltegoRestExchange {
    private static final Logger LOG = Logger.getLogger(MaltegoRestRequest.class.getName());
    private final URL url;
    private final MaltegoRestRequest request;
    private boolean checkNonce = true;
    private boolean checkStatus = true;
    private int timeoutMillis = 15000;
    private MaltegoRestResponse response;

    public MaltegoRestExchange(URL url, String xmlRoot, Map<String, String> entries, String accessToken) {
        this(url, new MaltegoRestRequest(xmlRoot, entries, accessToken));
    }

    public MaltegoRestExchange(URL url, MaltegoRestRequest request) {
        Args.notNull((Object)url, (String)"url");
        Args.notNull((Object)request, (String)"request");
        this.url = url;
        this.request = request;
    }

    public void setCheckNonce(boolean checkNonce) {
        this.checkNonce = checkNonce;
    }

    public void setCheckStatus(boolean checkStatus) {
        this.checkStatus = checkStatus;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void sendRequest() throws GeneralSecurityException, IOException, RestException {
        String requestText = this.request.getRequestText();
        LOG.fine(() -> "Request:\n" + requestText);
        String responseText = this.postString(requestText);
        LOG.fine(() -> "Response:\n" + responseText);
        String nonce = this.checkNonce ? this.request.getEntries().get("Nonce") : null;
        this.response = new MaltegoRestResponse(responseText, nonce, this.checkStatus);
    }

    public MaltegoRestResponse getResponse() {
        return this.response;
    }

    public SignedData getSignedData(boolean checkSignature) throws Exception {
        return this.response.getSignedData(checkSignature);
    }

    private String postString(String msg) throws IOException {
        HttpAgent agent = new HttpAgent(this.url);
        agent.setConnectTimeout(this.timeoutMillis);
        agent.setReadTimeout(this.timeoutMillis);
        agent.setAccessToken(this.request.getAccessToken());
        return agent.doPostString("text/xml", msg);
    }
}

