/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.bookmarks.ui;

import com.paterva.maltego.util.ui.GraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.jdesktop.swingx.color.ColorUtil;

public class BookmarkFactory {
    private static BookmarkFactory _instance;

    public static synchronized BookmarkFactory getDefault() {
        if (_instance == null) {
            _instance = new BookmarkFactory();
        }
        return _instance;
    }

    private BookmarkFactory() {
    }

    public int getPrevious(int bookmark) {
        if (--bookmark < -1) {
            bookmark = this.getBookmarkCount() - 1;
        }
        return bookmark;
    }

    public int getNext(int bookmark) {
        if (++bookmark >= this.getBookmarkCount()) {
            bookmark = -1;
        }
        return bookmark;
    }

    public Color getColor(Integer bookmark) {
        int index = this.getValid(bookmark);
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        if (index == -1) {
            Color noneColor = ColorUtil.setAlpha((Color)laf.getColor("bookmark-none-color"), (int)Integer.decode((String)laf.get("bookmark-none-alpha")));
            return noneColor;
        }
        return laf.getColor("bookmark" + (index + 1) + "-color");
    }

    public int getBookmarkCount() {
        return UIManager.getLookAndFeelDefaults().getInt("bookmark-count");
    }

    public Icon getBlackIcon(int size) {
        return new BookmarkIcon(UIManager.getLookAndFeelDefaults().getColor("bookmark-none-color"), size, false);
    }

    public Icon getIcon(Integer bookmark, int size) {
        return new BookmarkIcon(this.getColor(bookmark), size, false);
    }

    public Icon getIcon(Integer bookmark, int size, boolean hovered) {
        return new BookmarkIcon(this.getColor(bookmark), size, hovered);
    }

    public Integer getValid(Integer bookmark) {
        if (bookmark == null) {
            return -1;
        }
        if (bookmark < 0) {
            return -1;
        }
        return bookmark % this.getBookmarkCount();
    }

    private static class BookmarkIcon
    implements Icon {
        private final Color _color;
        private final int _size;
        private final boolean _hovered;

        public BookmarkIcon(Color color, int size, boolean hovered) {
            this._color = color;
            this._size = size;
            this._hovered = hovered;
        }

        @Override
        public int getIconWidth() {
            return this._size;
        }

        @Override
        public int getIconHeight() {
            return this._size;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int xPos, int yPos) {
            if (g instanceof Graphics2D) {
                Graphics2D g2D = (Graphics2D)g.create();
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                double scale = 0.1f;
                g2D.scale(scale, scale);
                int x = (int)((double)xPos / scale);
                int y = (int)((double)yPos / scale);
                int h = (int)((double)this.getIconHeight() / scale);
                g2D.translate(x, y);
                GraphicsUtils.drawBookMark((Graphics2D)g2D, (int)0, (int)0, (int)h, (int)h, (Color)this._color, (boolean)this._hovered);
                g2D.dispose();
            }
        }
    }
}

