/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chatapi.reconnect;

import com.paterva.maltego.chatapi.reconnect.ReconnectState;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.openide.util.Utilities;

public class ReconnectProgress {
    public static final String PROP_STATE_CHANGED = "reconnectStateChanged";
    public static final String PROP_DESCRIPTION_CHANGED = "reconnectDescriptionChanged";
    public static final String PROP_PROGRESS_TEXT_CHANGED = "reconnectProgressTextChanged";
    public static final String PROP_PROGRESS_CHANGED = "reconnectProgressChanged";
    public static final String PROP_WAIT_TIME_CHANGED = "reconnectWaitTimeChanged";
    private ReconnectState _state = ReconnectState.NONE;
    private String _description = "";
    private String _progressText = "";
    private int _progress = -1;
    private int _waitTime = 0;
    private PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

    public synchronized ReconnectState getState() {
        return this._state;
    }

    public synchronized String getDescription() {
        return this._description;
    }

    public synchronized String getProgressText() {
        return this._progressText;
    }

    public synchronized boolean isDeterminate(int progress) {
        return progress >= 0;
    }

    public synchronized int getProgress() {
        return this._progress;
    }

    public synchronized int getWaitSeconds() {
        return this._waitTime;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private void firePropertyChanged(String property, Object oldValue, Object newValue) {
        this._changeSupport.firePropertyChange(property, oldValue, newValue);
    }

    public synchronized void setState(ReconnectState state) {
        if (!Utilities.compareObjects((Object)((Object)this._state), (Object)((Object)state))) {
            ReconnectState oldValue = this._state;
            this._state = state;
            this.firePropertyChanged(PROP_STATE_CHANGED, (Object)oldValue, (Object)this._state);
        }
    }

    public synchronized void setDescription(String description) {
        if (!Utilities.compareObjects((Object)this._description, (Object)description)) {
            String oldValue = this._description;
            this._description = description;
            this.firePropertyChanged(PROP_DESCRIPTION_CHANGED, oldValue, this._description);
        }
    }

    public synchronized void setProgressText(String progressText) {
        if (!Utilities.compareObjects((Object)this._progressText, (Object)progressText)) {
            String oldValue = this._progressText;
            this._progressText = progressText;
            this.firePropertyChanged(PROP_PROGRESS_TEXT_CHANGED, oldValue, this._progressText);
        }
    }

    public synchronized void setProgress(int progress) {
        if (this._progress != progress) {
            int oldValue = this._progress;
            this._progress = progress;
            this.firePropertyChanged(PROP_PROGRESS_CHANGED, oldValue, this._progress);
        }
    }

    public synchronized void setWaitTime(int waitTime) {
        if (this._waitTime != waitTime) {
            int oldValue = this._waitTime;
            this._waitTime = waitTime;
            this.firePropertyChanged(PROP_WAIT_TIME_CHANGED, oldValue, this._waitTime);
        }
    }
}

