/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import com.paterva.maltego.util.MaltegoUrl;
import com.paterva.maltego.util.Version;
import com.paterva.maltego.util.logs.LogFormatter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.openide.modules.ModuleInstall;
import org.openide.modules.Places;
import org.openide.util.Exceptions;

public class Installer
extends ModuleInstall {
    private static final Logger LOG = Logger.getLogger(Installer.class.getName());

    public void restored() {
        LogFormatter.register();
        this.disableOrderingClassWarningLogs();
        File userDir = Places.getUserDirectory();
        File cacheDir = Places.getCacheDirectory();
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        this.checkWritable("User Directory", userDir);
        this.checkWritable("Cache Directory", cacheDir);
        this.checkWritable("Temp Directory", tmpDir);
        this.loadMaltegoUrls();
    }

    private void loadMaltegoUrls() {
        MaltegoUrl.getCurrent();
    }

    private void disableOrderingClassWarningLogs() {
        if (!Version.getCurrent().isDevBuild()) {
            try {
                System.setProperty("org.openide.filesystems.Ordering.level", "" + (Level.WARNING.intValue() + 1));
                LogManager.getLogManager().readConfiguration();
            }
            catch (IOException | SecurityException ex) {
                LOG.log(Level.WARNING, "Failed to disable Ordering class logging for levels <= Level.WARNING: {0}", ex.toString());
            }
            try {
                System.setProperty("io.undertow.level", "" + (Level.INFO.intValue() + 1));
                System.setProperty("org.xnio.level", "" + (Level.INFO.intValue() + 1));
                System.setProperty("org.xnio.nio.level", "" + (Level.INFO.intValue() + 1));
                System.setProperty("org.jboss.threads.level", "" + (Level.INFO.intValue() + 1));
                LogManager.getLogManager().readConfiguration();
            }
            catch (IOException | SecurityException ex) {
                LOG.log(Level.WARNING, "Failed to disable logging for levels <= Level.INFO: {0}", ex.toString());
            }
        }
    }

    private void checkWritable(String dirName, File dir) {
        boolean writable = false;
        Throwable throwable = null;
        try {
            Path tempFile = Files.createTempFile(dir.toPath(), null, null, new FileAttribute[0]);
            writable = tempFile.toFile().canWrite();
            Files.delete(tempFile);
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (throwable != null || !writable) {
            LOG.log(Level.SEVERE, "The {0} is not writable: {1}", new Object[]{dirName, dir});
            if (throwable != null) {
                Exceptions.printStackTrace((Throwable)throwable);
            }
            System.exit(1);
        } else {
            LOG.log(Level.INFO, "The {0} is writable: {1}", new Object[]{dirName, dir});
        }
    }
}

