/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.runviews.ctxmenu;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.runviews.ctxmenu.WindowPopupMode;
import com.paterva.maltego.runviews.list.RootRunProviderTreeListItem;
import com.paterva.maltego.treelist.parts.entity.EntityTable;
import com.paterva.maltego.util.ui.ctxmenu.WindowPopupManager;
import com.paterva.maltego.util.ui.treelist.TreeListItem;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import org.openide.awt.MouseUtils;

public class RunOutlinePopupAdapter
extends MouseUtils.PopupMouseAdapter {
    private final EntityTable _outline;

    public RunOutlinePopupAdapter(EntityTable outline) {
        this._outline = outline;
    }

    protected void showPopup(MouseEvent e) {
        int selRow = this._outline.rowAtPoint(e.getPoint());
        if (selRow != -1) {
            if (!this._outline.getSelectionModel().isSelectedIndex(selRow)) {
                this._outline.getSelectionModel().clearSelection();
                this._outline.getSelectionModel().setSelectionInterval(selRow, selRow);
            }
        } else {
            this._outline.getSelectionModel().clearSelection();
        }
        int[] selRows = this._outline.getSelectedRows();
        HashSet<EntityID> entityIDs = new HashSet<EntityID>(selRows.length);
        for (int i = 0; i < selRows.length; ++i) {
            EntityID n = this.getEntityFromRow(this._outline, selRows[i]);
            if (n == null) continue;
            entityIDs.add(n);
        }
        if (!entityIDs.isEmpty()) {
            RootRunProviderTreeListItem rootItem = WindowPopupMode.getPopupRootItem();
            WindowPopupManager.getInstance().show(entityIDs, (TreeListItem)rootItem, rootItem.getQuickFilter(), e);
        }
    }

    private EntityID getEntityFromRow(EntityTable outline, int rowIndex) {
        int row = outline.convertRowIndexToModel(rowIndex);
        return (EntityID)outline.getTreelistModel().getModelPartID(row);
    }
}

