/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.PropertyBag;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.editing.AbstractAddAttachmentsAction;
import com.paterva.maltego.typing.editing.AttachmentUtils;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.ui.graph.GraphUser;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.actions.TopGraphEntitySelectionAction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.SimilarStrings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AddAttachmentsAction
extends TopGraphEntitySelectionAction {
    private final MyAddAttachmentsAction _delegate = new MyAddAttachmentsAction();

    public AddAttachmentsAction() {
        this.putValue("position", 700);
    }

    public String getName() {
        return "Attach";
    }

    @Override
    protected void actionPerformed() {
        GraphID graphID = this.getTopGraphID();
        List<Object> entities = new ArrayList(GraphStoreHelper.getMaltegoEntities((GraphID)graphID, this.getSelectedModelEntities()));
        if (!entities.isEmpty()) {
            entities = entities.stream().map(entity -> entity.createClone()).collect(Collectors.toList());
            HashMap<MaltegoEntity, MaltegoEntity> entityMap = new HashMap<MaltegoEntity, MaltegoEntity>();
            for (Object entity2 : entities) {
                entityMap.put(entity2.createClone(), (MaltegoEntity)entity2);
            }
            this._delegate.perform(entities);
            String user = GraphUser.getUser(graphID);
            for (Map.Entry entry : entityMap.entrySet()) {
                MaltegoEntity after = (MaltegoEntity)entry.getValue();
                if (((MaltegoEntity)entry.getKey()).isCopy((MaltegoPart)after)) continue;
                ModifiedHelper.updateModified(user, (MaltegoPart<? extends Guid>)after);
            }
            String descriptionStr = "%s " + GraphTransactionHelper.getDescriptionForEntities(graphID, entities, true);
            SimilarStrings similarStrings = new SimilarStrings(descriptionStr, "Add attachment(s) to", "Remove attachment(s) from");
            GraphTransactionHelper.doEntitiesChanged(graphID, similarStrings, entityMap);
        }
    }

    public void perform(MaltegoEntity entity) {
        ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>(1);
        entities.add(entity);
        this._delegate.perform(entities);
    }

    private void attach(MaltegoEntity entity, Attachment att) {
        PropertyDescriptor pd = AttachmentUtils.getOrCreateAttachmentsProperty((PropertyBag)entity);
        AttachmentUtils.attach((PropertyBag)entity, (PropertyDescriptor)pd, (Attachment)att);
    }

    public void perform(MaltegoEntity entity, List<File> files) {
        ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>(1);
        entities.add(entity);
        this._delegate.attachFiles(entities, files);
    }

    public void perform(Map<MaltegoEntity, File> files) {
        HashMap<MaltegoEntity, File> map = new HashMap<MaltegoEntity, File>();
        for (Map.Entry<MaltegoEntity, File> entry : files.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        this._delegate.attachFiles(map);
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/resources/AddAttachmentsAction.png";
    }

    private class MyAddAttachmentsAction
    extends AbstractAddAttachmentsAction {
        private MyAddAttachmentsAction() {
        }

        public void attachFile(Object obj, File file, FastURL source) throws IOException {
            Attachment att = AttachmentUtils.createAttachment((File)file, (FastURL)source);
            AddAttachmentsAction.this.attach((MaltegoEntity)obj, att);
        }

        public void attachFile(List objs, File file, FastURL source) throws IOException {
            if (objs != null) {
                Attachment att = AttachmentUtils.createAttachment((File)file, (FastURL)source);
                for (Object obj : objs) {
                    AddAttachmentsAction.this.attach((MaltegoEntity)obj, att);
                }
            }
        }

        public void done() {
        }
    }
}

