/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import com.paterva.maltego.util.ui.CheckListItem;
import com.paterva.maltego.util.ui.fonts.FontUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;

public final class RadioButtonList
extends JPanel {
    private static final UIDefaults LAF = UIManager.getLookAndFeelDefaults();
    private JList _list = new JList(new DefaultListModel()){

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }
    };
    private RadioButtonItem _selected;
    private ChangeSupport _changeSupport;

    public RadioButtonList() {
        this(new CheckListItem[0]);
    }

    public RadioButtonList(CheckListItem[] items) {
        super(new BorderLayout());
        this._list.setCellRenderer(new CellRenderer());
        this._list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = RadioButtonList.this._list.locationToIndex(e.getPoint());
                if (index != -1) {
                    RadioButtonItem item = (RadioButtonItem)RadioButtonList.this._list.getModel().getElementAt(index);
                    RadioButtonList.this.select(item);
                    RadioButtonList.this.repaint();
                }
            }
        });
        this._list.setSelectionMode(0);
        this.setListItems(items);
        JScrollPane sp = new JScrollPane(this._list);
        this.add((Component)sp, "Center");
        this._changeSupport = new ChangeSupport((Object)this);
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeSupport.removeChangeListener(listener);
    }

    private void select(RadioButtonItem item) {
        if (this._selected != item) {
            if (this._selected != null) {
                this._selected.setSelected(false);
            }
            this._selected = item;
            if (item != null) {
                item.setSelected(true);
            }
            this._changeSupport.fireChange();
        }
    }

    public void setListItems(CheckListItem[] items) {
        DefaultListModel model = (DefaultListModel)this._list.getModel();
        model.clear();
        for (CheckListItem item : items) {
            RadioButtonItem button = new RadioButtonItem(item);
            model.addElement(button);
            if (!item.isSelected()) continue;
            this._selected = button;
        }
    }

    public CheckListItem getSelectedItem() {
        if (this._selected != null) {
            return this._selected.getItem();
        }
        return null;
    }

    public void setSelectedItem(CheckListItem cli) {
        ListModel model = this._list.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            Object elementAt = model.getElementAt(i);
            if (!(elementAt instanceof RadioButtonItem)) continue;
            RadioButtonItem radioButtonItem = (RadioButtonItem)elementAt;
            CheckListItem item = radioButtonItem.getItem();
            if (!cli.getName().equals(item.getName()) || !cli.getDescription().equals(item.getDescription())) continue;
            this.select(radioButtonItem);
            break;
        }
    }

    private static final class RadioButtonItem
    extends JPanel {
        private CheckListItem _item;
        private final JRadioButton _radioButton;
        private final JLabel _description;
        private final JLabel _noteLabel;

        public RadioButtonItem(CheckListItem item) {
            this._item = item;
            this.setLayout(new BorderLayout(0, 0));
            Color bg = LAF.getColor("machine-radio-button-bg");
            Color descriptionColor = LAF.getColor("machine-radio-button-description-fg");
            this.setBackground(bg);
            JPanel headerPanel = new JPanel(new BorderLayout(0, 0));
            headerPanel.setBackground(bg);
            this._radioButton = new JRadioButton(this.getItem().getName(), this.getItem().isSelected());
            this._radioButton.setForeground(LAF.getColor("machine-radio-button-name-fg"));
            this._description = new JLabel(this.getItem().getDescription());
            this._noteLabel = new JLabel(this.getItem().getNote());
            this._description.setFont(FontUtils.defaultScaled(-1.0f));
            this._noteLabel.setFont(FontUtils.defaultScaled(-1.0f));
            this._description.setForeground(descriptionColor);
            this._noteLabel.setForeground(descriptionColor);
            this._description.setBorder(BorderFactory.createEmptyBorder(0, 22, 10, 0));
            this._noteLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
            headerPanel.add((Component)this._radioButton, "West");
            headerPanel.add((Component)this._noteLabel, "East");
            this.add((Component)headerPanel, "North");
            this.add((Component)this._description, "Center");
        }

        public void setSelected(boolean value) {
            this.getItem().setSelected(value);
            this._radioButton.setSelected(value);
        }

        public boolean isSelected() {
            return this._radioButton.isSelected();
        }

        public CheckListItem getItem() {
            return this._item;
        }

        public void setItem(CheckListItem item) {
            this._item = item;
        }
    }

    private static class CellRenderer
    implements ListCellRenderer {
        private CellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return (Component)value;
        }
    }
}

