/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.io.PrintStream;
import java.math.BigDecimal;
import java.util.Date;
import spec.jbb.Company;
import spec.jbb.Customer;
import spec.jbb.DeliveryHandler;
import spec.jbb.District;
import spec.jbb.JBButil;
import spec.jbb.NewOrder;
import spec.jbb.Order;
import spec.jbb.Orderline;
import spec.jbb.Stock;
import spec.jbb.Transaction;
import spec.jbb.Warehouse;
import spec.jbb.infra.Util.TransactionLogBuffer;
import spec.jbb.infra.Util.XMLTransactionLog;

class DeliveryTransaction
extends Transaction {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private Company company;
    private short warehouseId;
    private short carrierId;
    private DeliveryHandler deliveryHandler;
    private Warehouse warehousePtr;
    private long deliveryTime;
    private TransactionLogBuffer deliveryLog;
    private TransactionLogBuffer initLog;
    private TransactionLogBuffer queuedLog;
    private XMLTransactionLog xmlDeliveryLog;
    String[] validationLog = new String[]{"                                     Delivery", "Warehouse:    1", "", "Carrier Number:  3", "", "Execution Status: Delivery has been queued ", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    boolean[] checkLine = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};

    public DeliveryTransaction(Company company, short s) {
        this.company = company;
        this.warehouseId = s;
        this.warehousePtr = this.company.getWarehousePtr(this.warehouseId, false);
        this.deliveryHandler = new DeliveryHandler(company.getOutDeliveriesFile());
        this.deliveryLog = new TransactionLogBuffer();
        this.setupDeliveryLog();
        this.xmlDeliveryLog = new XMLTransactionLog();
        this.initLog = new TransactionLogBuffer(this.deliveryLog);
        this.setupInitLog();
        this.queuedLog = new TransactionLogBuffer(16, 64);
    }

    private void setupDeliveryLog() {
        this.deliveryLog.putText("Delivery", 37, 0, 8);
        this.deliveryLog.putText("Warehouse:", 0, 1, 10);
        this.deliveryLog.putInt(this.warehouseId, 11, 1, 4);
        this.deliveryLog.putText("Carrier Number:", 0, 3, 15);
        this.deliveryLog.putText("Execution Status:", 0, 5, 17);
    }

    private void setupInitLog() {
        this.initLog.putCharFill('9', 16, 3, 2);
        this.initLog.putCharFill('X', 18, 5, 25);
    }

    public String getMenuName() {
        return "Delivery";
    }

    public void delete() {
    }

    public void init() {
        JBButil.getLog().entering("spec.jbb.DeliveryTransaction", "init");
        this.carrierId = (short)JBButil.random(1, 10, this.warehouseId);
        JBButil.getLog().exiting("spec.jbb.DeliveryTransaction", "init");
    }

    public boolean preprocess() {
        Object object;
        this.queuedLog.putText("Warehouse:", 0, 1, 10);
        this.queuedLog.putInt(this.warehouseId, 11, 1, 4);
        this.queuedLog.putText("Carrier ID:", 16, 1, 12);
        this.queuedLog.putInt(this.carrierId, 28, 1, 2);
        this.queuedLog.putText("Items Delivered", 0, 2, 15);
        this.queuedLog.putText("District            Order", 0, 3, 25);
        int n = this.warehousePtr.getDistrictCount();
        Date date = new Date();
        for (int i = 1; i <= n; ++i) {
            Object object2;
            Object object3;
            District district = this.warehousePtr.getDistrict(i);
            object = district.newOrderIter();
            NewOrder newOrder = null;
            Order order = null;
            Customer customer = null;
            block1: while (object.hasNext()) {
                newOrder = (NewOrder)object.next();
                order = newOrder.getOrderPtr();
                customer = order.getCustomerPtr();
                object3 = customer.getBalance();
                if (((BigDecimal)object3).compareTo((BigDecimal)(object2 = order.getTotalAmount())) == -1) continue;
                Orderline[] orderlineArray = order.getOrderlineList();
                for (int j = 0; j < orderlineArray.length; ++j) {
                    Orderline orderline = orderlineArray[j];
                    if (orderline == null) continue;
                    short s = orderline.getQuantity();
                    int n2 = orderline.getItemId();
                    Stock stock = this.warehousePtr.retrieveStock(n2);
                    int n3 = stock.getQuantity();
                    if (n3 < s) continue;
                    stock.changeQuantity(-s);
                    continue block1;
                }
            }
            if (newOrder == null) continue;
            object3 = district.removeNewOrder(newOrder.getId());
            if (Transaction.steadyStateMem) {
                district.removeOldNewOrders(this.company.getInitialOrders() - this.company.getInitialNewOrders());
                district.removeOldOrders(this.company.getInitialOrders());
            }
            object2 = ((NewOrder)object3).getOrderPtr();
            ((Order)object2).setCarrierId(this.carrierId);
            ((Order)object2).dateOrderlines(date);
            this.queuedLog.putInt(district.getId(), 6, i + 3, 2);
            this.queuedLog.putInt(district.getId(), 20, i + 3, 5);
            Customer customer2 = ((Order)object2).getCustomerPtr();
            customer2.adjustBalance(((Order)object2).getTotalAmount());
            customer2.incrementDeliveryCount();
        }
        object = new Date();
        this.queuedLog.putText("Processing finished at:", 0, 14, 23);
        this.queuedLog.putDate((Date)object, 24, 14, 10);
        this.queuedLog.putTime((Date)object, 36, 14, 10);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void display(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            if (Transaction.enableLogWrite) {
                this.queuedLog.display(printStream);
            }
        }
    }

    public void initializeTransactionLog() {
        JBButil.getLog().entering("spec.jbb.DeliveryTransaction", "initializeTransactionLog");
        if (Transaction.enableLogWrite) {
            this.initLog.display();
        }
        JBButil.getLog().exiting("spec.jbb.DeliveryTransaction", "initializeTransactionLog");
    }

    public synchronized void processTransactionLog() {
        JBButil.getLog().entering("spec.jbb.DeliveryTransaction", "processTransactionLog");
        this.deliveryLog.clearBuffer();
        this.xmlDeliveryLog.clear();
        this.setupDeliveryLog();
        this.deliveryLog.putInt(this.carrierId, 16, 3, 2);
        this.deliveryLog.putText("Delivery has been queued", 18, 5, 25);
        this.xmlDeliveryLog.populateXML(this.deliveryLog);
        if (Transaction.enableLogWrite) {
            this.deliveryLog.display();
        }
        if (Transaction.validationFlag) {
            String[] stringArray = this.deliveryLog.validate();
            if (stringArray.length != this.validationLog.length) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("VALIDATION ERROR:  mismatch in screen lengths for DeliveryTransaction");
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Screen length should be:  " + this.validationLog.length);
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Screen length is:  " + stringArray.length);
                JBButil.getLog().warning(stringBuffer.toString());
                Transaction.invalidateRun();
            }
            for (int i = 0; i < this.validationLog.length; ++i) {
                if (!this.checkLine[i] || stringArray[i].equals(this.validationLog[i])) continue;
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("VALIDATION ERROR:  incorrect output for DeliveryTransaction");
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Line " + (i + 1) + " should be:  |" + this.validationLog[i] + "|");
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Line " + (i + 1) + " is:  |" + stringArray[i] + "|");
                JBButil.getLog().warning(stringBuffer.toString());
                Transaction.invalidateRun();
            }
        }
        JBButil.getLog().exiting("spec.jbb.DeliveryTransaction", "processTransactionLog");
    }

    public synchronized boolean process() {
        JBButil.getLog().entering("spec.jbb.DeliveryTransaction", "process");
        Date date = new Date();
        this.queuedLog.clearBuffer();
        this.queuedLog.putText("Queueing Time:", 0, 0, 12);
        this.queuedLog.putDate(date, 12, 0, 10);
        this.queuedLog.putTime(date, 24, 0, 10);
        this.deliveryHandler.handleDelivery(this);
        JBButil.getLog().exiting("spec.jbb.DeliveryTransaction", "process");
        return true;
    }
}

