// Code generated by go generate; DO NOT EDIT.
package opsgenie

import "errors"

type Permission int

const (
    Invalid Permission = iota
    ConfigurationAccess Permission = iota
    Read Permission = iota
    Delete Permission = iota
    CreateAndUpdate Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        ConfigurationAccess: "configuration_access",
        Read: "read",
        Delete: "delete",
        CreateAndUpdate: "create_and_update",
    }

    StringToPermission = map[string]Permission{
        "configuration_access": ConfigurationAccess,
        "read": Read,
        "delete": Delete,
        "create_and_update": CreateAndUpdate,
    }

    PermissionIDs = map[Permission]int{
        ConfigurationAccess: 1,
        Read: 2,
        Delete: 3,
        CreateAndUpdate: 4,
    }

    IdToPermission = map[int]Permission{
        1: ConfigurationAccess,
        2: Read,
        3: Delete,
        4: CreateAndUpdate,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
