package libphonenumber

import "strconv"

const MAX_REGION_CODE_LENGTH = 7

// This structure maps telephone number digits to a particular timezone,
// because a timezones could represent many prefixes, there could be many
// entries for the same timezone.
// For example this is the case for America/New_York.

var CountryCodeToTimeZones = map[int][]string{
	1: []string{
		"America/Anguilla",
		"America/Antigua",
		"America/Barbados",
		"America/Cayman",
		"America/Chicago",
		"America/Denver",
		"America/Dominica",
		"America/Edmonton",
		"America/Grand_Turk",
		"America/Grenada",
		"America/Halifax",
		"America/Jamaica",
		"America/Juneau",
		"America/Los_Angeles",
		"America/Lower_Princes",
		"America/Montserrat",
		"America/Nassau",
		"America/New_York",
		"America/Port_of_Spain",
		"America/Puerto_Rico",
		"America/Santo_Domingo",
		"America/St_Johns",
		"America/St_Kitts",
		"America/St_Lucia",
		"America/St_Thomas",
		"America/St_Vincent",
		"America/Toronto",
		"America/Tortola",
		"America/Vancouver",
		"America/Winnipeg",
		"Atlantic/Bermuda",
		"Pacific/Guam",
		"Pacific/Honolulu",
		"Pacific/Pago_Pago",
		"Pacific/Saipan",
	},
	1201:    []string{"America/New_York"},
	1202:    []string{"America/New_York"},
	1203:    []string{"America/New_York"},
	1204:    []string{"America/Winnipeg"},
	1205:    []string{"America/Chicago"},
	1206:    []string{"America/Los_Angeles"},
	1207:    []string{"America/New_York"},
	120822:  []string{"America/Denver"},
	120823:  []string{"America/Denver"},
	120824:  []string{"America/Los_Angeles"},
	1208251: []string{"America/Denver"},
	1208253: []string{"America/Denver"},
	1208254: []string{"America/Denver"},
	1208255: []string{"America/Los_Angeles"},
	1208258: []string{"America/Denver"},
	120826:  []string{"America/Los_Angeles"},
	120827:  []string{"America/Denver"},
	120828:  []string{"America/Denver"},
	1208290: []string{"America/Los_Angeles"},
	1208292: []string{"America/Los_Angeles"},
	1208297: []string{"America/Denver"},
	12083:   []string{"America/Denver"},
	120840:  []string{"America/Denver"},
	120841:  []string{"America/Denver"},
	120842:  []string{"America/Denver"},
	1208433: []string{"America/Denver"},
	1208436: []string{"America/Denver"},
	1208437: []string{"America/Los_Angeles"},
	1208438: []string{"America/Denver"},
	1208440: []string{"America/Denver"},
	1208442: []string{"America/Denver"},
	1208443: []string{"America/Los_Angeles"},
	1208448: []string{"America/Los_Angeles"},
	1208452: []string{"America/Denver"},
	1208453: []string{"America/Denver"},
	1208454: []string{"America/Denver"},
	1208455: []string{"America/Denver"},
	1208457: []string{"America/Los_Angeles"},
	1208459: []string{"America/Denver"},
	120846:  []string{"America/Denver"},
	1208473: []string{"America/Denver"},
	1208475: []string{"America/Denver"},
	1208476: []string{"America/Los_Angeles"},
	1208478: []string{"America/Denver"},
	120848:  []string{"America/Denver"},
	120849:  []string{"America/Denver"},
	12085:   []string{"America/Denver"},
	120860:  []string{"America/Denver"},
	120861:  []string{"America/Los_Angeles"},
	1208622: []string{"America/Denver"},
	1208623: []string{"America/Los_Angeles"},
	1208624: []string{"America/Denver"},
	1208628: []string{"America/Los_Angeles"},
	1208629: []string{"America/Denver"},
	120863:  []string{"America/Denver"},
	120864:  []string{"America/Denver"},
	120865:  []string{"America/Denver"},
	120866:  []string{"America/Los_Angeles"},
	1208672: []string{"America/Denver"},
	1208676: []string{"America/Los_Angeles"},
	1208677: []string{"America/Denver"},
	1208678: []string{"America/Denver"},
	1208682: []string{"America/Los_Angeles"},
	1208683: []string{"America/Los_Angeles"},
	1208684: []string{"America/Denver"},
	1208686: []string{"America/Los_Angeles"},
	1208687: []string{"America/Los_Angeles"},
	120869:  []string{"America/Los_Angeles"},
	120870:  []string{"America/Denver"},
	120871:  []string{"America/Denver"},
	120872:  []string{"America/Denver"},
	120873:  []string{"America/Denver"},
	1208743: []string{"America/Los_Angeles"},
	1208745: []string{"America/Denver"},
	1208746: []string{"America/Los_Angeles"},
	1208755: []string{"America/Los_Angeles"},
	1208756: []string{"America/Denver"},
	1208762: []string{"America/Los_Angeles"},
	1208765: []string{"America/Los_Angeles"},
	1208766: []string{"America/Denver"},
	1208769: []string{"America/Los_Angeles"},
	120877:  []string{"America/Los_Angeles"},
	1208782: []string{"America/Denver"},
	1208783: []string{"America/Los_Angeles"},
	1208784: []string{"America/Los_Angeles"},
	1208785: []string{"America/Denver"},
	1208787: []string{"America/Denver"},
	1208788: []string{"America/Denver"},
	1208794: []string{"America/Denver"},
	1208798: []string{"America/Los_Angeles"},
	1208799: []string{"America/Los_Angeles"},
	1208814: []string{"America/Denver"},
	1208818: []string{"America/Los_Angeles"},
	1208835: []string{"America/Los_Angeles"},
	1208837: []string{"America/Denver"},
	120884:  []string{"America/Denver"},
	120885:  []string{"America/Denver"},
	120886:  []string{"America/Denver"},
	1208870: []string{"America/Denver"},
	1208875: []string{"America/Los_Angeles"},
	1208878: []string{"America/Denver"},
	1208879: []string{"America/Denver"},
	1208880: []string{"America/Denver"},
	1208881: []string{"America/Denver"},
	1208882: []string{"America/Los_Angeles"},
	1208883: []string{"America/Los_Angeles"},
	1208884: []string{"America/Denver"},
	1208885: []string{"America/Los_Angeles"},
	1208886: []string{"America/Denver"},
	1208887: []string{"America/Denver"},
	1208888: []string{"America/Denver"},
	120889:  []string{"America/Denver"},
	120890:  []string{"America/Denver"},
	1208921: []string{"America/Denver"},
	1208922: []string{"America/Denver"},
	1208926: []string{"America/Los_Angeles"},
	1208934: []string{"America/Denver"},
	1208935: []string{"America/Los_Angeles"},
	1208936: []string{"America/Denver"},
	1208938: []string{"America/Denver"},
	1208939: []string{"America/Denver"},
	120894:  []string{"America/Denver"},
	120895:  []string{"America/Denver"},
	120896:  []string{"America/Los_Angeles"},
	120898:  []string{"America/Los_Angeles"},
	120899:  []string{"America/Denver"},
	1209:    []string{"America/Los_Angeles"},
	1210:    []string{"America/Chicago"},
	1212:    []string{"America/New_York"},
	1213:    []string{"America/Los_Angeles"},
	1214:    []string{"America/Chicago"},
	1215:    []string{"America/New_York"},
	1216:    []string{"America/New_York"},
	1217:    []string{"America/Chicago"},
	1218:    []string{"America/Chicago"},
	121922:  []string{"America/Chicago"},
	121925:  []string{"America/New_York"},
	121926:  []string{"America/Chicago"},
	121927:  []string{"America/New_York"},
	121928:  []string{"America/Chicago"},
	12193:   []string{"America/Chicago"},
	12194:   []string{"America/Chicago"},
	12195:   []string{"America/Chicago"},
	12196:   []string{"America/Chicago"},
	12197:   []string{"America/Chicago"},
	12198:   []string{"America/Chicago"},
	12199:   []string{"America/Chicago"},
	1224:    []string{"America/Chicago"},
	1225:    []string{"America/Chicago"},
	1226:    []string{"America/Toronto"},
	1228:    []string{"America/Chicago"},
	1229:    []string{"America/New_York"},
	123:     []string{"America/New_York"},
	1240:    []string{"America/New_York"},
	1242:    []string{"America/Nassau"},
	1246:    []string{"America/Barbados"},
	1248:    []string{"America/New_York"},
	125021:  []string{"America/Vancouver"},
	125022:  []string{"America/Vancouver"},
	1250242: []string{"America/Edmonton"},
	1250245: []string{"America/Vancouver"},
	1250246: []string{"America/Vancouver"},
	1250247: []string{"America/Vancouver"},
	1250248: []string{"America/Vancouver"},
	125025:  []string{"America/Vancouver"},
	1250260: []string{"America/Vancouver"},
	1250261: []string{"America/Edmonton"},
	1250262: []string{"America/Edmonton"},
	1250263: []string{"America/Edmonton"},
	1250265: []string{"America/Vancouver"},
	125028:  []string{"America/Vancouver"},
	125029:  []string{"America/Vancouver"},
	125030:  []string{"America/Vancouver"},
	125031:  []string{"America/Vancouver"},
	125033:  []string{"America/Vancouver"},
	125034:  []string{"America/Edmonton"},
	125035:  []string{"America/Vancouver"},
	125036:  []string{"America/Vancouver"},
	125037:  []string{"America/Vancouver"},
	125038:  []string{"America/Vancouver"},
	125039:  []string{"America/Vancouver"},
	1250412: []string{"America/Vancouver"},
	1250417: []string{"America/Edmonton"},
	125042:  []string{"America/Edmonton"},
	125044:  []string{"America/Vancouver"},
	125045:  []string{"America/Vancouver"},
	125046:  []string{"America/Vancouver"},
	125047:  []string{"America/Vancouver"},
	1250480: []string{"America/Vancouver"},
	1250483: []string{"America/Vancouver"},
	1250487: []string{"America/Vancouver"},
	1250488: []string{"America/Vancouver"},
	1250489: []string{"America/Edmonton"},
	125049:  []string{"America/Vancouver"},
	12505:   []string{"America/Vancouver"},
	12506:   []string{"America/Vancouver"},
	125070:  []string{"America/Vancouver"},
	125071:  []string{"America/Vancouver"},
	1250714: []string{"America/Vancouver"},
	1250715: []string{"America/Vancouver"},
	1250716: []string{"America/Vancouver"},
	1250717: []string{"America/Vancouver"},
	1250718: []string{"America/Vancouver"},
	1250719: []string{"America/Edmonton"},
	125072:  []string{"America/Vancouver"},
	125074:  []string{"America/Vancouver"},
	125075:  []string{"America/Vancouver"},
	125076:  []string{"America/Vancouver"},
	125077:  []string{"America/Vancouver"},
	125078:  []string{"America/Edmonton"},
	12508:   []string{"America/Vancouver"},
	12509:   []string{"America/Vancouver"},
	1251:    []string{"America/Chicago"},
	1252:    []string{"America/New_York"},
	1253:    []string{"America/Los_Angeles"},
	1254:    []string{"America/Chicago"},
	1256:    []string{"America/Chicago"},
	1260:    []string{"America/New_York"},
	1262:    []string{"America/Chicago"},
	1264:    []string{"America/Anguilla"},
	1267:    []string{"America/New_York"},
	1268:    []string{"America/Antigua"},
	1269:    []string{"America/New_York"},
	1270230: []string{"America/Chicago"},
	1270234: []string{"America/New_York"},
	1270236: []string{"America/Chicago"},
	1270237: []string{"America/Chicago"},
	127024:  []string{"America/Chicago"},
	127025:  []string{"America/Chicago"},
	127026:  []string{"America/Chicago"},
	127027:  []string{"America/Chicago"},
	127028:  []string{"America/Chicago"},
	127029:  []string{"America/Chicago"},
	127033:  []string{"America/Chicago"},
	127034:  []string{"America/Chicago"},
	127035:  []string{"America/New_York"},
	1270360: []string{"America/New_York"},
	1270362: []string{"America/Chicago"},
	1270365: []string{"America/Chicago"},
	1270369: []string{"America/New_York"},
	127038:  []string{"America/Chicago"},
	127039:  []string{"America/Chicago"},
	127041:  []string{"America/Chicago"},
	127042:  []string{"America/New_York"},
	127043:  []string{"America/Chicago"},
	127044:  []string{"America/Chicago"},
	1270462: []string{"America/Chicago"},
	1270465: []string{"America/New_York"},
	1270469: []string{"America/New_York"},
	127047:  []string{"America/Chicago"},
	127048:  []string{"America/Chicago"},
	12705:   []string{"America/Chicago"},
	127062:  []string{"America/Chicago"},
	127063:  []string{"America/Chicago"},
	127064:  []string{"America/Chicago"},
	127065:  []string{"America/Chicago"},
	127066:  []string{"America/Chicago"},
	127067:  []string{"America/Chicago"},
	127068:  []string{"America/Chicago"},
	1270691: []string{"America/Chicago"},
	1270692: []string{"America/New_York"},
	1270699: []string{"America/New_York"},
	127070:  []string{"America/Chicago"},
	127072:  []string{"America/Chicago"},
	127073:  []string{"America/New_York"},
	127074:  []string{"America/Chicago"},
	127075:  []string{"America/Chicago"},
	1270761: []string{"America/Chicago"},
	1270762: []string{"America/Chicago"},
	1270763: []string{"America/New_York"},
	1270765: []string{"America/New_York"},
	1270766: []string{"America/New_York"},
	1270767: []string{"America/Chicago"},
	1270769: []string{"America/New_York"},
	127077:  []string{"America/Chicago"},
	1270780: []string{"America/Chicago"},
	1270781: []string{"America/Chicago"},
	1270782: []string{"America/Chicago"},
	1270783: []string{"America/Chicago"},
	1270786: []string{"America/Chicago"},
	1270789: []string{"America/New_York"},
	127079:  []string{"America/Chicago"},
	1270821: []string{"America/Chicago"},
	1270824: []string{"America/Chicago"},
	1270825: []string{"America/Chicago"},
	1270826: []string{"America/Chicago"},
	1270827: []string{"America/Chicago"},
	1270828: []string{"America/New_York"},
	127083:  []string{"America/Chicago"},
	127084:  []string{"America/Chicago"},
	127085:  []string{"America/Chicago"},
	1270862: []string{"America/New_York"},
	1270864: []string{"America/Chicago"},
	1270866: []string{"America/Chicago"},
	1270877: []string{"America/New_York"},
	1270879: []string{"America/Chicago"},
	127088:  []string{"America/Chicago"},
	127089:  []string{"America/Chicago"},
	127090:  []string{"America/Chicago"},
	127092:  []string{"America/Chicago"},
	127093:  []string{"America/Chicago"},
	127096:  []string{"America/Chicago"},
	1270982: []string{"America/New_York"},
	1270988: []string{"America/Chicago"},
	1276:    []string{"America/New_York"},
	1281:    []string{"America/Chicago"},
	1284:    []string{"America/Tortola"},
	1289:    []string{"America/Toronto"},
	1301:    []string{"America/New_York"},
	1302:    []string{"America/New_York"},
	1303:    []string{"America/Denver"},
	1304:    []string{"America/New_York"},
	1305:    []string{"America/New_York"},
	13062:   []string{"America/Winnipeg"},
	13063:   []string{"America/Winnipeg"},
	13064:   []string{"America/Winnipeg"},
	13065:   []string{"America/Winnipeg"},
	13066:   []string{"America/Winnipeg"},
	13067:   []string{"America/Winnipeg"},
	130682:  []string{"America/Edmonton"},
	130683:  []string{"America/Winnipeg"},
	130684:  []string{"America/Winnipeg"},
	130686:  []string{"America/Winnipeg"},
	130687:  []string{"America/Winnipeg"},
	130688:  []string{"America/Winnipeg"},
	130689:  []string{"America/Edmonton"},
	13069:   []string{"America/Winnipeg"},
	1307:    []string{"America/Denver"},
	1308233: []string{"America/Chicago"},
	1308234: []string{"America/Chicago"},
	1308235: []string{"America/Denver"},
	1308236: []string{"America/Chicago"},
	1308237: []string{"America/Chicago"},
	130824:  []string{"America/Denver"},
	130825:  []string{"America/Denver"},
	130826:  []string{"America/Denver"},
	130828:  []string{"America/Denver"},
	1308324: []string{"America/Chicago"},
	1308327: []string{"America/Denver"},
	130834:  []string{"America/Chicago"},
	130835:  []string{"America/Denver"},
	130836:  []string{"America/Chicago"},
	130838:  []string{"America/Chicago"},
	1308394: []string{"America/Denver"},
	1308398: []string{"America/Chicago"},
	1308423: []string{"America/Denver"},
	1308425: []string{"America/Chicago"},
	130843:  []string{"America/Denver"},
	130844:  []string{"America/Chicago"},
	130845:  []string{"America/Chicago"},
	130846:  []string{"America/Chicago"},
	13085:   []string{"America/Chicago"},
	130862:  []string{"America/Denver"},
	130863:  []string{"America/Denver"},
	130866:  []string{"America/Denver"},
	130867:  []string{"America/Chicago"},
	130869:  []string{"America/Chicago"},
	130872:  []string{"America/Chicago"},
	130874:  []string{"America/Chicago"},
	130875:  []string{"America/Chicago"},
	130876:  []string{"America/Denver"},
	130877:  []string{"America/Denver"},
	130878:  []string{"America/Chicago"},
	130883:  []string{"America/Chicago"},
	130886:  []string{"America/Chicago"},
	1308872: []string{"America/Chicago"},
	1308874: []string{"America/Denver"},
	130888:  []string{"America/Denver"},
	13089:   []string{"America/Chicago"},
	1309:    []string{"America/Chicago"},
	1310:    []string{"America/Los_Angeles"},
	1312:    []string{"America/Chicago"},
	1313:    []string{"America/New_York"},
	1314:    []string{"America/Chicago"},
	1315:    []string{"America/New_York"},
	1316:    []string{"America/Chicago"},
	1317:    []string{"America/New_York"},
	1318:    []string{"America/Chicago"},
	1319:    []string{"America/Chicago"},
	1320:    []string{"America/Chicago"},
	1321:    []string{"America/New_York"},
	1323:    []string{"America/Los_Angeles"},
	1325:    []string{"America/Chicago"},
	1330:    []string{"America/New_York"},
	1334:    []string{"America/Chicago"},
	1336:    []string{"America/New_York"},
	1337:    []string{"America/Chicago"},
	1340:    []string{"America/St_Thomas"},
	1345:    []string{"America/Cayman"},
	1346:    []string{"America/Chicago"},
	1347:    []string{"America/New_York"},
	135:     []string{"America/New_York"},
	1360:    []string{"America/Los_Angeles"},
	1361:    []string{"America/Chicago"},
	1385:    []string{"America/Denver"},
	1386:    []string{"America/New_York"},
	1401:    []string{"America/New_York"},
	14022:   []string{"America/Chicago"},
	140231:  []string{"America/Chicago"},
	140232:  []string{"America/Chicago"},
	140233:  []string{"America/Chicago"},
	140234:  []string{"America/Chicago"},
	140235:  []string{"America/Chicago"},
	140236:  []string{"America/Chicago"},
	1402370: []string{"America/Chicago"},
	1402371: []string{"America/Chicago"},
	1402372: []string{"America/Chicago"},
	1402373: []string{"America/Chicago"},
	1402374: []string{"America/Chicago"},
	1402375: []string{"America/Chicago"},
	1402376: []string{"America/Denver"},
	1402379: []string{"America/Chicago"},
	140238:  []string{"America/Chicago"},
	140239:  []string{"America/Chicago"},
	14024:   []string{"America/Chicago"},
	14025:   []string{"America/Chicago"},
	14026:   []string{"America/Chicago"},
	14027:   []string{"America/Chicago"},
	14028:   []string{"America/Chicago"},
	14029:   []string{"America/Chicago"},
	1403:    []string{"America/Edmonton"},
	1404:    []string{"America/New_York"},
	1405:    []string{"America/Chicago"},
	1406:    []string{"America/Denver"},
	1407:    []string{"America/New_York"},
	1408:    []string{"America/Los_Angeles"},
	1409:    []string{"America/Chicago"},
	1410:    []string{"America/New_York"},
	1412:    []string{"America/New_York"},
	1413:    []string{"America/New_York"},
	1414:    []string{"America/Chicago"},
	1415:    []string{"America/Los_Angeles"},
	1416:    []string{"America/Toronto"},
	1417:    []string{"America/Chicago"},
	1418:    []string{"America/Toronto"},
	1419:    []string{"America/New_York"},
	14232:   []string{"America/New_York"},
	14233:   []string{"America/New_York"},
	142342:  []string{"America/New_York"},
	142343:  []string{"America/New_York"},
	1423442: []string{"America/New_York"},
	1423447: []string{"America/Chicago"},
	142345:  []string{"America/New_York"},
	142346:  []string{"America/New_York"},
	142347:  []string{"America/New_York"},
	142348:  []string{"America/New_York"},
	142349:  []string{"America/New_York"},
	14235:   []string{"America/New_York"},
	142361:  []string{"America/New_York"},
	142362:  []string{"America/New_York"},
	142363:  []string{"America/New_York"},
	142364:  []string{"America/New_York"},
	1423652: []string{"America/New_York"},
	1423658: []string{"America/Chicago"},
	142366:  []string{"America/New_York"},
	142369:  []string{"America/New_York"},
	14237:   []string{"America/New_York"},
	142382:  []string{"America/New_York"},
	142383:  []string{"America/Chicago"},
	142384:  []string{"America/New_York"},
	142385:  []string{"America/New_York"},
	142386:  []string{"America/New_York"},
	142387:  []string{"America/New_York"},
	142388:  []string{"America/New_York"},
	142389:  []string{"America/New_York"},
	142391:  []string{"America/New_York"},
	142392:  []string{"America/New_York"},
	142394:  []string{"America/Chicago"},
	142395:  []string{"America/New_York"},
	142396:  []string{"America/New_York"},
	142397:  []string{"America/New_York"},
	142398:  []string{"America/New_York"},
	1424:    []string{"America/Los_Angeles"},
	1425:    []string{"America/Los_Angeles"},
	1432:    []string{"America/Chicago"},
	1434:    []string{"America/New_York"},
	1435:    []string{"America/Denver"},
	1438:    []string{"America/Toronto"},
	1440:    []string{"America/New_York"},
	1441:    []string{"Atlantic/Bermuda"},
	1443:    []string{"America/New_York"},
	145:     []string{"America/Toronto"},
	146:     []string{"America/Chicago"},
	1470:    []string{"America/New_York"},
	1473:    []string{"America/Grenada"},
	1478:    []string{"America/New_York"},
	1479:    []string{"America/Chicago"},
	1480:    []string{"America/Denver"},
	1484:    []string{"America/New_York"},
	1501:    []string{"America/Chicago"},
	1502:    []string{"America/New_York"},
	1503:    []string{"America/Los_Angeles"},
	1504:    []string{"America/Chicago"},
	1505:    []string{"America/Denver"},
	1506:    []string{"America/Halifax"},
	1507:    []string{"America/Chicago"},
	1508:    []string{"America/New_York"},
	1509:    []string{"America/Los_Angeles"},
	1510:    []string{"America/Los_Angeles"},
	1512:    []string{"America/Chicago"},
	1513:    []string{"America/New_York"},
	1514:    []string{"America/Toronto"},
	1515:    []string{"America/Chicago"},
	1516:    []string{"America/New_York"},
	1517:    []string{"America/New_York"},
	1518:    []string{"America/New_York"},
	1519:    []string{"America/Toronto"},
	152:     []string{"America/Denver"},
	1530:    []string{"America/Los_Angeles"},
	1534:    []string{"America/Chicago"},
	1540:    []string{"America/New_York"},
	15412:   []string{"America/Los_Angeles"},
	154130:  []string{"America/Los_Angeles"},
	154131:  []string{"America/Los_Angeles"},
	154132:  []string{"America/Los_Angeles"},
	154133:  []string{"America/Los_Angeles"},
	154134:  []string{"America/Los_Angeles"},
	154135:  []string{"America/Los_Angeles"},
	154136:  []string{"America/Los_Angeles"},
	154137:  []string{"America/Denver"},
	154138:  []string{"America/Los_Angeles"},
	154139:  []string{"America/Los_Angeles"},
	154140:  []string{"America/Los_Angeles"},
	154141:  []string{"America/Los_Angeles"},
	154142:  []string{"America/Los_Angeles"},
	154143:  []string{"America/Los_Angeles"},
	154144:  []string{"America/Los_Angeles"},
	154145:  []string{"America/Los_Angeles"},
	154146:  []string{"America/Los_Angeles"},
	1541471: []string{"America/Los_Angeles"},
	1541472: []string{"America/Los_Angeles"},
	1541473: []string{"America/Denver"},
	1541474: []string{"America/Los_Angeles"},
	1541475: []string{"America/Los_Angeles"},
	1541476: []string{"America/Los_Angeles"},
	1541479: []string{"America/Los_Angeles"},
	154148:  []string{"America/Los_Angeles"},
	154149:  []string{"America/Los_Angeles"},
	15415:   []string{"America/Los_Angeles"},
	15416:   []string{"America/Los_Angeles"},
	15417:   []string{"America/Los_Angeles"},
	154180:  []string{"America/Los_Angeles"},
	154181:  []string{"America/Los_Angeles"},
	154182:  []string{"America/Los_Angeles"},
	154183:  []string{"America/Los_Angeles"},
	154184:  []string{"America/Los_Angeles"},
	154185:  []string{"America/Los_Angeles"},
	154186:  []string{"America/Los_Angeles"},
	154187:  []string{"America/Los_Angeles"},
	1541881: []string{"America/Denver"},
	1541882: []string{"America/Los_Angeles"},
	1541883: []string{"America/Los_Angeles"},
	1541884: []string{"America/Los_Angeles"},
	1541885: []string{"America/Los_Angeles"},
	1541888: []string{"America/Los_Angeles"},
	1541889: []string{"America/Denver"},
	154189:  []string{"America/Los_Angeles"},
	15419:   []string{"America/Los_Angeles"},
	155:     []string{"America/Los_Angeles"},
	1561:    []string{"America/New_York"},
	1562:    []string{"America/Los_Angeles"},
	1563:    []string{"America/Chicago"},
	1570:    []string{"America/New_York"},
	1571:    []string{"America/New_York"},
	1573:    []string{"America/Chicago"},
	15742:   []string{"America/New_York"},
	15743:   []string{"America/New_York"},
	15744:   []string{"America/New_York"},
	15745:   []string{"America/New_York"},
	15746:   []string{"America/New_York"},
	157472:  []string{"America/New_York"},
	157475:  []string{"America/New_York"},
	1574772: []string{"America/Chicago"},
	1574773: []string{"America/New_York"},
	157478:  []string{"America/New_York"},
	157482:  []string{"America/New_York"},
	157483:  []string{"America/New_York"},
	157484:  []string{"America/New_York"},
	157485:  []string{"America/New_York"},
	157486:  []string{"America/New_York"},
	157487:  []string{"America/New_York"},
	1574892: []string{"America/New_York"},
	1574893: []string{"America/New_York"},
	1574896: []string{"America/Chicago"},
	15749:   []string{"America/New_York"},
	1575:    []string{"America/Denver"},
	1580:    []string{"America/Chicago"},
	1581:    []string{"America/Toronto"},
	1585:    []string{"America/New_York"},
	1586:    []string{"America/New_York"},
	1587:    []string{"America/Edmonton"},
	1601:    []string{"America/Chicago"},
	1602:    []string{"America/Denver"},
	1603:    []string{"America/New_York"},
	1604:    []string{"America/Vancouver"},
	160521:  []string{"America/Chicago"},
	1605221: []string{"America/Chicago"},
	1605223: []string{"America/Denver"},
	1605224: []string{"America/Chicago"},
	1605225: []string{"America/Chicago"},
	1605226: []string{"America/Chicago"},
	1605229: []string{"America/Chicago"},
	160523:  []string{"America/Chicago"},
	160525:  []string{"America/Chicago"},
	160526:  []string{"America/Chicago"},
	1605271: []string{"America/Chicago"},
	1605274: []string{"America/Chicago"},
	1605275: []string{"America/Chicago"},
	1605279: []string{"America/Denver"},
	160529:  []string{"America/Chicago"},
	160531:  []string{"America/Chicago"},
	160532:  []string{"America/Chicago"},
	160533:  []string{"America/Chicago"},
	1605341: []string{"America/Denver"},
	1605342: []string{"America/Denver"},
	1605343: []string{"America/Denver"},
	1605345: []string{"America/Chicago"},
	1605347: []string{"America/Denver"},
	1605348: []string{"America/Denver"},
	1605351: []string{"America/Chicago"},
	1605352: []string{"America/Chicago"},
	1605353: []string{"America/Chicago"},
	1605355: []string{"America/Denver"},
	1605356: []string{"America/Chicago"},
	1605357: []string{"America/Chicago"},
	1605359: []string{"America/Chicago"},
	160536:  []string{"America/Chicago"},
	1605371: []string{"America/Chicago"},
	1605373: []string{"America/Chicago"},
	1605374: []string{"America/Denver"},
	1605384: []string{"America/Chicago"},
	1605387: []string{"America/Chicago"},
	1605388: []string{"America/Denver"},
	1605393: []string{"America/Denver"},
	1605394: []string{"America/Denver"},
	1605397: []string{"America/Chicago"},
	1605399: []string{"America/Denver"},
	160542:  []string{"America/Chicago"},
	160543:  []string{"America/Chicago"},
	160544:  []string{"America/Chicago"},
	160545:  []string{"America/Denver"},
	160547:  []string{"America/Chicago"},
	1605484: []string{"America/Denver"},
	1605487: []string{"America/Chicago"},
	160549:  []string{"America/Chicago"},
	160552:  []string{"America/Chicago"},
	160553:  []string{"America/Chicago"},
	160554:  []string{"America/Chicago"},
	160557:  []string{"America/Denver"},
	1605582: []string{"America/Chicago"},
	1605584: []string{"America/Denver"},
	1605589: []string{"America/Chicago"},
	160559:  []string{"America/Chicago"},
	160561:  []string{"America/Chicago"},
	160562:  []string{"America/Chicago"},
	1605642: []string{"America/Denver"},
	1605644: []string{"America/Denver"},
	1605647: []string{"America/Chicago"},
	1605649: []string{"America/Chicago"},
	1605665: []string{"America/Chicago"},
	1605666: []string{"America/Denver"},
	1605668: []string{"America/Chicago"},
	1605669: []string{"America/Chicago"},
	160567:  []string{"America/Denver"},
	160568:  []string{"America/Denver"},
	160569:  []string{"America/Chicago"},
	160571:  []string{"America/Denver"},
	1605720: []string{"America/Denver"},
	1605721: []string{"America/Denver"},
	1605722: []string{"America/Denver"},
	1605723: []string{"America/Denver"},
	1605724: []string{"America/Chicago"},
	1605725: []string{"America/Chicago"},
	160573:  []string{"America/Chicago"},
	1605745: []string{"America/Denver"},
	1605747: []string{"America/Chicago"},
	160575:  []string{"America/Chicago"},
	160576:  []string{"America/Chicago"},
	160577:  []string{"America/Chicago"},
	160578:  []string{"America/Denver"},
	1605791: []string{"America/Denver"},
	1605796: []string{"America/Chicago"},
	160582:  []string{"America/Denver"},
	1605835: []string{"America/Chicago"},
	1605837: []string{"America/Denver"},
	160584:  []string{"America/Chicago"},
	1605852: []string{"America/Chicago"},
	1605853: []string{"America/Chicago"},
	1605854: []string{"America/Chicago"},
	1605856: []string{"America/Chicago"},
	1605859: []string{"America/Denver"},
	160586:  []string{"America/Denver"},
	160587:  []string{"America/Chicago"},
	160588:  []string{"America/Chicago"},
	160589:  []string{"America/Denver"},
	1605923: []string{"America/Denver"},
	1605925: []string{"America/Chicago"},
	1605928: []string{"America/Chicago"},
	160594:  []string{"America/Chicago"},
	160596:  []string{"America/Denver"},
	160597:  []string{"America/Chicago"},
	160598:  []string{"America/Chicago"},
	160599:  []string{"America/Chicago"},
	16062:   []string{"America/New_York"},
	160632:  []string{"America/New_York"},
	160633:  []string{"America/New_York"},
	160634:  []string{"America/New_York"},
	160635:  []string{"America/New_York"},
	160636:  []string{"America/New_York"},
	160637:  []string{"America/New_York"},
	160638:  []string{"America/Chicago"},
	16064:   []string{"America/New_York"},
	16065:   []string{"America/New_York"},
	16066:   []string{"America/New_York"},
	16067:   []string{"America/New_York"},
	16068:   []string{"America/New_York"},
	16069:   []string{"America/New_York"},
	1607:    []string{"America/New_York"},
	1608:    []string{"America/Chicago"},
	1609:    []string{"America/New_York"},
	1610:    []string{"America/New_York"},
	1612:    []string{"America/Chicago"},
	1613:    []string{"America/Toronto"},
	1614:    []string{"America/New_York"},
	1615:    []string{"America/Chicago"},
	1616:    []string{"America/New_York"},
	1617:    []string{"America/New_York"},
	1618:    []string{"America/Chicago"},
	1619:    []string{"America/Los_Angeles"},
	16202:   []string{"America/Chicago"},
	162030:  []string{"America/Chicago"},
	162032:  []string{"America/Chicago"},
	162033:  []string{"America/Chicago"},
	162034:  []string{"America/Chicago"},
	162035:  []string{"America/Chicago"},
	162036:  []string{"America/Chicago"},
	1620375: []string{"America/Chicago"},
	1620376: []string{"America/Denver"},
	1620378: []string{"America/Chicago"},
	1620382: []string{"America/Chicago"},
	1620384: []string{"America/Denver"},
	162039:  []string{"America/Chicago"},
	16204:   []string{"America/Chicago"},
	16205:   []string{"America/Chicago"},
	16206:   []string{"America/Chicago"},
	16207:   []string{"America/Chicago"},
	16208:   []string{"America/Chicago"},
	16209:   []string{"America/Chicago"},
	1623:    []string{"America/Denver"},
	1626:    []string{"America/Los_Angeles"},
	1630:    []string{"America/Chicago"},
	1631:    []string{"America/New_York"},
	1636:    []string{"America/Chicago"},
	1641:    []string{"America/Chicago"},
	1646:    []string{"America/New_York"},
	1647:    []string{"America/Toronto"},
	1649:    []string{"America/Grand_Turk"},
	1650:    []string{"America/Los_Angeles"},
	1651:    []string{"America/Chicago"},
	1660:    []string{"America/Chicago"},
	1661:    []string{"America/Los_Angeles"},
	1662:    []string{"America/Chicago"},
	1664:    []string{"America/Montserrat"},
	1670:    []string{"Pacific/Saipan"},
	1671:    []string{"Pacific/Guam"},
	1678:    []string{"America/New_York"},
	168:     []string{"America/Chicago"},
	1701221: []string{"America/Chicago"},
	1701222: []string{"America/Chicago"},
	1701223: []string{"America/Chicago"},
	1701224: []string{"America/Chicago"},
	1701225: []string{"America/Denver"},
	1701227: []string{"America/Denver"},
	1701228: []string{"America/Chicago"},
	170123:  []string{"America/Chicago"},
	170124:  []string{"America/Chicago"},
	170125:  []string{"America/Chicago"},
	170126:  []string{"America/Chicago"},
	170127:  []string{"America/Chicago"},
	170128:  []string{"America/Chicago"},
	1701290: []string{"America/Denver"},
	1701293: []string{"America/Chicago"},
	1701297: []string{"America/Chicago"},
	1701298: []string{"America/Chicago"},
	17013:   []string{"America/Chicago"},
	170140:  []string{"America/Chicago"},
	170142:  []string{"America/Chicago"},
	170143:  []string{"America/Chicago"},
	170144:  []string{"America/Chicago"},
	1701452: []string{"America/Chicago"},
	1701454: []string{"America/Chicago"},
	1701456: []string{"America/Denver"},
	170146:  []string{"America/Chicago"},
	170147:  []string{"America/Chicago"},
	170148:  []string{"America/Denver"},
	170149:  []string{"America/Chicago"},
	170152:  []string{"America/Denver"},
	170153:  []string{"America/Chicago"},
	170154:  []string{"America/Chicago"},
	170156:  []string{"America/Denver"},
	1701572: []string{"America/Chicago"},
	1701575: []string{"America/Denver"},
	1701577: []string{"America/Chicago"},
	170158:  []string{"America/Denver"},
	17016:   []string{"America/Chicago"},
	170172:  []string{"America/Chicago"},
	170173:  []string{"America/Chicago"},
	170174:  []string{"America/Chicago"},
	170175:  []string{"America/Chicago"},
	1701764: []string{"America/Denver"},
	1701766: []string{"America/Chicago"},
	170177:  []string{"America/Chicago"},
	170178:  []string{"America/Chicago"},
	170179:  []string{"America/Chicago"},
	170182:  []string{"America/Denver"},
	170183:  []string{"America/Chicago"},
	1701842: []string{"America/Denver"},
	1701843: []string{"America/Chicago"},
	1701845: []string{"America/Chicago"},
	1701852: []string{"America/Chicago"},
	1701854: []string{"America/Denver"},
	1701857: []string{"America/Chicago"},
	1701858: []string{"America/Chicago"},
	1701872: []string{"America/Denver"},
	1701873: []string{"America/Chicago"},
	170188:  []string{"America/Chicago"},
	17019:   []string{"America/Chicago"},
	1702:    []string{"America/Los_Angeles"},
	1703:    []string{"America/New_York"},
	1704:    []string{"America/New_York"},
	1705:    []string{"America/Toronto"},
	1706:    []string{"America/New_York"},
	1707:    []string{"America/Los_Angeles"},
	1708:    []string{"America/Chicago"},
	170922:  []string{"America/St_Johns"},
	170923:  []string{"America/St_Johns"},
	170925:  []string{"America/St_Johns"},
	170927:  []string{"America/St_Johns"},
	170928:  []string{"America/Halifax"},
	17093:   []string{"America/St_Johns"},
	17094:   []string{"America/St_Johns"},
	17095:   []string{"America/St_Johns"},
	17096:   []string{"America/St_Johns"},
	17097:   []string{"America/St_Johns"},
	170983:  []string{"America/St_Johns"},
	170988:  []string{"America/St_Johns"},
	1709891: []string{"America/St_Johns"},
	1709895: []string{"America/St_Johns"},
	1709896: []string{"America/Halifax"},
	17099:   []string{"America/Halifax"},
	1712:    []string{"America/Chicago"},
	1713:    []string{"America/Chicago"},
	1714:    []string{"America/Los_Angeles"},
	1715:    []string{"America/Chicago"},
	1716:    []string{"America/New_York"},
	1717:    []string{"America/New_York"},
	1718:    []string{"America/New_York"},
	1719:    []string{"America/Denver"},
	1720:    []string{"America/Denver"},
	1721:    []string{"America/Lower_Princes"},
	1724:    []string{"America/New_York"},
	1727:    []string{"America/New_York"},
	1731:    []string{"America/Chicago"},
	1732:    []string{"America/New_York"},
	1734:    []string{"America/New_York"},
	174:     []string{"America/New_York"},
	1754:    []string{"America/New_York"},
	1757:    []string{"America/New_York"},
	1758:    []string{"America/St_Lucia"},
	1760:    []string{"America/Los_Angeles"},
	1763:    []string{"America/Chicago"},
	1765:    []string{"America/New_York"},
	1767:    []string{"America/Dominica"},
	1769:    []string{"America/Chicago"},
	1770:    []string{"America/New_York"},
	1772:    []string{"America/New_York"},
	1773:    []string{"America/Chicago"},
	1774:    []string{"America/New_York"},
	1775:    []string{"America/Los_Angeles"},
	1778:    []string{"America/Vancouver"},
	1779:    []string{"America/Chicago"},
	1780:    []string{"America/Edmonton"},
	1781:    []string{"America/New_York"},
	1784:    []string{"America/St_Vincent"},
	17852:   []string{"America/Chicago"},
	17853:   []string{"America/Chicago"},
	17854:   []string{"America/Chicago"},
	17855:   []string{"America/Chicago"},
	17856:   []string{"America/Chicago"},
	17857:   []string{"America/Chicago"},
	178582:  []string{"America/Chicago"},
	178583:  []string{"America/Chicago"},
	178584:  []string{"America/Chicago"},
	1785852: []string{"America/Denver"},
	1785856: []string{"America/Chicago"},
	178586:  []string{"America/Chicago"},
	178587:  []string{"America/Chicago"},
	178588:  []string{"America/Chicago"},
	178589:  []string{"America/Denver"},
	17859:   []string{"America/Chicago"},
	1786:    []string{"America/New_York"},
	1787:    []string{"America/Puerto_Rico"},
	1801:    []string{"America/Denver"},
	1802:    []string{"America/New_York"},
	1803:    []string{"America/New_York"},
	1804:    []string{"America/New_York"},
	1805:    []string{"America/Los_Angeles"},
	1806:    []string{"America/Chicago"},
	1807222: []string{"America/Winnipeg"},
	1807223: []string{"America/Winnipeg"},
	1807226: []string{"America/Winnipeg"},
	1807229: []string{"America/Toronto"},
	180727:  []string{"America/Winnipeg"},
	180728:  []string{"America/Toronto"},
	18073:   []string{"America/Toronto"},
	180746:  []string{"America/Winnipeg"},
	180747:  []string{"America/Toronto"},
	180748:  []string{"America/Winnipeg"},
	180754:  []string{"America/Winnipeg"},
	180757:  []string{"America/Toronto"},
	180759:  []string{"America/Toronto"},
	18076:   []string{"America/Toronto"},
	180772:  []string{"America/Winnipeg"},
	180773:  []string{"America/Winnipeg"},
	180776:  []string{"America/Toronto"},
	18078:   []string{"America/Toronto"},
	18079:   []string{"America/Winnipeg"},
	1808:    []string{"Pacific/Honolulu"},
	1809:    []string{"America/Halifax"},
	1810:    []string{"America/New_York"},
	18122:   []string{"America/New_York"},
	181231:  []string{"America/New_York"},
	181232:  []string{"America/New_York"},
	181233:  []string{"America/New_York"},
	181234:  []string{"America/New_York"},
	181235:  []string{"America/New_York"},
	181236:  []string{"America/New_York"},
	181237:  []string{"America/New_York"},
	1812384: []string{"America/New_York"},
	1812385: []string{"America/Chicago"},
	1812386: []string{"America/Chicago"},
	181240:  []string{"America/Chicago"},
	1812421: []string{"America/Chicago"},
	1812422: []string{"America/Chicago"},
	1812423: []string{"America/Chicago"},
	1812424: []string{"America/Chicago"},
	1812425: []string{"America/Chicago"},
	1812426: []string{"America/Chicago"},
	1812427: []string{"America/New_York"},
	1812428: []string{"America/Chicago"},
	1812432: []string{"America/New_York"},
	1812435: []string{"America/Chicago"},
	1812437: []string{"America/Chicago"},
	1812438: []string{"America/New_York"},
	181244:  []string{"America/New_York"},
	181245:  []string{"America/Chicago"},
	1812462: []string{"America/New_York"},
	1812464: []string{"America/Chicago"},
	1812466: []string{"America/New_York"},
	1812471: []string{"America/Chicago"},
	1812473: []string{"America/Chicago"},
	1812474: []string{"America/Chicago"},
	1812475: []string{"America/Chicago"},
	1812476: []string{"America/Chicago"},
	1812477: []string{"America/Chicago"},
	1812478: []string{"America/New_York"},
	1812479: []string{"America/Chicago"},
	1812481: []string{"America/New_York"},
	1812482: []string{"America/New_York"},
	1812485: []string{"America/Chicago"},
	1812486: []string{"America/New_York"},
	181249:  []string{"America/Chicago"},
	181252:  []string{"America/New_York"},
	181253:  []string{"America/New_York"},
	1812542: []string{"America/New_York"},
	1812546: []string{"America/New_York"},
	1812547: []string{"America/Chicago"},
	181259:  []string{"America/New_York"},
	181261:  []string{"America/Chicago"},
	181262:  []string{"America/New_York"},
	181263:  []string{"America/New_York"},
	181264:  []string{"America/Chicago"},
	181265:  []string{"America/New_York"},
	181266:  []string{"America/New_York"},
	181268:  []string{"America/New_York"},
	181272:  []string{"America/New_York"},
	181273:  []string{"America/New_York"},
	181274:  []string{"America/Chicago"},
	1812752: []string{"America/New_York"},
	1812753: []string{"America/Chicago"},
	181276:  []string{"America/Chicago"},
	181279:  []string{"America/New_York"},
	181282:  []string{"America/New_York"},
	181283:  []string{"America/Chicago"},
	1812842: []string{"America/Chicago"},
	1812847: []string{"America/New_York"},
	1812849: []string{"America/New_York"},
	1812853: []string{"America/Chicago"},
	1812855: []string{"America/New_York"},
	1812858: []string{"America/Chicago"},
	1812865: []string{"America/New_York"},
	1812866: []string{"America/New_York"},
	1812867: []string{"America/Chicago"},
	1812874: []string{"America/Chicago"},
	1812875: []string{"America/New_York"},
	1812876: []string{"America/New_York"},
	1812877: []string{"America/New_York"},
	181288:  []string{"America/New_York"},
	181289:  []string{"America/Chicago"},
	181291:  []string{"America/New_York"},
	1812923: []string{"America/New_York"},
	1812925: []string{"America/Chicago"},
	1812926: []string{"America/New_York"},
	1812932: []string{"America/New_York"},
	1812933: []string{"America/New_York"},
	1812934: []string{"America/New_York"},
	1812936: []string{"America/New_York"},
	1812937: []string{"America/Chicago"},
	1812939: []string{"America/New_York"},
	181294:  []string{"America/New_York"},
	181295:  []string{"America/New_York"},
	1812963: []string{"America/Chicago"},
	1812967: []string{"America/New_York"},
	1812985: []string{"America/Chicago"},
	1812988: []string{"America/New_York"},
	1813:    []string{"America/New_York"},
	1814:    []string{"America/New_York"},
	1815:    []string{"America/Chicago"},
	1816:    []string{"America/Chicago"},
	1817:    []string{"America/Chicago"},
	1818:    []string{"America/Los_Angeles"},
	1819:    []string{"America/Toronto"},
	1828:    []string{"America/New_York"},
	1829:    []string{"America/Halifax"},
	1830:    []string{"America/Chicago"},
	1831:    []string{"America/Los_Angeles"},
	1832:    []string{"America/Chicago"},
	1843:    []string{"America/New_York"},
	1845:    []string{"America/New_York"},
	1847:    []string{"America/Chicago"},
	1849:    []string{"America/Halifax"},
	185020:  []string{"America/Chicago"},
	1850210: []string{"America/New_York"},
	1850215: []string{"America/Chicago"},
	1850216: []string{"America/New_York"},
	1850217: []string{"America/Chicago"},
	1850219: []string{"America/New_York"},
	1850222: []string{"America/New_York"},
	1850223: []string{"America/New_York"},
	1850224: []string{"America/New_York"},
	1850225: []string{"America/Chicago"},
	1850226: []string{"America/Chicago"},
	1850227: []string{"America/Chicago"},
	1850229: []string{"America/Chicago"},
	185023:  []string{"America/Chicago"},
	185024:  []string{"America/Chicago"},
	1850250: []string{"America/Chicago"},
	1850251: []string{"America/New_York"},
	1850256: []string{"America/Chicago"},
	1850258: []string{"America/Chicago"},
	1850259: []string{"America/Chicago"},
	185026:  []string{"America/Chicago"},
	185027:  []string{"America/Chicago"},
	185028:  []string{"America/Chicago"},
	185029:  []string{"America/New_York"},
	1850301: []string{"America/Chicago"},
	1850309: []string{"America/New_York"},
	185031:  []string{"America/Chicago"},
	1850325: []string{"America/New_York"},
	1850327: []string{"America/Chicago"},
	1850329: []string{"America/New_York"},
	185033:  []string{"America/Chicago"},
	185036:  []string{"America/Chicago"},
	185037:  []string{"America/Chicago"},
	185038:  []string{"America/New_York"},
	1850391: []string{"America/New_York"},
	1850393: []string{"America/Chicago"},
	1850398: []string{"America/Chicago"},
	18504:   []string{"America/Chicago"},
	185040:  []string{"America/New_York"},
	185041:  []string{"America/Chicago"},
	1850421: []string{"America/New_York"},
	1850422: []string{"America/New_York"},
	1850423: []string{"America/Chicago"},
	1850424: []string{"America/Chicago"},
	1850425: []string{"America/New_York"},
	1850429: []string{"America/Chicago"},
	1850431: []string{"America/New_York"},
	1850432: []string{"America/Chicago"},
	1850433: []string{"America/Chicago"},
	1850434: []string{"America/Chicago"},
	1850435: []string{"America/Chicago"},
	1850436: []string{"America/Chicago"},
	1850437: []string{"America/Chicago"},
	1850438: []string{"America/Chicago"},
	1850439: []string{"America/Chicago"},
	185044:  []string{"America/Chicago"},
	185045:  []string{"America/Chicago"},
	185046:  []string{"America/Chicago"},
	185047:  []string{"America/Chicago"},
	1850481: []string{"America/Chicago"},
	1850482: []string{"America/Chicago"},
	1850484: []string{"America/Chicago"},
	1850488: []string{"America/New_York"},
	185049:  []string{"America/Chicago"},
	1850502: []string{"America/Chicago"},
	1850505: []string{"America/Chicago"},
	1850508: []string{"America/New_York"},
	1850509: []string{"America/New_York"},
	185051:  []string{"America/New_York"},
	1850522: []string{"America/Chicago"},
	1850523: []string{"America/New_York"},
	1850526: []string{"America/Chicago"},
	1850527: []string{"America/Chicago"},
	1850535: []string{"America/Chicago"},
	1850537: []string{"America/Chicago"},
	1850539: []string{"America/New_York"},
	1850543: []string{"America/Chicago"},
	1850545: []string{"America/New_York"},
	1850547: []string{"America/Chicago"},
	185055:  []string{"America/New_York"},
	185056:  []string{"America/New_York"},
	185057:  []string{"America/New_York"},
	1850580: []string{"America/New_York"},
	1850581: []string{"America/Chicago"},
	1850584: []string{"America/New_York"},
	1850585: []string{"America/Chicago"},
	1850587: []string{"America/Chicago"},
	1850588: []string{"America/Chicago"},
	1850592: []string{"America/Chicago"},
	1850593: []string{"America/Chicago"},
	1850595: []string{"America/Chicago"},
	1850597: []string{"America/New_York"},
	185060:  []string{"America/Chicago"},
	1850622: []string{"America/Chicago"},
	1850623: []string{"America/Chicago"},
	1850626: []string{"America/Chicago"},
	1850627: []string{"America/New_York"},
	185063:  []string{"America/Chicago"},
	1850640: []string{"America/Chicago"},
	1850643: []string{"America/New_York"},
	1850644: []string{"America/New_York"},
	1850650: []string{"America/Chicago"},
	1850651: []string{"America/Chicago"},
	1850653: []string{"America/New_York"},
	1850654: []string{"America/Chicago"},
	1850656: []string{"America/New_York"},
	1850663: []string{"America/New_York"},
	1850664: []string{"America/Chicago"},
	1850668: []string{"America/New_York"},
	1850670: []string{"America/New_York"},
	1850671: []string{"America/New_York"},
	1850674: []string{"America/Chicago"},
	1850675: []string{"America/Chicago"},
	1850678: []string{"America/Chicago"},
	1850681: []string{"America/New_York"},
	1850682: []string{"America/Chicago"},
	1850683: []string{"America/Chicago"},
	1850685: []string{"America/Chicago"},
	1850687: []string{"America/Chicago"},
	1850689: []string{"America/Chicago"},
	1850696: []string{"America/Chicago"},
	1850697: []string{"America/New_York"},
	185071:  []string{"America/Chicago"},
	1850722: []string{"America/Chicago"},
	1850727: []string{"America/New_York"},
	1850729: []string{"America/Chicago"},
	185074:  []string{"America/Chicago"},
	1850763: []string{"America/Chicago"},
	1850765: []string{"America/New_York"},
	1850769: []string{"America/Chicago"},
	185078:  []string{"America/Chicago"},
	185079:  []string{"America/Chicago"},
	185081:  []string{"America/Chicago"},
	1850830: []string{"America/Chicago"},
	1850833: []string{"America/Chicago"},
	1850835: []string{"America/Chicago"},
	1850837: []string{"America/Chicago"},
	1850838: []string{"America/New_York"},
	185085:  []string{"America/Chicago"},
	185086:  []string{"America/Chicago"},
	1850871: []string{"America/Chicago"},
	1850872: []string{"America/Chicago"},
	1850874: []string{"America/Chicago"},
	1850875: []string{"America/New_York"},
	1850877: []string{"America/New_York"},
	1850878: []string{"America/New_York"},
	185088:  []string{"America/Chicago"},
	1850891: []string{"America/New_York"},
	1850892: []string{"America/Chicago"},
	1850893: []string{"America/New_York"},
	1850894: []string{"America/New_York"},
	1850897: []string{"America/Chicago"},
	185091:  []string{"America/Chicago"},
	185092:  []string{"America/New_York"},
	1850932: []string{"America/Chicago"},
	1850933: []string{"America/New_York"},
	1850934: []string{"America/Chicago"},
	1850936: []string{"America/Chicago"},
	1850937: []string{"America/Chicago"},
	1850939: []string{"America/Chicago"},
	1850941: []string{"America/Chicago"},
	1850942: []string{"America/New_York"},
	1850944: []string{"America/Chicago"},
	185095:  []string{"America/Chicago"},
	185096:  []string{"America/Chicago"},
	185097:  []string{"America/New_York"},
	185098:  []string{"America/Chicago"},
	1850994: []string{"America/Chicago"},
	1850995: []string{"America/Chicago"},
	1850997: []string{"America/New_York"},
	1856:    []string{"America/New_York"},
	1857:    []string{"America/New_York"},
	1858:    []string{"America/Los_Angeles"},
	1859:    []string{"America/New_York"},
	1860:    []string{"America/New_York"},
	1862:    []string{"America/New_York"},
	1863:    []string{"America/New_York"},
	1864:    []string{"America/New_York"},
	1865:    []string{"America/New_York"},
	18673:   []string{"America/Vancouver"},
	18674:   []string{"America/Vancouver"},
	186753:  []string{"America/Vancouver"},
	186758:  []string{"America/Edmonton"},
	186763:  []string{"America/Vancouver"},
	186764:  []string{"America/Winnipeg"},
	1867667: []string{"America/Vancouver"},
	1867668: []string{"America/Vancouver"},
	1867669: []string{"America/Edmonton"},
	186769:  []string{"America/Edmonton"},
	18677:   []string{"America/Edmonton"},
	18678:   []string{"America/Edmonton"},
	186792:  []string{"America/Edmonton"},
	186797:  []string{"America/Toronto"},
	186798:  []string{"America/Edmonton"},
	186799:  []string{"America/Vancouver"},
	1868:    []string{"America/Port_of_Spain"},
	1869:    []string{"America/St_Kitts"},
	1870:    []string{"America/Chicago"},
	1876:    []string{"America/Jamaica"},
	1901:    []string{"America/Chicago"},
	1902:    []string{"America/Halifax"},
	1903:    []string{"America/Chicago"},
	1904:    []string{"America/New_York"},
	1905:    []string{"America/Toronto"},
	190622:  []string{"America/New_York"},
	190623:  []string{"America/New_York"},
	190624:  []string{"America/New_York"},
	190625:  []string{"America/New_York"},
	190626:  []string{"America/Chicago"},
	190627:  []string{"America/New_York"},
	190629:  []string{"America/New_York"},
	19063:   []string{"America/New_York"},
	19064:   []string{"America/New_York"},
	190652:  []string{"America/New_York"},
	190656:  []string{"America/Chicago"},
	190658:  []string{"America/New_York"},
	190663:  []string{"America/New_York"},
	190664:  []string{"America/New_York"},
	190666:  []string{"America/Chicago"},
	190675:  []string{"America/Chicago"},
	190677:  []string{"America/Chicago"},
	190678:  []string{"America/New_York"},
	190684:  []string{"America/New_York"},
	190686:  []string{"America/Chicago"},
	190687:  []string{"America/Chicago"},
	190688:  []string{"America/New_York"},
	19069:   []string{"America/Chicago"},
	1907:    []string{"America/Juneau"},
	1908:    []string{"America/New_York"},
	1909:    []string{"America/Los_Angeles"},
	1910:    []string{"America/New_York"},
	1912:    []string{"America/New_York"},
	1913:    []string{"America/Chicago"},
	1914:    []string{"America/New_York"},
	1915:    []string{"America/Denver"},
	1916:    []string{"America/Los_Angeles"},
	1917:    []string{"America/New_York"},
	1918:    []string{"America/Chicago"},
	1919:    []string{"America/New_York"},
	1920:    []string{"America/Chicago"},
	1925:    []string{"America/Los_Angeles"},
	1928:    []string{"America/Denver"},
	1931:    []string{"America/Chicago"},
	1936:    []string{"America/Chicago"},
	1937:    []string{"America/New_York"},
	1939:    []string{"America/Puerto_Rico"},
	1940:    []string{"America/Chicago"},
	1941:    []string{"America/New_York"},
	1949:    []string{"America/Los_Angeles"},
	1951:    []string{"America/Los_Angeles"},
	1952:    []string{"America/Chicago"},
	1954:    []string{"America/New_York"},
	1956:    []string{"America/Chicago"},
	1970:    []string{"America/Denver"},
	1971:    []string{"America/Los_Angeles"},
	1972:    []string{"America/Chicago"},
	1973:    []string{"America/New_York"},
	1978:    []string{"America/New_York"},
	1979:    []string{"America/Chicago"},
	1980:    []string{"America/New_York"},
	1985:    []string{"America/Chicago"},
	1989:    []string{"America/New_York"},
	20:      []string{"Africa/Cairo"},
	211:     []string{"Africa/Nairobi"},
	212:     []string{"Atlantic/Canary"},
	213:     []string{"Europe/Paris"},
	216:     []string{"Africa/Tunis"},
	218:     []string{"Europe/Bucharest"},
	220:     []string{"Africa/Banjul"},
	221:     []string{"Africa/Dakar"},
	222:     []string{"Africa/Nouakchott"},
	223:     []string{"Africa/Bamako"},
	224:     []string{"Africa/Conakry"},
	225:     []string{"Africa/Abidjan"},
	226:     []string{"Africa/Ouagadougou"},
	227:     []string{"Africa/Niamey"},
	228:     []string{"Africa/Lome"},
	229:     []string{"Africa/Porto-Novo"},
	230:     []string{"Indian/Mauritius"},
	231:     []string{"Atlantic/Reykjavik"},
	232:     []string{"Africa/Freetown"},
	233:     []string{"Africa/Accra"},
	234:     []string{"Africa/Lagos"},
	235:     []string{"Africa/Ndjamena"},
	236:     []string{"Africa/Bangui"},
	237:     []string{"Africa/Douala"},
	238:     []string{"Atlantic/Cape_Verde"},
	239:     []string{"Africa/Sao_Tome"},
	240:     []string{"Africa/Malabo"},
	241:     []string{"Africa/Libreville"},
	242:     []string{"Africa/Brazzaville"},
	243: []string{"Africa/Kinshasa",
		"Africa/Lubumbashi"},
	2431: []string{"Africa/Kinshasa"},
	2432: []string{"Africa/Lubumbashi"},
	2436: []string{"Africa/Kinshasa"},
	244:  []string{"Africa/Luanda"},
	245:  []string{"Atlantic/Reykjavik"},
	246:  []string{"Indian/Chagos"},
	247:  []string{"Atlantic/St_Helena"},
	248:  []string{"Indian/Mahe"},
	249:  []string{"Africa/Nairobi"},
	250:  []string{"Africa/Kigali"},
	251:  []string{"Africa/Addis_Ababa"},
	252:  []string{"Africa/Mogadishu"},
	253:  []string{"Africa/Djibouti"},
	254:  []string{"Africa/Nairobi"},
	255:  []string{"Africa/Dar_es_Salaam"},
	256:  []string{"Africa/Kampala"},
	257:  []string{"Africa/Bujumbura"},
	258:  []string{"Africa/Maputo"},
	260:  []string{"Africa/Lusaka"},
	261:  []string{"Indian/Antananarivo"},
	262: []string{
		"Indian/Mayotte",
		"Indian/Reunion",
	},
	262262: []string{"Indian/Reunion"},
	262269: []string{"Indian/Mayotte"},
	263:    []string{"Africa/Harare"},
	264:    []string{"Africa/Lagos"},
	265:    []string{"Africa/Blantyre"},
	266:    []string{"Africa/Maseru"},
	267:    []string{"Africa/Gaborone"},
	268:    []string{"Africa/Mbabane"},
	269:    []string{"Indian/Comoro"},
	27:     []string{"Africa/Johannesburg"},
	290:    []string{"Atlantic/St_Helena"},
	291:    []string{"Africa/Asmera"},
	297:    []string{"America/Aruba"},
	298:    []string{"Atlantic/Faeroe"},
	299: []string{
		"America/Godthab",
		"America/Scoresbysund",
		"America/Thule",
		"Atlantic/Reykjavik"},
	2993:  []string{"America/Godthab"},
	2996:  []string{"America/Godthab"},
	2998:  []string{"America/Godthab"},
	29991: []string{"America/Godthab"},
	29994: []string{"America/Godthab"},
	29995: []string{"America/Godthab"},
	29996: []string{"America/Godthab"},
	29997: []string{"America/Thule"},
	29998: []string{"America/Godthab"},
	29999: []string{"America/Scoresbysund"},
	30:    []string{"Europe/Athens"},
	31:    []string{"Europe/Amsterdam"},
	32:    []string{"Europe/Brussels"},
	33:    []string{"Europe/Paris"},
	34: []string{
		"Europe/Madrid",
		"Atlantic/Canary",
	},
	3481:  []string{"Europe/Madrid"},
	34821: []string{"Europe/Madrid"},
	34822: []string{"Atlantic/Canary"},
	34823: []string{"Europe/Madrid"},
	34824: []string{"Europe/Madrid"},
	34825: []string{"Europe/Madrid"},
	34826: []string{"Europe/Madrid"},
	34827: []string{"Europe/Madrid"},
	34828: []string{"Atlantic/Canary"},
	3483:  []string{"Europe/Madrid"},
	3484:  []string{"Europe/Madrid"},
	3485:  []string{"Europe/Madrid"},
	34860: []string{"Europe/Madrid"},
	34864: []string{"Europe/Madrid"},
	34865: []string{"Europe/Madrid"},
	34868: []string{"Europe/Madrid"},
	34869: []string{
		"Atlantic/Canary",
		"Europe/Madrid",
	},
	3487:  []string{"Europe/Madrid"},
	3488:  []string{"Europe/Madrid"},
	3491:  []string{"Europe/Madrid"},
	34920: []string{"Europe/Madrid"},
	34921: []string{"Europe/Madrid"},
	34922: []string{"Atlantic/Canary"},
	34923: []string{"Europe/Madrid"},
	34924: []string{"Europe/Madrid"},
	34925: []string{"Europe/Madrid"},
	34926: []string{"Europe/Madrid"},
	34927: []string{"Europe/Madrid"},
	34928: []string{"Atlantic/Canary"},
	3493:  []string{"Europe/Madrid"},
	3494:  []string{"Europe/Madrid"},
	3495:  []string{"Europe/Madrid"},
	3496:  []string{"Europe/Madrid"},
	3497:  []string{"Europe/Madrid"},
	3498:  []string{"Europe/Madrid"},
	350:   []string{"Europe/Gibraltar"},
	351: []string{
		"Europe/Lisbon",
		"Atlantic/Azores",
		"Atlantic/Madeira",
	},
	35121:  []string{"Europe/Lisbon"},
	35122:  []string{"Europe/Lisbon"},
	35123:  []string{"Europe/Lisbon"},
	35124:  []string{"Europe/Lisbon"},
	35125:  []string{"Europe/Lisbon"},
	35126:  []string{"Europe/Lisbon"},
	35127:  []string{"Europe/Lisbon"},
	35128:  []string{"Europe/Lisbon"},
	351291: []string{"Atlantic/Madeira"},
	351292: []string{"Atlantic/Azores"},
	351295: []string{"Atlantic/Azores"},
	351296: []string{"Atlantic/Azores"},
	352:    []string{"Europe/Luxembourg"},
	353:    []string{"Europe/Dublin"},
	354:    []string{"Atlantic/Reykjavik"},
	355:    []string{"Europe/Tirane"},
	356:    []string{"Europe/Malta"},
	357:    []string{"Asia/Nicosia"},
	358: []string{
		"Europe/Helsinki",
		"Europe/Mariehamn",
	},
	35813: []string{"Europe/Helsinki"},
	35814: []string{"Europe/Helsinki"},
	35815: []string{"Europe/Helsinki"},
	35816: []string{"Europe/Helsinki"},
	35817: []string{"Europe/Helsinki"},
	35818: []string{"Europe/Mariehamn"},
	35819: []string{"Europe/Helsinki"},
	3582:  []string{"Europe/Helsinki"},
	3583:  []string{"Europe/Helsinki"},
	3585:  []string{"Europe/Helsinki"},
	3586:  []string{"Europe/Helsinki"},
	3588:  []string{"Europe/Helsinki"},
	3589:  []string{"Europe/Helsinki"},
	359:   []string{"Europe/Sofia"},
	36:    []string{"Europe/Budapest"},
	370:   []string{"Europe/Bucharest"},
	371:   []string{"Europe/Bucharest"},
	372:   []string{"Europe/Bucharest"},
	373:   []string{"Europe/Bucharest"},
	374:   []string{"Asia/Yerevan"},
	375:   []string{"Europe/Minsk"},
	376:   []string{"Europe/Andorra"},
	377:   []string{"Europe/Monaco"},
	378:   []string{"Europe/San_Marino"},
	380:   []string{"Europe/Bucharest"},
	381:   []string{"Europe/Belgrade"},
	382:   []string{"Europe/Podgorica"},
	385:   []string{"Europe/Zagreb"},
	386:   []string{"Europe/Ljubljana"},
	387:   []string{"Europe/Sarajevo"},
	389:   []string{"Europe/Skopje"},
	39: []string{
		"Europe/Rome",
		"Europe/Vatican",
	},
	390:     []string{"Europe/Rome"},
	40:      []string{"Europe/Bucharest"},
	41:      []string{"Europe/Zurich"},
	420:     []string{"Europe/Prague"},
	421:     []string{"Europe/Bratislava"},
	423:     []string{"Europe/Vaduz"},
	43:      []string{"Europe/Vienna"},
	44:      []string{"Europe/London"},
	4411:    []string{"Europe/London"},
	4412:    []string{"Europe/London"},
	44130:   []string{"Europe/London"},
	44131:   []string{"Europe/London"},
	44132:   []string{"Europe/London"},
	44133:   []string{"Europe/London"},
	44134:   []string{"Europe/London"},
	44135:   []string{"Europe/London"},
	44136:   []string{"Europe/London"},
	44137:   []string{"Europe/London"},
	441380:  []string{"Europe/London"},
	441381:  []string{"Europe/London"},
	441382:  []string{"Europe/London"},
	441383:  []string{"Europe/London"},
	441384:  []string{"Europe/London"},
	441386:  []string{"Europe/London"},
	441387:  []string{"Europe/London"},
	4413873: []string{"Europe/London"},
	441388:  []string{"Europe/London"},
	441389:  []string{"Europe/London"},
	44139:   []string{"Europe/London"},
	44140:   []string{"Europe/London"},
	44141:   []string{"Europe/London"},
	44142:   []string{"Europe/London"},
	44143:   []string{"Europe/London"},
	44144:   []string{"Europe/London"},
	44145:   []string{"Europe/London"},
	44146:   []string{"Europe/London"},
	44147:   []string{"Europe/London"},
	441480:  []string{"Europe/London"},
	441481:  []string{"Atlantic/Reykjavik"},
	441482:  []string{"Europe/London"},
	441483:  []string{"Europe/London"},
	441484:  []string{"Europe/London"},
	441485:  []string{"Europe/London"},
	441487:  []string{"Europe/London"},
	441488:  []string{"Europe/London"},
	441489:  []string{"Europe/London"},
	44149:   []string{"Europe/London"},
	44150:   []string{"Europe/London"},
	44151:   []string{"Europe/London"},
	441520:  []string{"Europe/London"},
	441522:  []string{"Europe/London"},
	441524:  []string{"Europe/London"},
	4415242: []string{"Europe/London"},
	441525:  []string{"Europe/London"},
	441526:  []string{"Europe/London"},
	441527:  []string{"Europe/London"},
	441528:  []string{"Europe/London"},
	441529:  []string{"Europe/London"},
	441530:  []string{"Europe/London"},
	441531:  []string{"Europe/London"},
	441534:  []string{"Atlantic/Reykjavik"},
	441535:  []string{"Europe/London"},
	441536:  []string{"Europe/London"},
	441538:  []string{"Europe/London"},
	441539:  []string{"Europe/London"},
	4415394: []string{"Europe/London"},
	4415395: []string{"Europe/London"},
	4415396: []string{"Europe/London"},
	44154:   []string{"Europe/London"},
	44155:   []string{"Europe/London"},
	44156:   []string{"Europe/London"},
	44157:   []string{"Europe/London"},
	44158:   []string{"Europe/London"},
	44159:   []string{"Europe/London"},
	44160:   []string{"Europe/London"},
	44161:   []string{"Europe/London"},
	441620:  []string{"Europe/London"},
	441621:  []string{"Europe/London"},
	441622:  []string{"Europe/London"},
	441623:  []string{"Europe/London"},
	441624:  []string{"Atlantic/Reykjavik"},
	441625:  []string{"Europe/London"},
	441626:  []string{"Europe/London"},
	441628:  []string{"Europe/London"},
	441629:  []string{"Europe/London"},
	44163:   []string{"Europe/London"},
	44164:   []string{"Europe/London"},
	44165:   []string{"Europe/London"},
	44166:   []string{"Europe/London"},
	44167:   []string{"Europe/London"},
	44168:   []string{"Europe/London"},
	441690:  []string{"Europe/London"},
	441691:  []string{"Europe/London"},
	441692:  []string{"Europe/London"},
	441694:  []string{"Europe/London"},
	441695:  []string{"Europe/London"},
	441697:  []string{"Europe/London"},
	4416973: []string{"Europe/London"},
	4416974: []string{"Europe/London"},
	4416977: []string{"Europe/London"},
	441698:  []string{"Europe/London"},
	44170:   []string{"Europe/London"},
	44172:   []string{"Europe/London"},
	44173:   []string{"Europe/London"},
	44174:   []string{"Europe/London"},
	44175:   []string{"Europe/London"},
	441760:  []string{"Europe/London"},
	441761:  []string{"Europe/London"},
	441763:  []string{"Europe/London"},
	441764:  []string{"Europe/London"},
	441765:  []string{"Europe/London"},
	441766:  []string{"Europe/London"},
	441767:  []string{"Europe/London"},
	441768:  []string{"Europe/London"},
	4417683: []string{"Europe/London"},
	4417684: []string{"Europe/London"},
	4417687: []string{"Europe/London"},
	441769:  []string{"Europe/London"},
	44177:   []string{"Europe/London"},
	44178:   []string{"Europe/London"},
	44179:   []string{"Europe/London"},
	4418:    []string{"Europe/London"},
	44190:   []string{"Europe/London"},
	44191:   []string{"Europe/London"},
	44192:   []string{"Europe/London"},
	44193:   []string{"Europe/London"},
	441942:  []string{"Europe/London"},
	441943:  []string{"Europe/London"},
	441944:  []string{"Europe/London"},
	441945:  []string{"Europe/London"},
	441946:  []string{"Europe/London"},
	4419467: []string{"Europe/London"},
	441947:  []string{"Europe/London"},
	441948:  []string{"Europe/London"},
	441949:  []string{"Europe/London"},
	44195:   []string{"Europe/London"},
	44196:   []string{"Europe/London"},
	44197:   []string{"Europe/London"},
	44198:   []string{"Europe/London"},
	44199:   []string{"Europe/London"},
	442:     []string{"Europe/London"},
	45:      []string{"Europe/Copenhagen"},
	46:      []string{"Europe/Stockholm"},
	47: []string{
		"Europe/Oslo",
		"Europe/Paris",
	},
	472:  []string{"Europe/Oslo"},
	473:  []string{"Europe/Oslo"},
	475:  []string{"Europe/Oslo"},
	476:  []string{"Europe/Oslo"},
	4770: []string{"Europe/Oslo"},
	4771: []string{"Europe/Oslo"},
	4772: []string{"Europe/Oslo"},
	4773: []string{"Europe/Oslo"},
	4774: []string{"Europe/Oslo"},
	4775: []string{"Europe/Oslo"},
	4776: []string{"Europe/Oslo"},
	4777: []string{"Europe/Oslo"},
	4778: []string{"Europe/Oslo"},
	4779: []string{"Europe/Paris"},
	48:   []string{"Europe/Warsaw"},
	49:   []string{"Europe/Berlin"},
	500:  []string{"Atlantic/Stanley"},
	501:  []string{"America/Belize"},
	502:  []string{"America/Guatemala"},
	503:  []string{"America/El_Salvador"},
	504:  []string{"America/Tegucigalpa"},
	505:  []string{"America/Chicago"},
	506:  []string{"America/Costa_Rica"},
	507:  []string{"America/Panama"},
	508:  []string{"America/Miquelon"},
	509:  []string{"America/Port-au-Prince"},
	51:   []string{"America/Lima"},
	52: []string{
		"America/Hermosillo",
		"America/Mazatlan",
		"America/Mexico_City",
		"America/New_York",
		"America/Santa_Isabel",
		"America/Tijuana",
	},
	522:   []string{"America/Mexico_City"},
	52311: []string{"America/Mazatlan"},
	52312: []string{"America/Mexico_City"},
	52313: []string{"America/Mexico_City"},
	52314: []string{"America/Mexico_City"},
	52315: []string{"America/Mexico_City"},
	52316: []string{"America/Mexico_City"},
	52317: []string{"America/Mexico_City"},
	52319: []string{"America/Mazatlan"},
	52321: []string{"America/Mexico_City"},
	52322: []string{"America/Mexico_City"},
	52323: []string{"America/Mazatlan"},
	52324: []string{"America/Mazatlan"},
	52325: []string{"America/Mazatlan"},
	52326: []string{"America/Mexico_City"},
	52327: []string{"America/Mazatlan"},
	52328: []string{"America/Mexico_City"},
	52329: []string{
		"America/Mazatlan",
		"America/Mexico_City",
	},
	5233:  []string{"America/Mexico_City"},
	5234:  []string{"America/Mexico_City"},
	5235:  []string{"America/Mexico_City"},
	5237:  []string{"America/Mexico_City"},
	52381: []string{"America/Mexico_City"},
	52382: []string{"America/Mexico_City"},
	52383: []string{"America/Mexico_City"},
	52384: []string{"America/Mexico_City"},
	52385: []string{"America/Mexico_City"},
	52386: []string{"America/Mexico_City"},
	52387: []string{"America/Mexico_City"},
	52388: []string{"America/Mexico_City"},
	52389: []string{"America/Mazatlan"},
	5239:  []string{"America/Mexico_City"},
	524:   []string{"America/Mexico_City"},
	525:   []string{"America/Mexico_City"},
	52612: []string{"America/Mazatlan"},
	52613: []string{"America/Mazatlan"},
	52614: []string{"America/Mazatlan"},
	52615: []string{"America/Mazatlan"},
	52616: []string{
		"America/Mazatlan",
		"America/Tijuana",
	},
	52618: []string{"America/Mexico_City"},
	5262:  []string{"America/Mazatlan"},
	5263:  []string{"America/Mazatlan"},
	52641: []string{"America/Mazatlan"},
	52642: []string{"America/Mazatlan"},
	52643: []string{"America/Mazatlan"},
	52644: []string{"America/Mazatlan"},
	52645: []string{"America/Mazatlan"},
	52646: []string{"America/Tijuana"},
	52647: []string{"America/Mazatlan"},
	52648: []string{"America/Mazatlan"},
	52649: []string{
		"America/Mazatlan",
		"America/Mexico_City",
	},
	52651: []string{"America/Mazatlan"},
	52652: []string{"America/Mazatlan"},
	52653: []string{"America/Mazatlan"},
	52656: []string{"America/Mazatlan"},
	52658: []string{"America/Tijuana"},
	52659: []string{"America/Mazatlan"},
	52661: []string{"America/Tijuana"},
	52662: []string{"America/Mazatlan"},
	52664: []string{"America/Tijuana"},
	52665: []string{"America/Tijuana"},
	52667: []string{"America/Mazatlan"},
	52668: []string{"America/Mazatlan"},
	52669: []string{"America/Mazatlan"},
	52671: []string{"America/Mexico_City"},
	52672: []string{"America/Mazatlan"},
	52673: []string{"America/Mazatlan"},
	52674: []string{"America/Mexico_City"},
	52675: []string{"America/Mexico_City"},
	52676: []string{"America/Mexico_City"},
	52677: []string{"America/Mexico_City"},
	52686: []string{"America/Tijuana"},
	52687: []string{"America/Mazatlan"},
	5269:  []string{"America/Mazatlan"},
	527:   []string{"America/Mexico_City"},
	528:   []string{"America/Mexico_City"},
	5291:  []string{"America/Mexico_City"},
	5292:  []string{"America/Mexico_City"},
	5293:  []string{"America/Mexico_City"},
	5295:  []string{"America/Mexico_City"},
	5296:  []string{"America/Mexico_City"},
	5297:  []string{"America/Mexico_City"},
	52981: []string{"America/Mexico_City"},
	52982: []string{"America/Mexico_City"},
	52983: []string{
		"America/Mexico_City",
		"America/New_York",
	},
	52984: []string{
		"America/Mexico_City",
		"America/New_York",
	},
	52985: []string{"America/Mexico_City"},
	52986: []string{"America/Mexico_City"},
	52987: []string{"America/New_York"},
	52988: []string{"America/Mexico_City"},
	52991: []string{"America/Mexico_City"},
	52992: []string{"America/Mexico_City"},
	52993: []string{"America/Mexico_City"},
	52994: []string{"America/Mexico_City"},
	52995: []string{"America/Mexico_City"},
	52996: []string{"America/Mexico_City"},
	52997: []string{"America/Mexico_City"},
	52998: []string{
		"America/Mexico_City",
		"America/New_York",
	},
	52999: []string{"America/Mexico_City"},
	53:    []string{"America/Havana"},
	54:    []string{"America/Buenos_Aires"},
	55: []string{
		"America/Manaus",
		"America/Noronha",
		"America/Rio_Branco",
		"America/Sao_Paulo",
	},
	551:  []string{"America/Sao_Paulo"},
	552:  []string{"America/Sao_Paulo"},
	553:  []string{"America/Sao_Paulo"},
	554:  []string{"America/Sao_Paulo"},
	555:  []string{"America/Sao_Paulo"},
	5561: []string{"America/Sao_Paulo"},
	5562: []string{"America/Sao_Paulo"},
	5563: []string{"America/Sao_Paulo"},
	5564: []string{"America/Sao_Paulo"},
	5565: []string{"America/Manaus"},
	5566: []string{"America/Manaus"},
	5567: []string{"America/Manaus"},
	5568: []string{"America/Rio_Branco"},
	5569: []string{"America/Manaus"},
	557:  []string{"America/Sao_Paulo"},
	5581: []string{"America/Noronha"},
	5582: []string{"America/Sao_Paulo"},
	5583: []string{"America/Sao_Paulo"},
	5584: []string{"America/Sao_Paulo"},
	5585: []string{"America/Sao_Paulo"},
	5586: []string{"America/Sao_Paulo"},
	5587: []string{"America/Sao_Paulo"},
	5588: []string{"America/Sao_Paulo"},
	5589: []string{"America/Sao_Paulo"},
	5591: []string{"America/Manaus"},
	5592: []string{"America/Manaus"},
	5593: []string{"America/Manaus"},
	5594: []string{"America/Manaus"},
	5595: []string{"America/Manaus"},
	5596: []string{"America/Sao_Paulo"},
	5597: []string{"America/Manaus"},
	5598: []string{"America/Sao_Paulo"},
	5599: []string{"America/Sao_Paulo"},
	56: []string{
		"America/Santiago",
		"Pacific/Easter",
	},
	562:  []string{"America/Santiago"},
	5632: []string{"Pacific/Easter"},
	5633: []string{"America/Santiago"},
	5634: []string{"America/Santiago"},
	5635: []string{"America/Santiago"},
	564:  []string{"America/Santiago"},
	565:  []string{"America/Santiago"},
	566:  []string{"America/Santiago"},
	567:  []string{"America/Santiago"},
	57:   []string{"America/Bogota"},
	58:   []string{"America/Caracas"},
	590: []string{"America/Guadeloupe",
		"America/Halifax",
		"America/Marigot",
	},
	591: []string{"America/La_Paz"},
	592: []string{"America/Guyana"},
	593: []string{
		"America/Guayaquil",
		"Pacific/Galapagos",
	},
	5932: []string{"America/Guayaquil"},
	5933: []string{"America/Guayaquil"},
	5934: []string{"America/Guayaquil"},
	5935: []string{"America/Guayaquil"},
	5936: []string{"America/Guayaquil"},
	5937: []string{"America/Guayaquil"},
	594:  []string{"America/Cayenne"},
	595:  []string{"America/Asuncion"},
	596:  []string{"America/Martinique"},
	597:  []string{"America/Paramaribo"},
	598:  []string{"America/Montevideo"},
	599: []string{
		"America/Curacao",
		"America/Kralendijk",
	},
	5993: []string{"America/Kralendijk"},
	5994: []string{"America/Kralendijk"},
	5997: []string{"America/Kralendijk"},
	5999: []string{"America/Curacao"},
	60:   []string{"Asia/Kuching"},
	61: []string{
		"Australia/Sydney",
		"Antarctica/Macquarie",
		"Australia/Adelaide",
		"Australia/Eucla",
		"Australia/Lord_Howe",
		"Australia/Perth",
		"Indian/Christmas",
		"Indian/Cocos",
	},
	612: []string{"Australia/Sydney"},
	613: []string{"Australia/Sydney"},
	617: []string{"Australia/Sydney"},
	618: []string{
		"Australia/Adelaide",
		"Australia/Perth",
	},
	62: []string{
		"Asia/Jakarta",
		"Asia/Jayapura",
		"Asia/Makassar",
	},
	622:   []string{"Asia/Jakarta"},
	6231:  []string{"Asia/Jakarta"},
	6232:  []string{"Asia/Jakarta"},
	6233:  []string{"Asia/Jakarta"},
	6234:  []string{"Asia/Jakarta"},
	6235:  []string{"Asia/Jakarta"},
	6236:  []string{"Asia/Makassar"},
	6237:  []string{"Asia/Makassar"},
	6238:  []string{"Asia/Makassar"},
	62401: []string{"Asia/Makassar"},
	62402: []string{"Asia/Makassar"},
	62403: []string{
		"Asia/Jayapura",
		"Asia/Makassar",
	},
	62404: []string{"Asia/Makassar"},
	62405: []string{"Asia/Makassar"},
	62408: []string{"Asia/Makassar"},
	62409: []string{"Asia/Makassar"},
	6241:  []string{"Asia/Makassar"},
	6242:  []string{"Asia/Makassar"},
	6243:  []string{"Asia/Makassar"},
	6244:  []string{"Asia/Makassar"},
	6245:  []string{"Asia/Makassar"},
	6246:  []string{"Asia/Makassar"},
	6247:  []string{"Asia/Makassar"},
	6248:  []string{"Asia/Makassar"},
	62511: []string{"Asia/Makassar"},
	62512: []string{"Asia/Makassar"},
	62513: []string{"Asia/Jakarta"},
	62516: []string{"Asia/Jakarta"},
	62517: []string{"Asia/Makassar"},
	62518: []string{"Asia/Makassar"},
	62519: []string{"Asia/Jakarta"},
	62522: []string{"Asia/Jakarta"},
	62525: []string{"Asia/Jakarta"},
	62526: []string{
		"Asia/Jakarta",
		"Asia/Makassar",
	},
	62527: []string{"Asia/Makassar"},
	62528: []string{"Asia/Jakarta"},
	6253:  []string{"Asia/Jakarta"},
	6254:  []string{"Asia/Makassar"},
	6255:  []string{"Asia/Makassar"},
	6256:  []string{"Asia/Jakarta"},
	626:   []string{"Asia/Jakarta"},
	627:   []string{"Asia/Jakarta"},
	6290:  []string{"Asia/Jayapura"},
	62910: []string{"Asia/Jayapura"},
	62911: []string{"Asia/Jayapura"},
	62913: []string{"Asia/Jayapura"},
	62914: []string{"Asia/Jayapura"},
	62915: []string{
		"Asia/Jakarta",
		"Asia/Jayapura",
	},
	62916: []string{"Asia/Jayapura"},
	62917: []string{"Asia/Jayapura"},
	62918: []string{"Asia/Jayapura"},
	6292:  []string{"Asia/Jayapura"},
	62951: []string{"Asia/Jayapura"},
	62952: []string{"Asia/Jayapura"},
	62955: []string{"Asia/Jayapura"},
	62956: []string{"Asia/Jayapura"},
	62957: []string{"Asia/Jayapura"},
	62958: []string{"Asia/Jakarta"},
	62962: []string{"Asia/Jayapura"},
	62963: []string{"Asia/Jakarta"},
	62966: []string{"Asia/Jayapura"},
	62967: []string{"Asia/Jayapura"},
	62969: []string{"Asia/Jayapura"},
	62971: []string{"Asia/Jayapura"},
	62975: []string{
		"Asia/Jakarta",
		"Asia/Jayapura",
	},
	62979: []string{
		"Asia/Jakarta",
		"Asia/Jayapura",
	},
	6298: []string{"Asia/Jayapura"},
	63:   []string{"Asia/Manila"},
	64: []string{
		"Pacific/Auckland",
		"Pacific/Chatham",
	},
	643:    []string{"Pacific/Auckland"},
	643305: []string{"Pacific/Chatham"},
	644:    []string{"Pacific/Auckland"},
	646:    []string{"Pacific/Auckland"},
	647:    []string{"Pacific/Auckland"},
	649:    []string{"Pacific/Auckland"},
	65:     []string{"Asia/Singapore"},
	66:     []string{"Asia/Bangkok"},
	670:    []string{"Asia/Dili"},
	672:    []string{"Pacific/Norfolk"},
	673:    []string{"Asia/Brunei"},
	674:    []string{"Pacific/Nauru"},
	675:    []string{"Pacific/Port_Moresby"},
	676:    []string{"Pacific/Tongatapu"},
	677:    []string{"Pacific/Guadalcanal"},
	678:    []string{"Pacific/Efate"},
	679:    []string{"Pacific/Fiji"},
	680:    []string{"Pacific/Palau"},
	681:    []string{"Pacific/Wallis"},
	682:    []string{"Pacific/Rarotonga"},
	683:    []string{"Pacific/Niue"},
	685:    []string{"Pacific/Apia"},
	686: []string{
		"Pacific/Enderbury",
		"Pacific/Kiritimati",
		"Pacific/Tarawa",
	},
	687: []string{"Pacific/Noumea"},
	688: []string{"Pacific/Funafuti"},
	689: []string{
		"Pacific/Gambier",
		"Pacific/Marquesas",
		"Pacific/Tahiti",
	},
	6894:  []string{"Pacific/Tahiti"},
	6895:  []string{"Pacific/Tahiti"},
	6896:  []string{"Pacific/Tahiti"},
	6898:  []string{"Pacific/Tahiti"},
	68990: []string{"Pacific/Tahiti"},
	68991: []string{"Pacific/Marquesas"},
	68992: []string{"Pacific/Marquesas"},
	68993: []string{"Pacific/Tahiti"},
	68994: []string{"Pacific/Tahiti"},
	68995: []string{"Pacific/Tahiti"},
	68996: []string{"Pacific/Tahiti"},
	68997: []string{"Pacific/Gambier"},
	68998: []string{"Pacific/Tahiti"},
	690:   []string{"Pacific/Fakaofo"},
	691: []string{
		"Pacific/Kosrae",
		"Pacific/Ponape",
		"Pacific/Truk",
	},
	69132: []string{"Pacific/Ponape"},
	69133: []string{"Pacific/Truk"},
	69135: []string{"Pacific/Truk"},
	69137: []string{
		"Pacific/Kosrae",
		"Pacific/Truk",
	},
	6919: []string{"Pacific/Ponape"},
	692:  []string{"Pacific/Majuro"},
	7: []string{
		"Asia/Almaty",
		"Asia/Aqtobe",
		"Asia/Irkutsk",
		"Asia/Kamchatka",
		"Asia/Krasnoyarsk",
		"Asia/Magadan",
		"Asia/Novosibirsk",
		"Asia/Omsk",
		"Asia/Sakhalin",
		"Asia/Vladivostok",
		"Asia/Yakutsk",
		"Asia/Yekaterinburg",
		"Europe/Bucharest",
		"Europe/Moscow",
		"Europe/Samara",
	},
	7301: []string{"Asia/Irkutsk"},
	7302: []string{"Asia/Yakutsk"},
	733:  []string{"Asia/Almaty"},
	7341: []string{"Europe/Samara"},
	7342: []string{"Asia/Yekaterinburg"},
	7343: []string{"Asia/Yekaterinburg"},
	7345: []string{"Asia/Yekaterinburg"},
	7346: []string{"Asia/Yekaterinburg"},
	7347: []string{"Asia/Yekaterinburg"},
	7349: []string{"Asia/Yekaterinburg"},
	735:  []string{"Asia/Yekaterinburg"},
	736:  []string{"Europe/Moscow"},
	738:  []string{"Asia/Omsk"},
	7390: []string{"Asia/Krasnoyarsk"},
	7391: []string{"Asia/Krasnoyarsk"},
	7394: []string{"Asia/Krasnoyarsk"},
	7395: []string{"Asia/Irkutsk"},
	740:  []string{"Europe/Bucharest"},
	7411: []string{"Asia/Yakutsk"},
	7413: []string{"Asia/Vladivostok"},
	7415: []string{"Asia/Magadan"},
	7416: []string{"Asia/Yakutsk"},
	7421: []string{"Asia/Vladivostok"},
	7423: []string{"Asia/Vladivostok"},
	7424: []string{"Asia/Vladivostok"},
	7426: []string{"Asia/Vladivostok"},
	7427: []string{"Asia/Magadan"},
	747:  []string{"Europe/Moscow"},
	748:  []string{"Europe/Moscow"},
	749:  []string{"Europe/Moscow"},
	7710: []string{"Asia/Almaty"},
	7711: []string{"Asia/Aqtobe"},
	7712: []string{"Asia/Aqtobe"},
	7713: []string{"Asia/Aqtobe"},
	7714: []string{"Asia/Almaty"},
	7715: []string{"Asia/Almaty"},
	7716: []string{"Asia/Almaty"},
	7717: []string{"Asia/Almaty"},
	7718: []string{"Asia/Almaty"},
	7721: []string{"Asia/Almaty"},
	7722: []string{"Asia/Almaty"},
	7723: []string{"Asia/Almaty"},
	7724: []string{"Asia/Almaty"},
	7725: []string{"Asia/Almaty"},
	7726: []string{"Asia/Almaty"},
	7727: []string{"Asia/Almaty"},
	7728: []string{"Asia/Almaty"},
	7729: []string{"Asia/Aqtobe"},
	781:  []string{"Europe/Moscow"},
	782:  []string{"Europe/Moscow"},
	783:  []string{"Europe/Moscow"},
	7840: []string{"Europe/Moscow"},
	7841: []string{"Europe/Moscow"},
	7842: []string{"Europe/Moscow"},
	7843: []string{"Europe/Moscow"},
	7844: []string{"Europe/Moscow"},
	7845: []string{"Europe/Moscow"},
	7846: []string{"Europe/Samara"},
	7847: []string{"Europe/Moscow"},
	7848: []string{"Europe/Samara"},
	785:  []string{"Europe/Moscow"},
	786:  []string{"Europe/Moscow"},
	787:  []string{"Europe/Moscow"},
	81:   []string{"Asia/Tokyo"},
	82:   []string{"Asia/Seoul"},
	84:   []string{"Asia/Saigon"},
	850:  []string{"Asia/Pyongyang"},
	852:  []string{"Asia/Hong_Kong"},
	853:  []string{"Asia/Shanghai"},
	855:  []string{"Asia/Phnom_Penh"},
	856:  []string{"Asia/Vientiane"},
	86: []string{
		"Asia/Shanghai",
		"Asia/Urumqi",
	},
	861: []string{
		"Asia/Shanghai",
		"Asia/Urumqi",
	},
	862: []string{"Asia/Shanghai"},
	863: []string{"Asia/Shanghai"},
	864: []string{"Asia/Shanghai"},
	865: []string{"Asia/Shanghai"},
	866: []string{"Asia/Shanghai"},
	867: []string{"Asia/Shanghai"},
	868: []string{"Asia/Shanghai"},
	869: []string{"Asia/Shanghai"},
	880: []string{"Asia/Dhaka"},
	886: []string{"Asia/Taipei"},
	90:  []string{"Europe/Bucharest"},
	91:  []string{"Asia/Calcutta"},
	92:  []string{"Asia/Karachi"},
	93:  []string{"Asia/Kabul"},
	94:  []string{"Asia/Colombo"},
	95:  []string{"Asia/Rangoon"},
	960: []string{"Indian/Maldives"},
	961: []string{"Asia/Beirut"},
	962: []string{"Asia/Amman"},
	963: []string{"Asia/Damascus"},
	964: []string{"Asia/Baghdad"},
	965: []string{"Asia/Kuwait"},
	966: []string{"Asia/Riyadh"},
	967: []string{"Asia/Aden"},
	968: []string{"Asia/Muscat"},
	970: []string{"Europe/Bucharest"},
	971: []string{"Asia/Dubai"},
	972: []string{"Asia/Jerusalem"},
	973: []string{"Asia/Bahrain"},
	974: []string{"Asia/Qatar"},
	975: []string{"Asia/Thimphu"},
	976: []string{
		"Asia/Choibalsan",
		"Asia/Hovd",
		"Asia/Ulaanbaatar",
	},
	97611: []string{"Asia/Ulaanbaatar"},
	97612: []string{"Asia/Ulaanbaatar"},
	97613: []string{"Asia/Ulaanbaatar"},
	97614: []string{"Asia/Hovd"},
	97615: []string{"Asia/Ulaanbaatar"},
	977:   []string{"Asia/Katmandu"},
	98:    []string{"Asia/Tehran"},
	992:   []string{"Asia/Dushanbe"},
	993:   []string{"Asia/Ashgabat"},
	994:   []string{"Asia/Baku"},
	995:   []string{"Asia/Tbilisi"},
	996:   []string{"Asia/Bishkek"},
	998:   []string{"Asia/Tashkent"},
}

// Returns a slice of Timezones corresponding to the number passed
// or error when it is impossible to convert the string to int
// The algorythm tries to match the timezones starting from the maximum
// number of phone number digits and decreasing until it finds one or reaches 0
func GetTimeZonesForRegion(number string) ([]string, error) {
	for i := MAX_REGION_CODE_LENGTH; i > 0; i-- {
		index, err := strconv.Atoi(number[0:i])
		if err != nil {
			return nil, err
		}
		if CountryCodeToTimeZones[index] != nil {
			return CountryCodeToTimeZones[index], nil
		}
	}
	return []string{UNKNOWN_TIMEZONE}, nil
}
