/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"time"
	"bytes"
	"fmt"
)

// checks if the UsersInbound type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &UsersInbound{}

// UsersInbound struct for UsersInbound
type UsersInbound struct {
	// Dedicated number ID.
	Id int32 `json:"id"`
	// Format for representation of time.
	DisplayTimeFormat *string `json:"displayTimeFormat,omitempty"`
	// Dedicated phone number.
	Phone *string `json:"phone,omitempty"`
	User NullableUser `json:"user"`
	// Time when the dedicated number was purchased.
	PurchasedAt time.Time `json:"purchasedAt"`
	// Dedicated number subscription expiration time.
	ExpireAt time.Time `json:"expireAt"`
	// Number status: *   **U** for Unused. No messages have been sent from (or received to) this number; *   **A** for Active. 
	Status string `json:"status"`
	Country NullableCountry `json:"country"`
}

type _UsersInbound UsersInbound

// NewUsersInbound instantiates a new UsersInbound object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUsersInbound(id int32, user NullableUser, purchasedAt time.Time, expireAt time.Time, status string, country NullableCountry) *UsersInbound {
	this := UsersInbound{}
	this.Id = id
	this.User = user
	this.PurchasedAt = purchasedAt
	this.ExpireAt = expireAt
	this.Status = status
	this.Country = country
	return &this
}

// NewUsersInboundWithDefaults instantiates a new UsersInbound object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUsersInboundWithDefaults() *UsersInbound {
	this := UsersInbound{}
	return &this
}

// GetId returns the Id field value
func (o *UsersInbound) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *UsersInbound) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *UsersInbound) SetId(v int32) {
	o.Id = v
}

// GetDisplayTimeFormat returns the DisplayTimeFormat field value if set, zero value otherwise.
func (o *UsersInbound) GetDisplayTimeFormat() string {
	if o == nil || IsNil(o.DisplayTimeFormat) {
		var ret string
		return ret
	}
	return *o.DisplayTimeFormat
}

// GetDisplayTimeFormatOk returns a tuple with the DisplayTimeFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UsersInbound) GetDisplayTimeFormatOk() (*string, bool) {
	if o == nil || IsNil(o.DisplayTimeFormat) {
		return nil, false
	}
	return o.DisplayTimeFormat, true
}

// HasDisplayTimeFormat returns a boolean if a field has been set.
func (o *UsersInbound) HasDisplayTimeFormat() bool {
	if o != nil && !IsNil(o.DisplayTimeFormat) {
		return true
	}

	return false
}

// SetDisplayTimeFormat gets a reference to the given string and assigns it to the DisplayTimeFormat field.
func (o *UsersInbound) SetDisplayTimeFormat(v string) {
	o.DisplayTimeFormat = &v
}

// GetPhone returns the Phone field value if set, zero value otherwise.
func (o *UsersInbound) GetPhone() string {
	if o == nil || IsNil(o.Phone) {
		var ret string
		return ret
	}
	return *o.Phone
}

// GetPhoneOk returns a tuple with the Phone field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UsersInbound) GetPhoneOk() (*string, bool) {
	if o == nil || IsNil(o.Phone) {
		return nil, false
	}
	return o.Phone, true
}

// HasPhone returns a boolean if a field has been set.
func (o *UsersInbound) HasPhone() bool {
	if o != nil && !IsNil(o.Phone) {
		return true
	}

	return false
}

// SetPhone gets a reference to the given string and assigns it to the Phone field.
func (o *UsersInbound) SetPhone(v string) {
	o.Phone = &v
}

// GetUser returns the User field value
// If the value is explicit nil, the zero value for User will be returned
func (o *UsersInbound) GetUser() User {
	if o == nil || o.User.Get() == nil {
		var ret User
		return ret
	}

	return *o.User.Get()
}

// GetUserOk returns a tuple with the User field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UsersInbound) GetUserOk() (*User, bool) {
	if o == nil {
		return nil, false
	}
	return o.User.Get(), o.User.IsSet()
}

// SetUser sets field value
func (o *UsersInbound) SetUser(v User) {
	o.User.Set(&v)
}

// GetPurchasedAt returns the PurchasedAt field value
func (o *UsersInbound) GetPurchasedAt() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.PurchasedAt
}

// GetPurchasedAtOk returns a tuple with the PurchasedAt field value
// and a boolean to check if the value has been set.
func (o *UsersInbound) GetPurchasedAtOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.PurchasedAt, true
}

// SetPurchasedAt sets field value
func (o *UsersInbound) SetPurchasedAt(v time.Time) {
	o.PurchasedAt = v
}

// GetExpireAt returns the ExpireAt field value
func (o *UsersInbound) GetExpireAt() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.ExpireAt
}

// GetExpireAtOk returns a tuple with the ExpireAt field value
// and a boolean to check if the value has been set.
func (o *UsersInbound) GetExpireAtOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ExpireAt, true
}

// SetExpireAt sets field value
func (o *UsersInbound) SetExpireAt(v time.Time) {
	o.ExpireAt = v
}

// GetStatus returns the Status field value
func (o *UsersInbound) GetStatus() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Status
}

// GetStatusOk returns a tuple with the Status field value
// and a boolean to check if the value has been set.
func (o *UsersInbound) GetStatusOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Status, true
}

// SetStatus sets field value
func (o *UsersInbound) SetStatus(v string) {
	o.Status = v
}

// GetCountry returns the Country field value
// If the value is explicit nil, the zero value for Country will be returned
func (o *UsersInbound) GetCountry() Country {
	if o == nil || o.Country.Get() == nil {
		var ret Country
		return ret
	}

	return *o.Country.Get()
}

// GetCountryOk returns a tuple with the Country field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UsersInbound) GetCountryOk() (*Country, bool) {
	if o == nil {
		return nil, false
	}
	return o.Country.Get(), o.Country.IsSet()
}

// SetCountry sets field value
func (o *UsersInbound) SetCountry(v Country) {
	o.Country.Set(&v)
}

func (o UsersInbound) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o UsersInbound) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	if !IsNil(o.DisplayTimeFormat) {
		toSerialize["displayTimeFormat"] = o.DisplayTimeFormat
	}
	if !IsNil(o.Phone) {
		toSerialize["phone"] = o.Phone
	}
	toSerialize["user"] = o.User.Get()
	toSerialize["purchasedAt"] = o.PurchasedAt
	toSerialize["expireAt"] = o.ExpireAt
	toSerialize["status"] = o.Status
	toSerialize["country"] = o.Country.Get()
	return toSerialize, nil
}

func (o *UsersInbound) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"user",
		"purchasedAt",
		"expireAt",
		"status",
		"country",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varUsersInbound := _UsersInbound{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varUsersInbound)

	if err != nil {
		return err
	}

	*o = UsersInbound(varUsersInbound)

	return err
}

type NullableUsersInbound struct {
	value *UsersInbound
	isSet bool
}

func (v NullableUsersInbound) Get() *UsersInbound {
	return v.value
}

func (v *NullableUsersInbound) Set(val *UsersInbound) {
	v.value = val
	v.isSet = true
}

func (v NullableUsersInbound) IsSet() bool {
	return v.isSet
}

func (v *NullableUsersInbound) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUsersInbound(val *UsersInbound) *NullableUsersInbound {
	return &NullableUsersInbound{value: val, isSet: true}
}

func (v NullableUsersInbound) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUsersInbound) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


