package crack

import "fmt"

// Hashcat mode names sourced from client/credentials/EXAMPLES.md.
var hashcatHashTypes = map[int32]string{
	0:     "MD5",
	10:    "md5($pass.$salt)",
	11:    "Joomla < 2.5.18",
	12:    "PostgreSQL",
	20:    "md5($salt.$pass)",
	21:    "osCommerce, xt:Commerce",
	22:    "Juniper NetScreen/SSG (ScreenOS)",
	23:    "Skype",
	24:    "SolarWinds Serv-U",
	30:    "md5(utf16le($pass).$salt)",
	40:    "md5($salt.utf16le($pass))",
	50:    "HMAC-MD5 (key = $pass)",
	60:    "HMAC-MD5 (key = $salt)",
	70:    "md5(utf16le($pass))",
	100:   "SHA1",
	101:   "nsldap, SHA-1(Base64), Netscape LDAP SHA",
	110:   "sha1($pass.$salt)",
	111:   "nsldaps, SSHA-1(Base64), Netscape LDAP SSHA",
	112:   "Oracle S: Type (Oracle 11+)",
	120:   "sha1($salt.$pass)",
	121:   "SMF (Simple Machines Forum) > v1.1",
	122:   "macOS v10.4, macOS v10.5, macOS v10.6",
	123:   "EPi",
	124:   "Django (SHA-1)",
	125:   "ArubaOS",
	130:   "sha1(utf16le($pass).$salt)",
	131:   "MSSQL (2000)",
	132:   "MSSQL (2005)",
	133:   "PeopleSoft",
	140:   "sha1($salt.utf16le($pass))",
	141:   "Episerver 6.x < .NET 4",
	150:   "HMAC-SHA1 (key = $pass)",
	160:   "HMAC-SHA1 (key = $salt)",
	170:   "sha1(utf16le($pass))",
	190:   "sha1(LinkedIn)",
	200:   "MySQL323",
	300:   "MySQL4.1/MySQL5",
	400:   "phpass, phpBB3 (MD5)",
	500:   "md5crypt, MD5 (Unix), Cisco-IOS $1$ (MD5)",
	501:   "Juniper IVE",
	600:   "BLAKE2b-512",
	900:   "MD4",
	1000:  "NTLM",
	1100:  "Domain Cached Credentials (DCC), MS Cache",
	1300:  "SHA2-224",
	1400:  "SHA2-256",
	1410:  "sha256($pass.$salt)",
	1411:  "SSHA-256(Base64), LDAP {SSHA256}",
	1420:  "sha256($salt.$pass)",
	1421:  "hMailServer",
	1430:  "sha256(utf16le($pass).$salt)",
	1431:  "base64(sha256(unicode($pass)))",
	1440:  "sha256($salt.utf16le($pass))",
	1441:  "Episerver 6.x >= .NET 4",
	1450:  "HMAC-SHA256 (key = $pass)",
	1460:  "HMAC-SHA256 (key = $salt)",
	1470:  "sha256(utf16le($pass))",
	1500:  "descrypt, DES (Unix), Traditional DES",
	1600:  "Apache $apr1$ MD5, md5apr1, MD5 (APR)",
	1700:  "SHA2-512",
	1710:  "sha512($pass.$salt)",
	1711:  "SSHA-512(Base64), LDAP {SSHA512}",
	1720:  "sha512($salt.$pass)",
	1722:  "macOS v10.7",
	1730:  "sha512(utf16le($pass).$salt)",
	1731:  "MSSQL (2012, 2014)",
	1740:  "sha512($salt.utf16le($pass))",
	1750:  "HMAC-SHA512 (key = $pass)",
	1760:  "HMAC-SHA512 (key = $salt)",
	1770:  "sha512(utf16le($pass))",
	1800:  "sha512crypt $6$, SHA512 (Unix)",
	2000:  "STDOUT",
	2100:  "Domain Cached Credentials 2 (DCC2), MS Cache 2",
	2400:  "Cisco-PIX MD5",
	2410:  "Cisco-ASA MD5",
	2500:  "WPA-EAPOL-PBKDF2",
	2501:  "WPA-EAPOL-PMK",
	2600:  "md5(md5($pass))",
	2611:  "vBulletin < v3.8.5",
	2612:  "PHPS",
	2711:  "vBulletin >= v3.8.5",
	2811:  "MyBB 1.2+, IPB2+ (Invision Power Board)",
	3000:  "LM",
	3100:  "Oracle H: Type (Oracle 7+)",
	3200:  "bcrypt $2\\*$, Blowfish (Unix)",
	3300:  "MD5(Sun)",
	3500:  "md5(md5(md5($pass)))",
	3610:  "md5(md5($salt).$pass )",
	3710:  "md5($salt.md5($pass))",
	3711:  "MediaWiki B type",
	3720:  "md5($pass.md5($salt))",
	3721:  "WebEdition CMS",
	3800:  "md5($salt.$pass.$salt)",
	3910:  "md5(md5($pass).md5($salt))",
	4010:  "md5($salt.md5($salt.$pass))",
	4110:  "md5($salt.md5($pass.$salt))",
	4210:  "md5($username.0.$pass)",
	4300:  "md5(strtoupper(md5($pass)))",
	4400:  "md5(sha1($pass))",
	4500:  "sha1(sha1($pass))",
	4510:  "sha1(sha1($pass).$salt)",
	4520:  "sha1($salt.sha1($pass))",
	4521:  "Redmine",
	4522:  "PunBB",
	4600:  "sha1(sha1(sha1($pass)))",
	4700:  "sha1(md5($pass))",
	4710:  "sha1(md5($pass).$salt)",
	4711:  "Huawei sha1(md5($pass).$salt)",
	4800:  "iSCSI CHAP authentication, MD5(CHAP)",
	4900:  "sha1($salt.$pass.$salt)",
	5000:  "sha1(sha1($salt.$pass.$salt))",
	5100:  "Half MD5",
	5200:  "Password Safe v3",
	5300:  "IKE-PSK MD5",
	5400:  "IKE-PSK SHA1",
	5500:  "NetNTLMv1 / NetNTLMv1+ESS",
	5600:  "NetNTLMv2",
	5700:  "Cisco-IOS type 4 (SHA256)",
	5800:  "Samsung Android Password/PIN",
	6000:  "RIPEMD-160",
	6100:  "Whirlpool",
	6211:  "TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + AES / TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + Serpent / TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + Twofish",
	6212:  "TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + AES-Twofish / TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + Serpent-AES / TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + Twofish-Serpent",
	6213:  "TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + AES-Twofish-Serpent / TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + Serpent-Twofish-AES",
	6221:  "TrueCrypt 5.0+ SHA512 + AES / TrueCrypt 5.0+ SHA512 + Serpent / TrueCrypt 5.0+ SHA512 + Twofish",
	6222:  "TrueCrypt 5.0+ SHA512 + AES-Twofish / TrueCrypt 5.0+ SHA512 + Serpent-AES / TrueCrypt 5.0+ SHA512 + Twofish-Serpent",
	6223:  "TrueCrypt 5.0+ SHA512 + AES-Twofish-Serpent / TrueCrypt 5.0+ SHA512 + Serpent-Twofish-AES",
	6231:  "TrueCrypt 5.0+ Whirlpool + AES / TrueCrypt 5.0+ Whirlpool + Serpent / TrueCrypt 5.0+ Whirlpool + Twofish",
	6232:  "TrueCrypt 5.0+ Whirlpool + AES-Twofish / TrueCrypt 5.0+ Whirlpool + Serpent-AES / TrueCrypt 5.0+ Whirlpool + Twofish-Serpent",
	6233:  "TrueCrypt 5.0+ Whirlpool + AES-Twofish-Serpent / TrueCrypt 5.0+ Whirlpool + Serpent-Twofish-AES",
	6241:  "TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + AES + boot / TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + Serpent + boot / TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + Twofish + boot",
	6242:  "TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + AES-Twofish + boot / TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + Serpent-AES + boot / TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + Twofish-Serpent + boot",
	6243:  "TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + AES-Twofish-Serpent + boot / TrueCrypt 5.0+ PBKDF2-HMAC-RIPEMD160 + Serpent-Twofish-AES + boot",
	6300:  "AIX {smd5}",
	6400:  "AIX {ssha256}",
	6500:  "AIX {ssha512}",
	6600:  "1Password, agilekeychain",
	6700:  "AIX {ssha1}",
	6800:  "LastPass + LastPass sniffed",
	6900:  "GOST R 34.11-94",
	7000:  "FortiGate (FortiOS)",
	7100:  "macOS v10.8+ (PBKDF2-SHA512)",
	7200:  "GRUB 2",
	7300:  "IPMI2 RAKP HMAC-SHA1",
	7400:  "sha256crypt $5$, SHA256 (Unix)",
	7401:  "MySQL $A$ (sha256crypt)",
	7500:  "Kerberos 5, etype 23, AS-REQ Pre-Auth",
	7700:  "SAP CODVN B (BCODE)",
	7701:  "SAP CODVN B (BCODE) from RFC_READ_TABLE",
	7800:  "SAP CODVN F/G (PASSCODE)",
	7801:  "SAP CODVN F/G (PASSCODE) from RFC_READ_TABLE",
	7900:  "Drupal7",
	8000:  "Sybase ASE",
	8100:  "Citrix NetScaler (SHA1)",
	8200:  "1Password, cloudkeychain",
	8300:  "DNSSEC (NSEC3)",
	8400:  "WBB3 (Woltlab Burning Board)",
	8500:  "RACF",
	8600:  "Lotus Notes/Domino 5",
	8700:  "Lotus Notes/Domino 6",
	8800:  "Android FDE <= 4.3",
	8900:  "scrypt",
	9000:  "Password Safe v2",
	9100:  "Lotus Notes/Domino 8",
	9200:  "Cisco-IOS $8$ (PBKDF2-SHA256)",
	9300:  "Cisco-IOS $9$ (scrypt)",
	9400:  "MS Office 2007",
	9500:  "MS Office 2010",
	9600:  "MS Office 2013",
	9700:  "MS Office <= 2003 MD5 + RC4, oldoffice$0, oldoffice$1",
	9710:  "MS Office <= 2003 $0/$1, MD5 + RC4, collider #1",
	9720:  "MS Office <= 2003 $0/$1, MD5 + RC4, collider #2",
	9800:  "MS Office <= 2003 SHA1 + RC4, oldoffice$3, oldoffice$4",
	9810:  "MS Office <= 2003 $3, SHA1 + RC4, collider #1",
	9820:  "MS Office <= 2003 $3, SHA1 + RC4, collider #2",
	9900:  "Radmin2",
	10000: "Django (PBKDF2-SHA256)",
	10100: "SipHash",
	10200: "CRAM-MD5",
	10300: "SAP CODVN H (PWDSALTEDHASH) iSSHA-1",
	10400: "PDF 1.1 - 1.3 (Acrobat 2 - 4)",
	10410: "PDF 1.1 - 1.3 (Acrobat 2 - 4), collider #1",
	10420: "PDF 1.1 - 1.3 (Acrobat 2 - 4), collider #2",
	10500: "PDF 1.4 - 1.6 (Acrobat 5 - 8)",
	10600: "PDF 1.7 Level 3 (Acrobat 9)",
	10700: "PDF 1.7 Level 8 (Acrobat 10 - 11)",
	10800: "SHA2-384",
	10810: "sha384($pass.$salt)",
	10820: "sha384($salt.$pass)",
	10830: "sha384(utf16le($pass).$salt)",
	10840: "sha384($salt.utf16le($pass))",
	10870: "sha384(utf16le($pass))",
	10900: "PBKDF2-HMAC-SHA256",
	10901: "RedHat 389-DS LDAP (PBKDF2-HMAC-SHA256)",
	11000: "PrestaShop",
	11100: "PostgreSQL CRAM (MD5)",
	11200: "MySQL CRAM (SHA1)",
	11300: "Bitcoin/Litecoin wallet.dat",
	11400: "SIP digest authentication (MD5)",
	11500: "CRC32",
	11600: "7-Zip",
	11700: "GOST R 34.11-2012 (Streebog) 256-bit, big-endian",
	11750: "HMAC-Streebog-256 (key = $pass), big-endian",
	11760: "HMAC-Streebog-256 (key = $salt), big-endian",
	11800: "GOST R 34.11-2012 (Streebog) 512-bit, big-endian",
	11850: "HMAC-Streebog-512 (key = $pass), big-endian",
	11860: "HMAC-Streebog-512 (key = $salt), big-endian",
	11900: "PBKDF2-HMAC-MD5",
	12000: "PBKDF2-HMAC-SHA1",
	12001: "Atlassian (PBKDF2-HMAC-SHA1)",
	12100: "PBKDF2-HMAC-SHA512",
	12200: "eCryptfs",
	12300: "Oracle T: Type (Oracle 12+)",
	12400: "BSDi Crypt, Extended DES",
	12500: "RAR3-hp",
	12600: "ColdFusion 10+",
	12700: "Blockchain, My Wallet",
	12800: "MS-AzureSync PBKDF2-HMAC-SHA256",
	12900: "Android FDE (Samsung DEK)",
	13000: "RAR5",
	13100: "Kerberos 5, etype 23, TGS-REP",
	13200: "AxCrypt 1",
	13300: "AxCrypt 1 in-memory SHA1",
	13400: "KeePass 1 AES / without keyfile / KeePass 2 AES / without keyfile / KeePass 1 Twofish / with keyfile / Keepass 2 AES / with keyfile",
	13500: "PeopleSoft PS_TOKEN",
	13600: "WinZip",
	13711: "VeraCrypt PBKDF2-HMAC-RIPEMD160 + AES / VeraCrypt PBKDF2-HMAC-RIPEMD160 + Serpent / VeraCrypt PBKDF2-HMAC-RIPEMD160 + Twofish",
	13712: "VeraCrypt PBKDF2-HMAC-RIPEMD160 + AES-Twofish / VeraCrypt PBKDF2-HMAC-RIPEMD160 + Serpent-AES / VeraCrypt PBKDF2-HMAC-RIPEMD160 + Twofish-Serpent",
	13713: "VeraCrypt PBKDF2-HMAC-RIPEMD160 + Serpent-Twofish-AES",
	13721: "VeraCrypt PBKDF2-HMAC-SHA512 + AES / VeraCrypt PBKDF2-HMAC-SHA512 + Serpent / VeraCrypt PBKDF2-HMAC-SHA512 + Twofish",
	13722: "VeraCrypt PBKDF2-HMAC-SHA512 + AES-Twofish / VeraCrypt PBKDF2-HMAC-SHA512 + Serpent-AES / VeraCrypt PBKDF2-HMAC-SHA512 + Twofish-Serpent",
	13723: "VeraCrypt PBKDF2-HMAC-SHA512 + Serpent-Twofish-AES",
	13731: "VeraCrypt PBKDF2-HMAC-Whirlpool + AES / VeraCrypt PBKDF2-HMAC-Whirlpool + Serpent / VeraCrypt PBKDF2-HMAC-Whirlpool + Twofish",
	13732: "VeraCrypt PBKDF2-HMAC-Whirlpool + AES-Twofish / VeraCrypt PBKDF2-HMAC-Whirlpool + Serpent-AES / VeraCrypt PBKDF2-HMAC-Whirlpool + Twofish-Serpent",
	13733: "VeraCrypt PBKDF2-HMAC-Whirlpool + Serpent-Twofish-AES",
	13741: "VeraCrypt PBKDF2-HMAC-RIPEMD160 + boot-mode + AES",
	13742: "VeraCrypt PBKDF2-HMAC-RIPEMD160 + boot-mode + AES-Twofish",
	13743: "VeraCrypt PBKDF2-HMAC-RIPEMD160 + boot-mode + AES-Twofish-Serpent",
	13751: "VeraCrypt PBKDF2-HMAC-SHA256 + AES / VeraCrypt PBKDF2-HMAC-SHA256 + Serpent / VeraCrypt PBKDF2-HMAC-SHA256 + Twofish",
	13752: "VeraCrypt PBKDF2-HMAC-SHA256 + AES-Twofish / VeraCrypt PBKDF2-HMAC-SHA256 + Serpent-AES / VeraCrypt PBKDF2-HMAC-SHA256 + Twofish-Serpent",
	13753: "VeraCrypt PBKDF2-HMAC-SHA256 + Serpent-Twofish-AES",
	13761: "VeraCrypt PBKDF2-HMAC-SHA256 + boot-mode + Twofish / VeraCrypt PBKDF2-HMAC-SHA256 + boot-mode + PIM + AES",
	13762: "VeraCrypt PBKDF2-HMAC-SHA256 + boot-mode + Serpent-AES",
	13763: "VeraCrypt PBKDF2-HMAC-SHA256 + boot-mode + Serpent-Twofish-AES",
	13771: "VeraCrypt Streebog-512 + XTS 512 bit",
	13772: "VeraCrypt Streebog-512 + XTS 1024 bit",
	13773: "VeraCrypt Streebog-512 + XTS 1536 bit",
	13800: "Windows Phone 8+ PIN/password",
	13900: "OpenCart",
	14000: "DES (PT = $salt, key = $pass)",
	14100: "3DES (PT = $salt, key = $pass)",
	14400: "sha1(CX)",
	14500: "Linux Kernel Crypto API (2.4)",
	14600: "LUKS",
	14700: "iTunes backup < 10.0",
	14800: "iTunes backup >= 10.0",
	14900: "Skip32 (PT = $salt, key = $pass)",
	15000: "FileZilla Server >= 0.9.55",
	15100: "Juniper/NetBSD sha1crypt",
	15200: "Blockchain, My Wallet, V2",
	15300: "DPAPI masterkey file v1 + local context",
	15400: "ChaCha20",
	15500: "JKS Java Key Store Private Keys (SHA1)",
	15600: "Ethereum Wallet, PBKDF2-HMAC-SHA256",
	15700: "Ethereum Wallet, SCRYPT",
	15900: "DPAPI masterkey file v2 + Active Directory domain context",
	16000: "Tripcode",
	16100: "TACACS+",
	16200: "Apple Secure Notes",
	16300: "Ethereum Pre-Sale Wallet, PBKDF2-HMAC-SHA256",
	16400: "CRAM-MD5 Dovecot",
	16500: "JWT (JSON Web Token)",
	16600: "Electrum Wallet (Salt-Type 1-3)",
	16700: "FileVault 2",
	16800: "WPA-PMKID-PBKDF2",
	16801: "WPA-PMKID-PMK",
	16900: "Ansible Vault",
	17200: "PKZIP (Compressed)",
	17210: "PKZIP (Uncompressed)",
	17220: "PKZIP (Compressed Multi-File)",
	17225: "PKZIP (Mixed Multi-File)",
	17230: "PKZIP (Mixed Multi-File Checksum-Only)",
	17300: "SHA3-224",
	17400: "SHA3-256",
	17500: "SHA3-384",
	17600: "SHA3-512",
	17700: "Keccak-224",
	17800: "Keccak-256",
	17900: "Keccak-384",
	18000: "Keccak-512",
	18100: "TOTP (HMAC-SHA1)",
	18200: "Kerberos 5, etype 23, AS-REP",
	18300: "Apple File System (APFS)",
	18400: "Open Document Format (ODF) 1.2 (SHA-256, AES)",
	18500: "sha1(md5(md5($pass)))",
	18600: "Open Document Format (ODF) 1.1 (SHA-1, Blowfish)",
	18700: "Java Object hashCode()",
	18800: "Blockchain, My Wallet, Second Password (SHA256)",
	18900: "Android Backup",
	19000: "QNX /etc/shadow (MD5)",
	19100: "QNX /etc/shadow (SHA256)",
	19200: "QNX /etc/shadow (SHA512)",
	19300: "sha1($salt1.$pass.$salt2)",
	19500: "Ruby on Rails Restful-Authentication",
	19600: "Kerberos 5, etype 17, TGS-REP (AES128-CTS-HMAC-SHA1-96)",
	19700: "Kerberos 5, etype 18, TGS-REP (AES256-CTS-HMAC-SHA1-96)",
	19800: "Kerberos 5, etype 17, Pre-Auth",
	19900: "Kerberos 5, etype 18, Pre-Auth",
	20011: "DiskCryptor SHA512 + XTS 512 bit (AES) / DiskCryptor SHA512 + XTS 512 bit (Twofish) / DiskCryptor SHA512 + XTS 512 bit (Serpent)",
	20012: "DiskCryptor SHA512 + XTS 1024 bit (AES-Twofish) / DiskCryptor SHA512 + XTS 1024 bit (Twofish-Serpent) / DiskCryptor SHA512 + XTS 1024 bit (Serpent-AES)",
	20013: "DiskCryptor SHA512 + XTS 1536 bit (AES-Twofish-Serpent)",
	20200: "Python passlib pbkdf2-sha512",
	20300: "Python passlib pbkdf2-sha256",
	20400: "Python passlib pbkdf2-sha1",
	20500: "PKZIP Master Key",
	20510: "PKZIP Master Key (6 byte optimization)",
	20600: "Oracle Transportation Management (SHA256)",
	20710: "sha256(sha256($pass).$salt)",
	20711: "AuthMe sha256",
	20720: "sha256($salt.sha256($pass))",
	20800: "sha256(md5($pass))",
	20900: "md5(sha1($pass).md5($pass).sha1($pass))",
	21000: "BitShares v0.x - sha512(sha512_bin(pass))",
	21100: "sha1(md5($pass.$salt))",
	21200: "md5(sha1($salt).md5($pass))",
	21300: "md5($salt.sha1($salt.$pass))",
	21400: "sha256(sha256_bin($pass))",
	21500: "SolarWinds Orion",
	21501: "SolarWinds Orion v2",
	21600: "Web2py pbkdf2-sha512",
	21700: "Electrum Wallet (Salt-Type 4)",
	21800: "Electrum Wallet (Salt-Type 5)",
	22000: "WPA-PBKDF2-PMKID+EAPOL",
	22001: "WPA-PMK-PMKID+EAPOL",
	22100: "BitLocker",
	22200: "Citrix NetScaler (SHA512)",
	22300: "sha256($salt.$pass.$salt)",
	22301: "Telegram Mobile App Passcode (SHA256)",
	22400: "AES Crypt (SHA256)",
	22500: "MultiBit Classic .key (MD5)",
	22600: "Telegram Desktop < v2.1.14 (PBKDF2-HMAC-SHA1)",
	22700: "MultiBit HD (scrypt)",
	22911: "RSA/DSA/EC/OpenSSH Private Keys ($0$)",
	22921: "RSA/DSA/EC/OpenSSH Private Keys ($6$)",
	22931: "RSA/DSA/EC/OpenSSH Private Keys ($1, $3$)",
	22941: "RSA/DSA/EC/OpenSSH Private Keys ($4$)",
	22951: "RSA/DSA/EC/OpenSSH Private Keys ($5$)",
	23001: "SecureZIP AES-128",
	23002: "SecureZIP AES-192",
	23003: "SecureZIP AES-256",
	23100: "Apple Keychain",
	23200: "XMPP SCRAM PBKDF2-SHA1",
	23300: "Apple iWork",
	23400: "Bitwarden",
	23500: "AxCrypt 2 AES-128",
	23600: "AxCrypt 2 AES-256",
	23700: "RAR3-p (Uncompressed)",
	23800: "RAR3-p (Compressed)",
	23900: "BestCrypt v3 Volume Encryption",
	24100: "MongoDB ServerKey SCRAM-SHA-1",
	24200: "MongoDB ServerKey SCRAM-SHA-256",
	24300: "sha1($salt.sha1($pass.$salt))",
	24410: "PKCS#8 Private Keys (PBKDF2-HMAC-SHA1 + 3DES/AES)",
	24420: "PKCS#8 Private Keys (PBKDF2-HMAC-SHA256 + 3DES/AES)",
	24500: "Telegram Desktop >= v2.1.14 (PBKDF2-HMAC-SHA512)",
	24600: "SQLCipher",
	24700: "Stuffit5",
	24800: "Umbraco HMAC-SHA1",
	24900: "Dahua Authentication MD5",
	25300: "MS Office 2016 - SheetProtection",
	25400: "PDF 1.4 - 1.6 (Acrobat 5 - 8) - edit password",
	25500: "Stargazer Stellar Wallet XLM",
	25600: "bcrypt(md5($pass)) / bcryptmd5",
	25700: "MurmurHash",
	25800: "bcrypt(sha1($pass)) / bcryptsha1",
	25900: "KNX IP Secure - Device Authentication Code",
	26000: "Mozilla key3.db",
	26100: "Mozilla key4.db",
	26200: "OpenEdge Progress Encode",
	26300: "FortiGate256 (FortiOS256)",
	26401: "AES-128-ECB NOKDF (PT = $salt, key = $pass)",
	26402: "AES-192-ECB NOKDF (PT = $salt, key = $pass)",
	26403: "AES-256-ECB NOKDF (PT = $salt, key = $pass)",
	26500: "iPhone passcode (UID key + System Keybag)",
	26600: "MetaMask Wallet",
	99999: "Plaintext",
}

func hashcatHashTypeName(mode int32) (string, bool) {
	name, ok := hashcatHashTypes[mode]
	return name, ok
}

func humanizeHashRate(rate uint64) string {
	const unit = 1000
	if rate < unit {
		return fmt.Sprintf("%d H/s", rate)
	}
	value := float64(rate)
	exp := 0
	for value >= unit && exp < 5 {
		value /= unit
		exp++
	}
	suffixes := []string{"kH/s", "MH/s", "GH/s", "TH/s", "PH/s"}
	if exp == 0 {
		return fmt.Sprintf("%d H/s", rate)
	}
	if exp > len(suffixes) {
		exp = len(suffixes)
	}
	return fmt.Sprintf("%.2f %s", value, suffixes[exp-1])
}
