from typing import Dict, List

mitre_d3fend_version: str = "0.16.0"
mitre_d3fend_tactics: Dict[str, str] = {
    "Deceive": "Deceive",
    "Isolate": "Isolate",
    "Detect": "Detect",
    "Restore": "Restore",
    "Evict": "Evict",
    "Harden": "Harden",
    "Model": "Model",
}
mitre_d3fend_techniques: Dict[str, str] = {
    "D3-OAM": "Operational Activity Mapping",
    "D3-OM": "Organization Mapping",
    "D3-ORA": "Operational Risk Assessment",
    "D3-ODM": "Operational Dependency Mapping",
    "D3-AM": "Access Modeling",
    "D3-NM": "Network Mapping",
    "D3-PLM": "Physical Link Mapping",
    "D3-DPLM": "Direct Physical Link Mapping",
    "D3-APLM": "Active Physical Link Mapping",
    "D3-NVA": "Network Vulnerability Assessment",
    "D3-NTPM": "Network Traffic Policy Mapping",
    "D3-LLM": "Logical Link Mapping",
    "D3-PLLM": "Passive Logical Link Mapping",
    "D3-ALLM": "Active Logical Link Mapping",
    "D3-AI": "Asset Inventory",
    "D3-SWI": "Software Inventory",
    "D3-NNI": "Network Node Inventory",
    "D3-HCI": "Hardware Component Inventory",
    "D3-DI": "Data Inventory",
    "D3-CI": "Configuration Inventory",
    "D3-AVE": "Asset Vulnerability Enumeration",
    "D3-CIA": "Container Image Analysis",
    "D3-SYSM": "System Mapping",
    "D3-SYSVA": "System Vulnerability Assessment",
    "D3-SYSDM": "System Dependency Mapping",
    "D3-SVCDM": "Service Dependency Mapping",
    "D3-DEM": "Data Exchange Mapping",
    "D3-MH": "Message Hardening",
    "D3-TAAN": "Transfer Agent Authentication",
    "D3-MENCR": "Message Encryption",
    "D3-MAN": "Message Authentication",
    "D3-CH": "Credential Hardening",
    "D3-CTS": "Credential Transmission Scoping",
    "D3-UAP": "User Account Permissions",
    "D3-CBAN": "Certificate-based Authentication",
    "D3-CP": "Certificate Pinning",
    "D3-DTP": "Domain Trust Policy",
    "D3-BAN": "Biometric Authentication",
    "D3-OTP": "One-time Password",
    "D3-SPP": "Strong Password Policy",
    "D3-CRO": "Credential Rotation",
    "D3-MFA": "Multi-factor Authentication",
    "D3-PH": "Platform Hardening",
    "D3-DENCR": "Disk Encryption",
    "D3-TBI": "TPM Boot Integrity",
    "D3-RFS": "RF Shielding",
    "D3-BA": "Bootloader Authentication",
    "D3-SCP": "System Configuration Permissions",
    "D3-FE": "File Encryption",
    "D3-SU": "Software Update",
    "D3-DLIC": "Driver Load Integrity Checking",
    "D3-LFP": "Local File Permissions",
    "D3-AH": "Application Hardening",
    "D3-SFCV": "Stack Frame Canary Validation",
    "D3-SAOR": "Segment Address Offset Randomization",
    "D3-PSEP": "Process Segment Execution Prevention",
    "D3-PAN": "Pointer Authentication",
    "D3-EHPV": "Exception Handler Pointer Validation",
    "D3-DCE": "Dead Code Elimination",
    "D3-ACH": "Application Configuration Hardening",
    "D3-NTA": "Network Traffic Analysis",
    "D3-RTA": "RPC Traffic Analysis",
    "D3-IPCTA": "IPC Traffic Analysis",
    "D3-RTSD": "Remote Terminal Session Detection",
    "D3-RPA": "Relay Pattern Analysis",
    "D3-PMAD": "Protocol Metadata Anomaly Detection",
    "D3-PHDURA": "Per Host Download-Upload Ratio Analysis",
    "D3-DNSTA": "DNS Traffic Analysis",
    "D3-FC": "File Carving",
    "D3-ISVA": "Inbound Session Volume Analysis",
    "D3-NTCD": "Network Traffic Community Deviation",
    "D3-CSPP": "Client-server Payload Profiling",
    "D3-ANAA": "Administrative Network Activity Analysis",
    "D3-CAA": "Connection Attempt Analysis",
    "D3-NTSA": "Network Traffic Signature Analysis",
    "D3-BSE": "Byte Sequence Emulation",
    "D3-CA": "Certificate Analysis",
    "D3-PCA": "Passive Certificate Analysis",
    "D3-ACA": "Active Certificate Analysis",
    "D3-MA": "Message Analysis",
    "D3-SRA": "Sender Reputation Analysis",
    "D3-SMRA": "Sender MTA Reputation Analysis",
    "D3-PA": "Process Analysis",
    "D3-FAPA": "File Access Pattern Analysis",
    "D3-DQSA": "Database Query String Analysis",
    "D3-SSC": "Shadow Stack Comparisons",
    "D3-SEA": "Script Execution Analysis",
    "D3-PSA": "Process Spawn Analysis",
    "D3-PLA": "Process Lineage Analysis",
    "D3-IBCA": "Indirect Branch Call Analysis",
    "D3-SCA": "System Call Analysis",
    "D3-FCA": "File Creation Analysis",
    "D3-PSMD": "Process Self-Modification Detection",
    "D3-PCSV": "Process Code Segment Verification",
    "D3-FA": "File Analysis",
    "D3-FH": "File Hashing",
    "D3-FCOA": "File Content Analysis",
    "D3-FCR": "File Content Rules",
    "D3-EFA": "Emulated File Analysis",
    "D3-DA": "Dynamic Analysis",
    "D3-UBA": "User Behavior Analysis",
    "D3-DAM": "Domain Account Monitoring",
    "D3-SDA": "Session Duration Analysis",
    "D3-UGLPA": "User Geolocation Logon Pattern Analysis",
    "D3-WSAA": "Web Session Activity Analysis",
    "D3-JFAPA": "Job Function Access Pattern Analysis",
    "D3-CCSA": "Credential Compromise Scope Analysis",
    "D3-AZET": "Authorization Event Thresholding",
    "D3-ANET": "Authentication Event Thresholding",
    "D3-RAPA": "Resource Access Pattern Analysis",
    "D3-LAM": "Local Account Monitoring",
    "D3-UDTA": "User Data Transfer Analysis",
    "D3-ID": "Identifier Analysis",
    "D3-UA": "URL Analysis",
    "D3-IRA": "Identifier Reputation Analysis",
    "D3-URA": "URL Reputation Analysis",
    "D3-IPRA": "IP Reputation Analysis",
    "D3-FHRA": "File Hash Reputation Analysis",
    "D3-DNRA": "Domain Name Reputation Analysis",
    "D3-IAA": "Identifier Activity Analysis",
    "D3-HD": "Homoglyph Detection",
    "D3-PM": "Platform Monitoring",
    "D3-OSM": "Operating System Monitoring",
    "D3-USICA": "User Session Init Config Analysis",
    "D3-SICA": "System Init Config Analysis",
    "D3-SFA": "System File Analysis",
    "D3-SBV": "Service Binary Verification",
    "D3-SDM": "System Daemon Monitoring",
    "D3-SJA": "Scheduled Job Analysis",
    "D3-MBT": "Memory Boundary Tracking",
    "D3-IDA": "Input Device Analysis",
    "D3-EHB": "Endpoint Health Beacon",
    "D3-FV": "Firmware Verification",
    "D3-SFV": "System Firmware Verification",
    "D3-PFV": "Peripheral Firmware Verification",
    "D3-FEMC": "Firmware Embedded Monitoring Code",
    "D3-FBA": "Firmware Behavior Analysis",
    "D3-FIM": "File Integrity Monitoring",
    "D3-EI": "Execution Isolation",
    "D3-KBPI": "Kernel-based Process Isolation",
    "D3-SCF": "System Call Filtering",
    "D3-MAC": "Mandatory Access Control",
    "D3-IOPR": "IO Port Restriction",
    "D3-HBPI": "Hardware-based Process Isolation",
    "D3-EDL": "Executable Denylisting",
    "D3-EAL": "Executable Allowlisting",
    "D3-NI": "Network Isolation",
    "D3-NTF": "Network Traffic Filtering",
    "D3-OTF": "Outbound Traffic Filtering",
    "D3-ITF": "Inbound Traffic Filtering",
    "D3-EF": "Email Filtering",
    "D3-ET": "Encrypted Tunnels",
    "D3-DNSDL": "DNS Denylisting",
    "D3-RRID": "Reverse Resolution IP Denylisting",
    "D3-FRIDL": "Forward Resolution IP Denylisting",
    "D3-FRDDL": "Forward Resolution Domain Denylisting",
    "D3-HDL": "Homoglyph Denylisting",
    "D3-HDDL": "Hierarchical Domain Denylisting",
    "D3-DNSAL": "DNS Allowlisting",
    "D3-BDI": "Broadcast Domain Isolation",
    "D3-DO": "Decoy Object",
    "D3-DUC": "Decoy User Credential",
    "D3-DST": "Decoy Session Token",
    "D3-DPR": "Decoy Public Release",
    "D3-DP": "Decoy Persona",
    "D3-DNR": "Decoy Network Resource",
    "D3-DF": "Decoy File",
    "D3-DE": "Decoy Environment",
    "D3-SHN": "Standalone Honeynet",
    "D3-IHN": "Integrated Honeynet",
    "D3-CHN": "Connected Honeynet",
    "D3-PE": "Process Eviction",
    "D3-PT": "Process Termination",
    "D3-PS": "Process Suspension",
    "D3-HS": "Host Shutdown",
    "D3-HR": "Host Reboot",
    "D3-FEV": "File Eviction",
    "D3-FR": "File Removal",
    "D3-ER": "Email Removal",
    "D3-CE": "Credential Eviction",
    "D3-CR": "Credential Revoking",
    "D3-ANCI": "Authentication Cache Invalidation",
    "D3-AL": "Account Locking",
}
mitre_d3fend_artifacts: Dict[str, str] = {
    "d3f-AccessControlConfiguration": "Access Control Configuration",
    "d3f-AccessControlGroup": "Access Control Group",
    "d3f-AccessControlList": "Access Control List",
    "d3f-AccessMediator": "Access Mediator",
    "d3f-AccessProcess": "Access Process",
    "d3f-AccessToken": "Access Token",
    "d3f-ActivityDependency": "Activity Dependency",
    "d3f-AddressSpace": "Address Space",
    "d3f-AdministrativeNetworkTraffic": "Administrative Network Traffic",
    "d3f-Alias": "Alias",
    "d3f-AllocateMemory": "Allocate Memory",
    "d3f-Application": "Application",
    "d3f-ApplicationConfiguration": "Application Configuration",
    "d3f-ApplicationConfigurationDatabase": "Application Configuration Database",
    "d3f-ApplicationConfigurationDatabaseRecord": "Application Configuration Database Record",
    "d3f-ApplicationConfigurationFile": "Application Configuration File",
    "d3f-ApplicationInstaller": "Application Installer",
    "d3f-ApplicationInventorySensor": "Application Inventory Sensor",
    "d3f-ApplicationLayerFirewall": "Application Layer Firewall",
    "d3f-ApplicationLayerLink": "Application Layer Link",
    "d3f-ApplicationProcess": "Application Process",
    "d3f-ApplicationProcessConfiguration": "Application Process Configuration",
    "d3f-ApplicationRule": "Application Rule",
    "d3f-ApplicationShim": "Application Shim",
    "d3f-ArchiveFile": "Archive File",
    "d3f-ArtifactServer": "Artifact Server",
    "d3f-AsymmetricKey": "Asymmetric Key",
    "d3f-AudioInputDevice": "Audio Input Device",
    "d3f-AuthenticateUser": "Authenticate User",
    "d3f-Authentication": "Authentication",
    "d3f-AuthenticationFunction": "Authentication Function",
    "d3f-AuthenticationLog": "Authentication Log",
    "d3f-AuthenticationServer": "Authentication Server",
    "d3f-AuthenticationService": "Authentication Service",
    "d3f-Authorization": "Authorization",
    "d3f-AuthorizationLog": "Authorization Log",
    "d3f-AuthorizationService": "Authorization Service",
    "d3f-BarcodeScannerInputDevice": "Barcode Scanner Input Device",
    "d3f-BinaryLargeObject": "Binary Large Object",
    "d3f-BinarySegment": "Binary Segment",
    "d3f-BlockDevice": "Block Device",
    "d3f-BootLoader": "Boot Loader",
    "d3f-BootRecord": "Boot Record",
    "d3f-BootSector": "Boot Sector",
    "d3f-Browser": "Browser",
    "d3f-BrowserExtension": "Browser Extension",
    "d3f-BuildTool": "Build Tool",
    "d3f-BusinessCommunicationPlatformClient": "Business Communication Platform Client",
    "d3f-CACertificateFile": "CA Certificate File",
    "d3f-CacheMemory": "Processor Cache Memory",
    "d3f-CallStack": "Call Stack",
    "d3f-CentralProcessingUnit": "Central Processing Unit",
    "d3f-Certificate": "Certificate",
    "d3f-CertificateFile": "Certificate File",
    "d3f-CertificateTrustStore": "Certificate Trust Store",
    "d3f-ChatroomClient": "Chatroom Client",
    "d3f-ChildProcess": "Child Process",
    "d3f-ClientApplication": "Client Application",
    "d3f-ClientComputer": "Client Computer",
    "d3f-Clipboard": "Clipboard",
    "d3f-CloudConfiguration": "Cloud Configuration",
    "d3f-CloudInstanceMetadata": "Cloud Instance Metadata",
    "d3f-CloudServiceAuthentication": "Cloud Service Authentication",
    "d3f-CloudServiceAuthorization": "Cloud Service Authorization",
    "d3f-CloudServiceSensor": "Cloud Service Sensor",
    "d3f-CloudStorage": "Cloud Storage",
    "d3f-CloudUserAccount": "Cloud User Account",
    "d3f-CodeAnalyzer": "Code Analyzer",
    "d3f-CodeRepository": "Code Repository",
    "d3f-CollaborativeSoftware": "Collaborative Software",
    "d3f-CollectorAgent": "Network Agent",
    "d3f-Command": "Command",
    "d3f-CommandHistoryLog": "Command History Log",
    "d3f-CommandHistoryLogFile": "Command History Log File",
    "d3f-CommandLineInterface": "Command Line Interface",
    "d3f-Compiler": "Compiler",
    "d3f-CompilerConfigurationFile": "Compiler Configuration File",
    "d3f-ComputingServer": "Computing Server",
    "d3f-ConfigurationDatabase": "Configuration Database",
    "d3f-ConfigurationDatabaseRecord": "Configuration Database Record",
    "d3f-ConfigurationFile": "Configuration File",
    "d3f-ConfigurationManagementDatabase": "Configuration Management Database",
    "d3f-ConfigurationResource": "Configuration Resource",
    "d3f-ConnectSocket": "Connect Socket",
    "d3f-ConsoleOutputFunction": "Console Output Function",
    "d3f-ContainerBuildTool": "Container Build Tool",
    "d3f-ContainerImage": "Container Image",
    "d3f-ContainerOrchestrationSoftware": "Container Orchestration Software",
    "d3f-ContainerProcess": "Container Process",
    "d3f-ContainerRuntime": "Container Runtime",
    "d3f-CopyMemoryFunction": "Copy Memory Function",
    "d3f-CopyToken": "Copy Token",
    "d3f-CreateFile": "Create File",
    "d3f-CreateProcess": "Create Process",
    "d3f-CreateSocket": "Create Socket",
    "d3f-CreateThread": "Create Thread",
    "d3f-Credential": "Credential",
    "d3f-CredentialManagementSystem": "Credential Management System",
    "d3f-CryptographicKey": "Cryptographic Key",
    "d3f-CustomArchiveFile": "Custom Archive File",
    "d3f-CyberSensor": "Cyber Sensor",
    "d3f-DHCPNetworkTraffic": "DHCP Network Traffic",
    "d3f-DHCPServer": "DHCP Server",
    "d3f-DNSLookup": "DNS Lookup",
    "d3f-DNSNetworkTraffic": "DNS Network Traffic",
    "d3f-DNSRecord": "DNS Record",
    "d3f-DNSServer": "DNS Server",
    "d3f-DataArtifactServer": "Data Artifact Server",
    "d3f-DataDependency": "Data Dependency",
    "d3f-DataLinkLink": "Data Link Link",
    "d3f-Database": "Database",
    "d3f-DatabaseFile": "Database File",
    "d3f-DatabaseQuery": "Database Query",
    "d3f-DatabaseServer": "Database Server",
    "d3f-DecoyArtifact": "Decoy Artifact",
    "d3f-DefaultUserAccount": "Default User Account",
    "d3f-DeleteFile": "Delete File",
    "d3f-Dependency": "Dependency",
    "d3f-DeserializationFunction": "Deserialization Function",
    "d3f-DesktopComputer": "Desktop Computer",
    "d3f-DeveloperApplication": "Developer Application",
    "d3f-DialUpModem": "Dial Up Modem",
    "d3f-DigitalArtifact": "Digital Artifact",
    "d3f-DigitalFingerprint": "Digital Fingerprint",
    "d3f-DigitalInformation": "Digital Information",
    "d3f-DigitalInformationBearer": "Digital Information Bearer",
    "d3f-DigitalSystem": "Digital System",
    "d3f-Directory": "Directory",
    "d3f-DirectoryService": "Directory Service",
    "d3f-DisplayAdapter": "Display Adapter",
    "d3f-DisplayDeviceDriver": "Display Device Driver",
    "d3f-DisplayServer": "Display Server",
    "d3f-DocumentFile": "Document File",
    "d3f-DomainName": "Domain Name",
    "d3f-DomainRegistration": "Domain Registration",
    "d3f-DomainUserAccount": "Domain User Account",
    "d3f-DynamicAnalysisTool": "Dynamic Analysis Tool",
    "d3f-Email": "Email",
    "d3f-EmailAttachment": "Email Attachment",
    "d3f-EmailRule": "Email Rule",
    "d3f-EmbeddedComputer": "Embedded Computer",
    "d3f-Enclave": "Enclave",
    "d3f-EncryptedCredential": "Encrypted Credential",
    "d3f-EncryptedPassword": "Encrypted Password",
    "d3f-EndpointSensor": "Endpoint Sensor",
    "d3f-EvalFunction": "Eval Function",
    "d3f-EventLog": "Event Log",
    "d3f-ExceptionHandler": "Exception Handler",
    "d3f-Exec": "Exec",
    "d3f-ExecutableBinary": "Executable Binary",
    "d3f-ExecutableFile": "Executable File",
    "d3f-ExecutableScript": "Executable Script",
    "d3f-ExternalContentInclusionFunction": "External Content Inclusion Function",
    "d3f-FastSymbolicLink": "Fast Symbolic Link",
    "d3f-File": "File",
    "d3f-FileHash": "File Hash",
    "d3f-FilePathOpenFunction": "File Path Open Function",
    "d3f-FileSection": "File Section",
    "d3f-FileServer": "File Server",
    "d3f-FileShareService": "File Share Service",
    "d3f-FileSystem": "File System",
    "d3f-FileSystemLink": "File System Link",
    "d3f-FileSystemMetadata": "File System Metadata",
    "d3f-FileSystemSensor": "File System Sensor",
    "d3f-FileTransferNetworkTraffic": "File Transfer Network Traffic",
    "d3f-FingerPrintScannerInputDevice": "Finger Print Scanner Input Device",
    "d3f-Firewall": "Firewall",
    "d3f-Firmware": "Firmware",
    "d3f-FirmwareSensor": "Firmware Sensor",
    "d3f-First-stageBootLoader": "First-stage Boot Loader",
    "d3f-FlashMemory": "Flash Memory",
    "d3f-ForwardProxyServer": "Forward Proxy Server",
    "d3f-FreeMemory": "Free Memory",
    "d3f-GetOpenSockets": "Get Open Sockets",
    "d3f-GetOpenWindows": "Get Open Windows",
    "d3f-GetRunningProcesses": "Get Running Processes",
    "d3f-GetScreenCapture": "Get Screen Capture",
    "d3f-GetSystemConfigValue": "Get System Config Value",
    "d3f-GetSystemNetworkConfigValue": "Get System Network Config Value",
    "d3f-GetSystemTime": "Get System Time",
    "d3f-GetThreadContext": "Get Thread Context",
    "d3f-GlobalUserAccount": "Global User Account",
    "d3f-GraphicalUserInterface": "Graphical User Interface",
    "d3f-GraphicsCardFirmware": "Graphics Card Firmware",
    "d3f-GraphicsProcessingUnit": "Graphics Processing Unit",
    "d3f-GroupPolicy": "Group Policy",
    "d3f-HTMLFile": "HTML File",
    "d3f-HardDiskFirmware": "Hard Disk Firmware",
    "d3f-HardLink": "Hard Link",
    "d3f-HardwareDevice": "Hardware Device",
    "d3f-HardwareDriver": "Hardware Driver",
    "d3f-HeapSegment": "Heap Segment",
    "d3f-Host": "Host",
    "d3f-Host-basedFirewall": "Host-based Firewall",
    "d3f-HostConfigurationSensor": "Host Configuration Sensor",
    "d3f-HostGroup": "Host Group",
    "d3f-Hostname": "Hostname",
    "d3f-HumanInputDeviceFirmware": "Human Input Device Firmware",
    "d3f-IPAddress": "IP Address",
    "d3f-IPCNetworkTraffic": "IPC Network Traffic",
    "d3f-IPPhone": "IP Phone",
    "d3f-Identifier": "Identifier",
    "d3f-ImageCodeSegment": "Image Code Segment",
    "d3f-ImageDataSegment": "Image Data Segment",
    "d3f-ImageScannerInputDevice": "Image Scanner Input Device",
    "d3f-ImageSegment": "Image Segment",
    "d3f-ImpersonateUser": "Impersonate User",
    "d3f-ImportLibraryFunction": "Import Library Function",
    "d3f-In-memoryPasswordStore": "In-memory Password Store",
    "d3f-InboundInternetDNSResponseTraffic": "Inbound Internet DNS Response Traffic",
    "d3f-InboundInternetMailTraffic": "Inbound Internet Mail Traffic",
    "d3f-InboundInternetNetworkTraffic": "Inbound Internet Network Traffic",
    "d3f-InboundNetworkTraffic": "Inbound Network Traffic",
    "d3f-InitScript": "Init Script",
    "d3f-InputDevice": "Input Device",
    "d3f-InputFunction": "Input Function",
    "d3f-InstantMessagingClient": "Instant Messaging Client",
    "d3f-IntegrationTestExecutionTool": "Integration Test Execution Tool",
    "d3f-InternetDNSLookup": "Internet DNS Lookup",
    "d3f-InternetFileTransferTraffic": "Internet File Transfer Traffic",
    "d3f-InternetNetwork": "Internet Network",
    "d3f-InternetNetworkTraffic": "Internet Network Traffic",
    "d3f-InterprocessCommunication": "Interprocess Communication",
    "d3f-IntranetAdministrativeNetworkTraffic": "Intranet Administrative Network Traffic",
    "d3f-IntranetDNSLookup": "Intranet DNS Lookup",
    "d3f-IntranetFileTransferTraffic": "Intranet File Transfer Traffic",
    "d3f-IntranetIPCNetworkTraffic": "Intranet IPC Network Traffic",
    "d3f-IntranetMulticastNetworkTraffic": "Intranet Multicast Network Traffic",
    "d3f-IntranetNetwork": "Intranet Network",
    "d3f-IntranetNetworkTraffic": "Intranet Network Traffic",
    "d3f-IntranetRPCNetworkTraffic": "Intranet RPC Network Traffic",
    "d3f-IntranetWebNetworkTraffic": "Intranet Web Network Traffic",
    "d3f-IntrusionDetectionSystem": "Intrusion Detection System",
    "d3f-IntrusionPreventionSystem": "Intrusion Prevention System",
    "d3f-JavaArchive": "Java Archive",
    "d3f-JavaScriptBlob": "JavaScript Blob",
    "d3f-JobSchedule": "Job Schedule",
    "d3f-JobSchedulerSoftware": "Job Scheduler Software",
    "d3f-KerberosTicket": "Kerberos Ticket",
    "d3f-KerberosTicketGrantingServiceTicket": "Kerberos Ticket Granting Service Ticket",
    "d3f-KerberosTicketGrantingTicket": "Kerberos Ticket Granting Ticket",
    "d3f-Kernel": "Kernel",
    "d3f-KernelAPISensor": "Kernel API Sensor",
    "d3f-KernelModule": "Kernel Module",
    "d3f-KernelProcessTable": "Kernel Process Table",
    "d3f-KeyboardInputDevice": "Keyboard Input Device",
    "d3f-KioskComputer": "Kiosk Computer",
    "d3f-LaptopComputer": "Laptop Computer",
    "d3f-LegacySystem": "Legacy System",
    "d3f-Link": "Link",
    "d3f-LinuxClone": "Linux Clone",
    "d3f-LinuxClone3": "Linux Clone3",
    "d3f-LinuxClone3ArgumentCLONE_THREAD": "Linux Clone3 Argument CLONE_THREAD",
    "d3f-LinuxCloneArgumentCLONE_THREAD": "Linux Clone Argument CLONE_THREAD",
    "d3f-LinuxConnect": "Linux Connect",
    "d3f-LinuxCreat": "Linux Creat",
    "d3f-LinuxDeleteModule": "Linux Delete Module",
    "d3f-LinuxExecve": "Linux Execve",
    "d3f-LinuxExecveat": "Linux Execveat",
    "d3f-LinuxFork": "Linux Fork",
    "d3f-LinuxInitModule": "Linux Init Module",
    "d3f-LinuxKillArgumentSIGKILL": "Linux Kill Argument SIGKILL",
    "d3f-LinuxMmap": "Linux Mmap",
    "d3f-LinuxMmap2": "Linux Mmap2",
    "d3f-LinuxMunmap": "Linux Munmap",
    "d3f-LinuxOpenArgumentO_CREAT": "Linux Open Argument O_CREAT",
    "d3f-LinuxOpenArgumentO_RDONLY-O_WRONLY-O_RDWR": "Linux Open Argument O_RDONLY, O_WRONLY, O_RDWR",
    "d3f-LinuxOpenAt2ArgumentO_CREAT": "Linux OpenAt2 Argument O_CREAT",
    "d3f-LinuxOpenAt2ArgumentO_RDONLY-O_WRONLY-O_RDWR": "Linux OpenAt2 Argument O_RDONLY, O_WRONLY, O_RDWR",
    "d3f-LinuxOpenAtArgumentO_CREAT": "Linux OpenAt Argument O_CREAT",
    "d3f-LinuxOpenAtArgumentO_RDONLY-O_WRONLY-O_RDWR": "Linux OpenAt Argument O_RDONLY, O_WRONLY, O_RDWR",
    "d3f-LinuxPauseProcess": "Linux Pause Process",
    "d3f-LinuxPauseThread": "Linux Pause Thread",
    "d3f-LinuxPtraceArgumentPTRACEATTACH": "Linux Ptrace Argument PTRACE_ATTACH",
    "d3f-LinuxPtraceArgumentPTRACECONT": "Linux Ptrace Argument PTRACE_CONT",
    "d3f-LinuxPtraceArgumentPTRACEGETREGS": "Linux Ptrace Argument PTRACE_GETREGS",
    "d3f-LinuxPtraceArgumentPTRACEINTERRUPT": "Linux Ptrace Argument PTRACE_INTERRUPT",
    "d3f-LinuxPtraceArgumentPTRACEPEEKTEXT": "Linux Ptrace Argument PTRACE_PEEKTEXT",
    "d3f-LinuxPtraceArgumentPTRACEPOKETEXT": "Linux Ptrace Argument PTRACE_POKETEXT",
    "d3f-LinuxPtraceArgumentPTRACESETREGS": "Linux Ptrace Argument PTRACE_SETREGS",
    "d3f-LinuxPtraceArgumentPTRACE_DETACH": "Linux Ptrace Argument PTRACE_DETACH",
    "d3f-LinuxPtraceArgumentPTRACE_TRACEME": "Linux Ptrace Argument PTRACE_TRACEME",
    "d3f-LinuxRead": "Linux Read",
    "d3f-LinuxReadv": "Linux Readv",
    "d3f-LinuxRename": "Linux Rename",
    "d3f-LinuxRenameat": "Linux Renameat",
    "d3f-LinuxRenameat2": "Linux Renameat2",
    "d3f-LinuxSocket": "Linux Socket",
    "d3f-LinuxSocketcallArgumentSYS_CONNECT": "Linux Socketcall Argument SYS_CONNECT",
    "d3f-LinuxSocketcallArgumentSYS_SOCKET": "Linux Socketcall Argument SYS_SOCKET",
    "d3f-LinuxTime": "Linux Time",
    "d3f-LinuxUnlink": "Linux Unlink",
    "d3f-LinuxUnlinkat": "Linux Unlinkat",
    "d3f-LinuxVfork": "Linux Vfork",
    "d3f-LinuxWrite": "Linux Write",
    "d3f-LinuxWritev": "Linux Writev",
    "d3f-Linux_Exit": "Linux _Exit",
    "d3f-LocalAreaNetwork": "Local Area Network",
    "d3f-LocalAreaNetworkTraffic": "Local Area Network Traffic",
    "d3f-LocalAuthenticationService": "Local Authentication Service",
    "d3f-LocalAuthorizationService": "Local Authorization Service",
    "d3f-LocalResource": "Local Resource",
    "d3f-LocalResourceAccess": "Local Resource Access",
    "d3f-LocalUserAccount": "Local User Account",
    "d3f-Log": "Log",
    "d3f-LogFile": "Log File",
    "d3f-LogMessageFunction": "Log Message Function",
    "d3f-LogicalLink": "Logical Link",
    "d3f-LoginSession": "Login Session",
    "d3f-LogonUser": "Logon User",
    "d3f-MacOSKeychain": "MacOS Keychain",
    "d3f-MailNetworkTraffic": "Mail Network Traffic",
    "d3f-MailServer": "Mail Server",
    "d3f-MailService": "Mail Service",
    "d3f-MathematicalFunction": "Mathematical Function",
    "d3f-MediaServer": "Media Server",
    "d3f-MemoryAddress": "Memory Address",
    "d3f-MemoryAddressSpace": "Memory Address Space",
    "d3f-MemoryAllocationFunction": "Memory Allocation Function",
    "d3f-MemoryBlock": "Memory Block",
    "d3f-MemoryExtent": "Memory Extent",
    "d3f-MemoryFreeFunction": "Memory Free Function",
    "d3f-MemoryManagementUnit": "Memory Management Unit",
    "d3f-MemoryManagementUnitComponent": "Memory Management Unit Component",
    "d3f-MemoryPool": "Memory Pool",
    "d3f-MemoryProtectionUnit": "Memory Protection Unit",
    "d3f-MemoryWord": "Memory Word",
    "d3f-MessageTransferAgent": "Message Transfer Agent",
    "d3f-Metadata": "Metadata",
    "d3f-Microcode": "Microcode",
    "d3f-MicrosoftHTMLApplication": "Microsoft HTML Application",
    "d3f-MobilePhone": "Mobile Phone",
    "d3f-Modem": "Modem",
    "d3f-MouseInputDevice": "Mouse Input Device",
    "d3f-MoveFile": "Move File",
    "d3f-MultimediaDocumentFile": "Multimedia Document File",
    "d3f-NTFSHardLink": "NTFS Hard Link",
    "d3f-NTFSJunctionPoint": "NTFS Junction Point",
    "d3f-NTFSLink": "NTFS Link",
    "d3f-NTFSSymbolicLink": "NTFS Symbolic Link",
    "d3f-Network": "Network",
    "d3f-NetworkCardFirmware": "Network Card Firmware",
    "d3f-NetworkDirectoryResource": "Network Directory Resource",
    "d3f-NetworkFileResource": "Network File Resource",
    "d3f-NetworkFileShareResource": "Network File Share Resource",
    "d3f-NetworkFlow": "Network Flow",
    "d3f-NetworkFlowSensor": "Network Flow Sensor",
    "d3f-NetworkInitScriptFileResource": "Network Init Script File Resource",
    "d3f-NetworkLink": "Network Link",
    "d3f-NetworkNode": "Network Node",
    "d3f-NetworkPackets": "Network Packet",
    "d3f-NetworkPrinter": "Network Printer",
    "d3f-NetworkProtocolAnalyzer": "Network Protocol Analyzer",
    "d3f-NetworkResource": "Network Resource",
    "d3f-NetworkResourceAccess": "Network Resource Access",
    "d3f-NetworkSensor": "Network Sensor",
    "d3f-NetworkService": "Network Service",
    "d3f-NetworkSession": "Network Session",
    "d3f-NetworkTimeServer": "Network Time Server",
    "d3f-NetworkTraffic": "Network Traffic",
    "d3f-NetworkTrafficAnalysisSoftware": "Network Traffic Analysis Software",
    "d3f-OSAPIAccessProcess": "OS API Access Process",
    "d3f-OSAPIAllocateMemory": "OS API Allocate Memory",
    "d3f-OSAPIConnectSocket": "OS API Connect Socket",
    "d3f-OSAPICopyToken": "OS API Copy Token",
    "d3f-OSAPICreateFile": "OS API Create File",
    "d3f-OSAPICreateProcess": "OS API Create Process",
    "d3f-OSAPICreateSocket": "OS API Create Socket",
    "d3f-OSAPICreateThread": "OS API Create Thread",
    "d3f-OSAPIDeleteFile": "OS API Delete File",
    "d3f-OSAPIExec": "OS API Exec",
    "d3f-OSAPIFreeMemory": "OS API Free Memory",
    "d3f-OSAPIFunction": "OS API Function",
    "d3f-OSAPIGetSystemTime": "OS API Get System Time",
    "d3f-OSAPIGetThreadContext": "OS API Get Thread Context",
    "d3f-OSAPILoadModule": "OS API Load Module",
    "d3f-OSAPIMoveFile": "OS API Move File",
    "d3f-OSAPIOpenFile": "OS API Open File",
    "d3f-OSAPIReadFile": "OS API Read File",
    "d3f-OSAPIReadMemory": "OS API Read Memory",
    "d3f-OSAPIResumeProcess": "OS API Resume Process",
    "d3f-OSAPIResumeThread": "OS API Resume Thread",
    "d3f-OSAPISaveRegisters": "OS API Save Registers",
    "d3f-OSAPISetRegisters": "OS API Set Registers",
    "d3f-OSAPISetThreadContext": "OS API Set Thread Context",
    "d3f-OSAPISuspendProcess": "OS API Suspend Process",
    "d3f-OSAPISuspendThread": "OS API Suspend Thread",
    "d3f-OSAPISystemFunction": "OS API System Function",
    "d3f-OSAPITerminateProcess": "OS API Terminate Process",
    "d3f-OSAPITraceProcess": "OS API Trace Process",
    "d3f-OSAPITraceThread": "OS API Trace Thread",
    "d3f-OSAPIUnloadModule": "OS API Unload Module",
    "d3f-OSAPIWriteFile": "OS API Write File",
    "d3f-OSAPIWriteMemory": "OS API Write Memory",
    "d3f-ObjectFile": "Object File",
    "d3f-OfficeApplication": "Office Application",
    "d3f-OfficeApplicationFile": "Office Application File",
    "d3f-OpenFile": "Open File",
    "d3f-OperatingSystem": "Operating System",
    "d3f-OperatingSystemConfiguration": "Operating System Configuration",
    "d3f-OperatingSystemConfigurationComponent": "Operating System Configuration Component",
    "d3f-OperatingSystemConfigurationFile": "Operating System Configuration File",
    "d3f-OperatingSystemExecutableFile": "Operating System Executable File",
    "d3f-OperatingSystemFile": "Operating System File",
    "d3f-OperatingSystemLogFile": "Operating System Log File",
    "d3f-OperatingSystemPackagingTool": "Operating System Packaging Tool",
    "d3f-OperatingSystemProcess": "Operating System Process",
    "d3f-OperatingSystemSharedLibraryFile": "Operating System Shared Library File",
    "d3f-OperationsCenterComputer": "Operations Center Computer",
    "d3f-OpticalModem": "Optical Modem",
    "d3f-OrchestrationController": "Orchestration Controller",
    "d3f-OrchestrationServer": "Orchestration Server",
    "d3f-OrchestrationWorker": "Orchestration Worker",
    "d3f-OutboundInternetDNSLookupTraffic": "Outbound Internet DNS Lookup Traffic",
    "d3f-OutboundInternetEncryptedRemoteTerminalTraffic": "Outbound Internet Encrypted Remote Terminal Traffic",
    "d3f-OutboundInternetEncryptedTraffic": "Outbound Internet Encrypted Traffic",
    "d3f-OutboundInternetEncryptedWebTraffic": "Outbound Internet Encrypted Web Traffic",
    "d3f-OutboundInternetFileTransferTraffic": "Outbound Internet File Transfer Traffic",
    "d3f-OutboundInternetMailTraffic": "Outbound Internet Mail Traffic",
    "d3f-OutboundInternetNetworkTraffic": "Outbound Internet Network Traffic",
    "d3f-OutboundInternetRPCTraffic": "Outbound Internet RPC Traffic",
    "d3f-OutboundInternetWebTraffic": "Outbound Internet Web Traffic",
    "d3f-OutboundNetworkTraffic": "Outbound Network Traffic",
    "d3f-OutputDevice": "Output Device",
    "d3f-POSIXSymbolicLink": "POSIX Symbolic Link",
    "d3f-PacketLog": "Packet Log",
    "d3f-Page": "Page",
    "d3f-PageFrame": "Page Frame",
    "d3f-PageTable": "Page Table",
    "d3f-ParentProcess": "Parent Process",
    "d3f-Partition": "Partition",
    "d3f-PartitionTable": "Partition Table",
    "d3f-Password": "Password",
    "d3f-PasswordDatabase": "Password Database",
    "d3f-PasswordFile": "Password File",
    "d3f-PasswordManager": "Password Manager",
    "d3f-PasswordStore": "Password Store",
    "d3f-PeripheralFirmware": "Peripheral Firmware",
    "d3f-PeripheralHubFirmware": "Peripheral Hub Firmware",
    "d3f-PersonalComputer": "Personal Computer",
    "d3f-PhysicalAddress": "Physical Address",
    "d3f-PhysicalLink": "Physical Link",
    "d3f-PhysicalLocation": "Physical Location",
    "d3f-Pipe": "Pipe",
    "d3f-Platform": "Platform",
    "d3f-Pointer": "Pointer",
    "d3f-PointerDereferencingFunction": "Pointer Dereferencing Function",
    "d3f-PowerShellProfileScript": "PowerShell Profile Script",
    "d3f-PrimaryStorage": "Primary Storage",
    "d3f-PrintServer": "Print Server",
    "d3f-PrivateKey": "Private Key",
    "d3f-PrivilegedUserAccount": "Privileged User Account",
    "d3f-Process": "Process",
    "d3f-ProcessCodeSegment": "Process Code Segment",
    "d3f-ProcessDataSegment": "Process Data Segment",
    "d3f-ProcessEnvironmentVariable": "Process Environment Variable",
    "d3f-ProcessImage": "Process Image",
    "d3f-ProcessSegment": "Process Segment",
    "d3f-ProcessStartFunction": "Process Start Function",
    "d3f-ProcessTree": "Process Tree",
    "d3f-Processor": "Processor",
    "d3f-ProcessorComponent": "Processor Component",
    "d3f-ProcessorRegister": "Processor Register",
    "d3f-PropertyListFile": "Property List File",
    "d3f-ProxyServer": "Proxy Server",
    "d3f-PublicKey": "Public Key",
    "d3f-PythonPackage": "Python Package",
    "d3f-PythonScriptFile": "Python Script File",
    "d3f-RAM": "RAM",
    "d3f-RDPSession": "RDP Session",
    "d3f-RFNode": "RF Node",
    "d3f-RFReceiver": "RF Receiver",
    "d3f-RFTransceiver": "RF Transceiver",
    "d3f-RFTransmitter": "RF Transmitter",
    "d3f-ROM": "ROM",
    "d3f-RPCNetworkTraffic": "RPC Network Traffic",
    "d3f-RadioModem": "Radio Modem",
    "d3f-RawMemoryAccessFunction": "Raw Memory Access Function",
    "d3f-ReadFile": "Read File",
    "d3f-ReadMemory": "Read Memory",
    "d3f-Record": "Record",
    "d3f-RemoteAuthenticationService": "Remote Authentication Service",
    "d3f-RemoteAuthorizationService": "Remote Authorization Service",
    "d3f-RemoteCommand": "Remote Command",
    "d3f-RemoteDatabaseQuery": "Remote Database Query",
    "d3f-RemoteProcedureCall": "Remote Procedure Call",
    "d3f-RemoteResource": "Remote Resource",
    "d3f-RemoteSession": "Remote Session",
    "d3f-RemoteTerminalSession": "Remote Terminal Session",
    "d3f-RemovableMediaDevice": "Removable Media Device",
    "d3f-Resource": "Resource",
    "d3f-ResourceAccess": "Resource Access",
    "d3f-ResourceFork": "Resource Fork",
    "d3f-ResumeProcess": "Resume Process",
    "d3f-ResumeThread": "Resume Thread",
    "d3f-ReverseProxyServer": "Reverse Proxy Server",
    "d3f-Router": "Router",
    "d3f-SSHSession": "SSH Session",
    "d3f-SaveRegister": "Save Registers",
    "d3f-SavedInstructionPointer": "Saved Instruction Pointer",
    "d3f-ScheduledJob": "Scheduled Job",
    "d3f-ScriptApplicationProcess": "Script Application Process",
    "d3f-Second-stageBootLoader": "Second-stage Boot Loader",
    "d3f-SecondaryStorage": "Secondary Storage",
    "d3f-SecurityToken": "Security Token",
    "d3f-Sensor": "Sensor",
    "d3f-SerializationFunction": "Serialization Function",
    "d3f-Server": "Server",
    "d3f-ServiceApplication": "Service Application",
    "d3f-ServiceApplicationProcess": "Service Application Process",
    "d3f-ServiceDependency": "Service Dependency",
    "d3f-Session": "Session",
    "d3f-SessionCookie": "Session Cookie",
    "d3f-SetRegisters": "Set Registers",
    "d3f-SetSystemConfigValue": "Set System Config Value",
    "d3f-SetThreadContext": "Set Thread Context",
    "d3f-ShadowStack": "Shadow Stack",
    "d3f-SharedComputer": "Shared Computer",
    "d3f-SharedLibraryFile": "Shared Library File",
    "d3f-SharedResourceAccessFunction": "Shared Resource Access Function",
    "d3f-Shim": "Shim",
    "d3f-ShimDatabase": "Shim Database",
    "d3f-ShortcutFile": "Shortcut File",
    "d3f-SlowSymbolicLink": "Slow Symbolic Link",
    "d3f-Software": "Software",
    "d3f-SoftwareArtifactServer": "Software Artifact Server",
    "d3f-SoftwareDeploymentTool": "Software Deployment Tool",
    "d3f-SoftwareLibrary": "Software Library",
    "d3f-SoftwareLibraryFile": "Software Library File",
    "d3f-SoftwarePackage": "Software Package",
    "d3f-SoftwarePackagingTool": "Software Packaging Tool",
    "d3f-SoftwarePatch": "Software Patch",
    "d3f-SourceCodeAnalyzerTool": "Source Code Analyzer Tool",
    "d3f-StackComponent": "Stack Component",
    "d3f-StackFrame": "Stack Frame",
    "d3f-StackFrameCanary": "Stack Frame Canary",
    "d3f-StackSegment": "Stack Segment",
    "d3f-StartupDirectory": "Startup Directory",
    "d3f-StaticAnalysisTool": "Static Analysis Tool",
    "d3f-Storage": "Storage",
    "d3f-StoredProcedure": "Stored Procedure",
    "d3f-StringFormatFunction": "String Format Function",
    "d3f-Subroutine": "Subroutine",
    "d3f-SuspendProcess": "Suspend Process",
    "d3f-SuspendThread": "Suspend Thread",
    "d3f-Switch": "Switch",
    "d3f-SymbolicLink": "Symbolic Link",
    "d3f-SymmetricKey": "Symmetric Key",
    "d3f-SystemCall": "System Call",
    "d3f-SystemConfigSystemCall": "System Config System Call",
    "d3f-SystemConfigurationDatabase": "System Configuration Database",
    "d3f-SystemConfigurationDatabaseRecord": "System Configuration Database Record",
    "d3f-SystemConfigurationInitDatabaseRecord": "System Configuration Init Database Record",
    "d3f-SystemConfigurationInitResource": "System Configuration Init Resource",
    "d3f-SystemDependency": "System Dependency",
    "d3f-SystemFirewallConfiguration": "System Firewall Configuration",
    "d3f-SystemFirmware": "System Firmware",
    "d3f-SystemInitConfiguration": "System Init Configuration",
    "d3f-SystemInitProcess": "System Init Process",
    "d3f-SystemInitScript": "System Init Script",
    "d3f-SystemPasswordDatabase": "System Password Database",
    "d3f-SystemServiceSoftware": "System Service Software",
    "d3f-SystemSoftware": "System Software",
    "d3f-SystemStartupDirectory": "System Startup Directory",
    "d3f-SystemTimeApplication": "System Time Application",
    "d3f-SystemUtilizationRecord": "System Utilization Record",
    "d3f-TFTPNetworkTraffic": "TFTP Network Traffic",
    "d3f-TFTPServer": "TFTP Server",
    "d3f-TabletComputer": "Tablet Computer",
    "d3f-TerminateProcess": "Terminate Process",
    "d3f-TertiaryStorage": "Tertiary Storage",
    "d3f-TestExecutionTool": "Test Execution Tool",
    "d3f-ThinClientComputer": "Thin Client Computer",
    "d3f-Thread": "Thread",
    "d3f-ThreadStartFunction": "Thread Start Function",
    "d3f-TicketGrantingTicket": "Ticket Granting Ticket",
    "d3f-TraceProcess": "Trace Process",
    "d3f-TraceThread": "Trace Thread",
    "d3f-TransducerSensor": "Transducer Sensor",
    "d3f-TranslationLookasideBuffer": "Translation Lookaside Buffer",
    "d3f-TransportLink": "Transport Link",
    "d3f-TrustStore": "Trust Store",
    "d3f-URL": "URL",
    "d3f-UnitTestExecutionTool": "Unit Test Execution Tool",
    "d3f-UnixHardLink": "Unix Hard Link",
    "d3f-UnixLink": "Unix Link",
    "d3f-User": "User",
    "d3f-UserAccount": "User Account",
    "d3f-UserAction": "User Action",
    "d3f-UserApplication": "User Application",
    "d3f-UserBehavior": "User Behavior",
    "d3f-UserGroup": "User Group",
    "d3f-UserInitConfigurationFile": "User Init Configuration File",
    "d3f-UserInitScript": "User Init Script",
    "d3f-UserInputFunction": "User Input Function",
    "d3f-UserInterface": "User Interface",
    "d3f-UserLogonInitResource": "User Logon Init Resource",
    "d3f-UserProcess": "User Process",
    "d3f-UserStartupDirectory": "User Startup Directory",
    "d3f-UserStartupScriptFile": "User Startup Script File",
    "d3f-UserToUserMessage": "User to User Message",
    "d3f-UtilitySoftware": "Utility Software",
    "d3f-VPNServer": "VPN Server",
    "d3f-VersionControlTool": "Version Control Tool",
    "d3f-VideoInputDevice": "Video Input Device",
    "d3f-VirtualAddress": "Virtual Address",
    "d3f-VirtualMemorySpace": "Virtual Memory Space",
    "d3f-VirtualizationSoftware": "Virtualization Software",
    "d3f-Volume": "Volume",
    "d3f-VolumeBootRecord": "Volume Boot Record",
    "d3f-WebAPIResource": "Web API Resource",
    "d3f-WebApplicationFirewall": "Web Application Firewall",
    "d3f-WebApplicationServer": "Web Application Server",
    "d3f-WebAuthentication": "Web Authentication",
    "d3f-WebFileResource": "Web File Resource",
    "d3f-WebNetworkTraffic": "Web Network Traffic",
    "d3f-WebResource": "Web Resource",
    "d3f-WebResourceAccess": "Web Resource Access",
    "d3f-WebScriptFile": "Web Script File",
    "d3f-WebServer": "Web Server",
    "d3f-WebServerApplication": "Web Server Application",
    "d3f-WideAreaNetwork": "Wide Area Network",
    "d3f-WindowOpenFile": "Windows OpenFile",
    "d3f-WindowsCreateFileA": "Windows CreateFileA",
    "d3f-WindowsCreateProcessA": "Windows CreateProcessA",
    "d3f-WindowsCreateRemoteThread": "Windows CreateRemoteThread",
    "d3f-WindowsCreateThread": "Windows CreateThread",
    "d3f-WindowsDeleteFile": "Windows DeleteFile",
    "d3f-WindowsDuplicateToken": "Windows DuplicateToken",
    "d3f-WindowsGetThreadContext": "Windows GetThreadContext",
    "d3f-WindowsNTGetThreadContext": "Windows NtGetThreadContext",
    "d3f-WindowsNtAllocateVirtualMemory": "Windows NtAllocateVirtualMemory",
    "d3f-WindowsNtAllocateVirtualMemoryEx": "Windows NtAllocateVirtualMemoryEx",
    "d3f-WindowsNtCreateFile": "Windows NtCreateFile",
    "d3f-WindowsNtCreateMailslotFile": "Windows NtCreateMailslotFile",
    "d3f-WindowsNtCreateNamedPipeFile": "Windows NtCreateNamedPipeFile",
    "d3f-WindowsNtCreatePagingFile": "Windows NtCreatePagingFile",
    "d3f-WindowsNtCreateProcess": "Windows NtCreateProcess",
    "d3f-WindowsNtCreateProcessEx": "Windows NtCreateProcessEx",
    "d3f-WindowsNtCreateThread": "Windows NtCreateThread",
    "d3f-WindowsNtCreateThreadEx": "Windows NtCreateThreadEx",
    "d3f-WindowsNtDeleteFile": "Windows NtDeleteFile",
    "d3f-WindowsNtDuplicateToken": "Windows NtDuplicateToken",
    "d3f-WindowsNtFlushInstructionCache": "Windows NtFlushInstructionCache",
    "d3f-WindowsNtFreeVirtualMemory": "Windows NtFreeVirtualMemory",
    "d3f-WindowsNtOpenFile": "Windows NtOpenFile",
    "d3f-WindowsNtOpenProcess": "Windows NtOpenProcess",
    "d3f-WindowsNtOpenThread": "Windows NtOpenThread",
    "d3f-WindowsNtProtectVirtualMemory": "Windows NtProtectVirtualMemory",
    "d3f-WindowsNtQuerySystemTime": "Windows NtQuerySystemTime",
    "d3f-WindowsNtReadFile": "Windows NtReadFile",
    "d3f-WindowsNtReadFileScatter": "Windows NtReadFileScatter",
    "d3f-WindowsNtResumeThread": "Windows NtResumeThread",
    "d3f-WindowsNtSetInformationFileArgumentFileDispositionInformation": "Windows NtSetInformationFile Argument FileDispositionInformation",
    "d3f-WindowsNtSetThreadContext": "Windows NtSetThreadContext",
    "d3f-WindowsNtSuspendProcess": "Windows NtSuspendProcess",
    "d3f-WindowsNtSuspendThread": "Windows NtSuspendThread",
    "d3f-WindowsNtTerminateProcess": "Windows NtTerminateProcess",
    "d3f-WindowsNtWriteFile": "Windows NtWriteFile",
    "d3f-WindowsNtWriteFileGather": "Windows NtWriteFileGather",
    "d3f-WindowsNtWriteVirtualMemory": "Windows NtWriteVirtualMemory",
    "d3f-WindowsOpenProcess": "Windows OpenProcess",
    "d3f-WindowsOpenThread": "Windows OpenThread",
    "d3f-WindowsQueryPerformanceCounter": "Windows QueryPerformanceCounter",
    "d3f-WindowsReadFile": "Windows ReadFile",
    "d3f-WindowsRegistry": "Windows Registry",
    "d3f-WindowsRegistryKey": "Windows Registry Key",
    "d3f-WindowsRegistryValue": "Windows Registry Value",
    "d3f-WindowsResumeThread": "Windows ResumeThread",
    "d3f-WindowsSetThreadContext": "Windows SetThreadContext",
    "d3f-WindowsShortcutFile": "Windows Shortcut File",
    "d3f-WindowsSuspendThread": "Windows SuspendThread",
    "d3f-WindowsTerminateProcess": "Windows TerminateProcess",
    "d3f-WindowsVirtualAllocEx": "Windows VirtualAllocEx",
    "d3f-WindowsVirtualFree": "Windows VirtualFree",
    "d3f-WindowsVirtualProtectEx": "Windows VirtualProtectEx",
    "d3f-WindowsWriteFile": "Windows WriteFile",
    "d3f-WindowsWriteProcessMemory": "Windows WriteProcessMemory",
    "d3f-WirelessAccessPoint": "Wireless Access Point",
    "d3f-WirelessRouter": "Wireless Router",
    "d3f-WriteFile": "Write File",
    "d3f-WriteMemory": "Write Memory",
    "d3f-ZeroClientComputer": "Zero Client Computer",
}
