#!/bin/sh

test_description="request generated html pages"

. /usr/share/sharness/sharness.sh


if [ "$MUNIN_TEST_CGI_ENABLED" = "1" ]; then
    GRAPH_BASE_URL=http://localhost/munin-cgi/munin-cgi-graph
else
    GRAPH_BASE_URL=http://localhost/munin
fi


get_munin_url() {
    # "--no-buffer" prevents curl errors ("(23) Failed writing body") in case of incomplete consumption (e.g. "grep -q")
    curl --silent --fail --no-buffer "http://localhost/munin/${1#/}"
}


get_graph_url() {
    curl --silent --fail --no-buffer "$GRAPH_BASE_URL/${1#/}"
}


assert_mime_type() {
    echo "$1" >expected_mime_type
    file --mime-type --brief - >received_mime_type
    test_cmp expected_mime_type received_mime_type
}


assert_http_response_content() {
    local url="$1"
    local expected_content="$2"
    get_munin_url "$url" | grep -qF "$expected_content"
}


test_expect_success "main site: mime type" '
  get_munin_url "/" | assert_mime_type "application/xhtml+xml"
'

test_expect_success "main site: dynamically generated" '
  assert_http_response_content "/" "Auto-generated by Munin"
'

test_expect_success "main site: contains node" '
  assert_http_response_content "/" "localhost.localdomain/index.html"
'

test_expect_success "assets: CSS" '
  assert_http_response_content "/static/style-new.css" "margin-top"
'

test_expect_success "node: html" '
  assert_http_response_content "/localdomain/localhost.localdomain/" "memory-day.png"
'

test_expect_success "node: graph" '
  get_graph_url "/localdomain/localhost.localdomain/memory-day.png" | assert_mime_type "image/png"
'

test_done
