/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/resource/v1"
	resourcev1 "k8s.io/client-go/applyconfigurations/resource/v1"
	gentype "k8s.io/client-go/gentype"
	typedresourcev1 "k8s.io/client-go/kubernetes/typed/resource/v1"
)

// fakeResourceSlices implements ResourceSliceInterface
type fakeResourceSlices struct {
	*gentype.FakeClientWithListAndApply[*v1.ResourceSlice, *v1.ResourceSliceList, *resourcev1.ResourceSliceApplyConfiguration]
	Fake *FakeResourceV1
}

func newFakeResourceSlices(fake *FakeResourceV1) typedresourcev1.ResourceSliceInterface {
	return &fakeResourceSlices{
		gentype.NewFakeClientWithListAndApply[*v1.ResourceSlice, *v1.ResourceSliceList, *resourcev1.ResourceSliceApplyConfiguration](
			fake.Fake,
			"",
			v1.SchemeGroupVersion.WithResource("resourceslices"),
			v1.SchemeGroupVersion.WithKind("ResourceSlice"),
			func() *v1.ResourceSlice { return &v1.ResourceSlice{} },
			func() *v1.ResourceSliceList { return &v1.ResourceSliceList{} },
			func(dst, src *v1.ResourceSliceList) { dst.ListMeta = src.ListMeta },
			func(list *v1.ResourceSliceList) []*v1.ResourceSlice { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.ResourceSliceList, items []*v1.ResourceSlice) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
