/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.util;

import com.jsql.util.I18nUtil;
import com.jsql.view.swing.dialog.DialogAbout;
import com.jsql.view.swing.text.JPlaceholder;
import com.jsql.view.swing.text.JToolTipI18n;
import com.jsql.view.swing.tree.model.NodeModelEmpty;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.text.JTextComponent;

public class I18nViewUtil {
    private static final Map<String, Set<Object>> COMPONENTS_LOCALIZED = new HashMap<String, Set<Object>>();

    private I18nViewUtil() {
    }

    public static Set<String> keys() {
        return COMPONENTS_LOCALIZED.keySet();
    }

    public static Set<Object> componentsByKey(String key) {
        return COMPONENTS_LOCALIZED.get(key);
    }

    public static void switchI18nComponents() {
        for (String key : I18nViewUtil.keys()) {
            for (Object component : I18nViewUtil.componentsByKey(key)) {
                Object object;
                Objects.requireNonNull(component);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JPlaceholder.class, DialogAbout.class, JToolTipI18n.class, NodeModelEmpty.class, JLabel.class, JMenuItem.class, JButton.class, JComboBox.class, JTextComponent.class}, (Object)object, n)) {
                    case 0: {
                        JPlaceholder c = (JPlaceholder)object;
                        c.setPlaceholderText(I18nUtil.valueByKey(key));
                        break;
                    }
                    case 1: {
                        DialogAbout c = (DialogAbout)object;
                        c.setTitle(I18nUtil.valueByKey(key) + " jSQL Injection");
                        break;
                    }
                    case 2: {
                        JToolTipI18n c = (JToolTipI18n)object;
                        c.setText(I18nViewUtil.valueByKey(key));
                        break;
                    }
                    case 3: {
                        NodeModelEmpty c = (NodeModelEmpty)object;
                        c.setText(I18nViewUtil.valueByKey(key));
                        break;
                    }
                    case 4: {
                        JLabel c = (JLabel)object;
                        c.setText(I18nViewUtil.valueByKey(key));
                        break;
                    }
                    case 5: {
                        JMenuItem c = (JMenuItem)object;
                        c.setText(I18nViewUtil.valueByKey(key));
                        break;
                    }
                    case 6: {
                        JButton c = (JButton)object;
                        c.setText(I18nViewUtil.valueByKey(key));
                        break;
                    }
                    case 7: {
                        JComboBox c = (JComboBox)object;
                        c.setToolTipText(I18nViewUtil.valueByKey(key));
                        break;
                    }
                    case 8: {
                        JTextComponent c = (JTextComponent)object;
                        c.setText(I18nViewUtil.valueByKey(key));
                        break;
                    }
                }
            }
        }
    }

    public static void addComponentForKey(String key, Object component) {
        COMPONENTS_LOCALIZED.get(key.replace(" ", "_")).add(component);
    }

    public static String valueByKey(String key) {
        return I18nViewUtil.isNonUbuntu(I18nUtil.getCurrentLocale()) ? I18nViewUtil.formatNonLatin(I18nUtil.valueByKey(key)) : I18nUtil.valueByKey(key);
    }

    public static boolean isNonUbuntu(Locale locale) {
        return Locale.forLanguageTag("zh").getLanguage().equals(locale.getLanguage()) || Locale.forLanguageTag("ko").getLanguage().equals(locale.getLanguage()) || Locale.forLanguageTag("ja").getLanguage().equals(locale.getLanguage());
    }

    public static String formatNonLatin(String label) {
        return I18nViewUtil.formatNonLatin(label, "");
    }

    public static String formatNonLatin(String label, String custom) {
        return String.format("<html><span style=\"font-family:'%s';%s\">%s</span></html>", "Monospace", custom, label);
    }

    static {
        for (String keyI18n : I18nUtil.BUNDLE_ROOT.keySet()) {
            COMPONENTS_LOCALIZED.put(keyI18n, new HashSet());
        }
    }
}

