/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tree.action;

import com.jsql.model.bean.database.Column;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.view.swing.tree.model.AbstractNodeModel;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ActionLoadStop
implements ActionListener {
    private final AbstractNodeModel nodeModel;
    private final DefaultMutableTreeNode currentTableNode;

    public ActionLoadStop(AbstractNodeModel nodeModel, DefaultMutableTreeNode currentTableNode) {
        this.nodeModel = nodeModel;
        this.currentTableNode = currentTableNode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Column> columnsToSearch = this.getSelectedColumns();
        if (!this.nodeModel.isRunning() && columnsToSearch.isEmpty()) {
            return;
        }
        if (!this.nodeModel.isRunning()) {
            this.startListValues(columnsToSearch);
        } else {
            this.stopAbstractNode();
        }
        this.nodeModel.setRunning(!this.nodeModel.isRunning());
    }

    private void startListValues(final List<Column> columnsToSearch) {
        new SwingWorker<Object, Object>(this){

            @Override
            protected Object doInBackground() throws Exception {
                Thread.currentThread().setName("SwingWorkerActionLoadStop");
                MediatorHelper.model().getDataAccess().listValues(columnsToSearch);
                return null;
            }
        }.execute();
    }

    private void stopAbstractNode() {
        AbstractSuspendable suspendableTask = MediatorHelper.model().getMediatorUtils().threadUtil().get(this.nodeModel.getElementDatabase());
        if (suspendableTask != null) {
            suspendableTask.stop();
        }
        this.nodeModel.setIndexProgress(0);
        this.nodeModel.setProgressing(false);
        this.nodeModel.setLoading(false);
        MediatorHelper.model().getMediatorUtils().threadUtil().remove(this.nodeModel.getElementDatabase());
    }

    private List<Column> getSelectedColumns() {
        DefaultTreeModel treeModel = (DefaultTreeModel)MediatorHelper.treeDatabase().getModel();
        DefaultMutableTreeNode tableNode = this.currentTableNode;
        ArrayList<Column> columnsToSearch = new ArrayList<Column>();
        int tableChildCount = treeModel.getChildCount(tableNode);
        for (int i = 0; i < tableChildCount; ++i) {
            AbstractNodeModel columnTreeNodeModel;
            DefaultMutableTreeNode currentChild = (DefaultMutableTreeNode)treeModel.getChild(tableNode, i);
            Object object = currentChild.getUserObject();
            if (!(object instanceof AbstractNodeModel) || !(columnTreeNodeModel = (AbstractNodeModel)object).isSelected()) continue;
            columnsToSearch.add((Column)columnTreeNodeModel.getElementDatabase());
        }
        return columnsToSearch;
    }
}

