/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.terminal.util;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.terminal.AbstractExploit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyAdapterTerminal
extends KeyAdapter {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final AbstractExploit terminal;
    private final List<String> commandsHistory = new ArrayList<String>();
    private int indexCommandsHistory = 0;

    public KeyAdapterTerminal(AbstractExploit terminal) {
        this.terminal = terminal;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        try {
            Element root = this.terminal.getDocument().getDefaultRootElement();
            int caretPosition = this.terminal.getCaretPosition();
            int lineNumber = this.terminal.getLineOfOffset(caretPosition);
            if (this.terminal.getIsEdited().get()) {
                keyEvent.consume();
                return;
            }
            AtomicReference<String> command = new AtomicReference<String>("");
            command.set(this.terminal.getText(root.getElement(lineNumber).getStartOffset(), root.getElement(lineNumber).getEndOffset() - root.getElement(lineNumber).getStartOffset()).replace(this.terminal.getPrompt(), "").trim());
            if (keyEvent.getKeyCode() == 10) {
                this.runCommand(keyEvent, command);
            } else if (keyEvent.getKeyCode() == 38) {
                this.appendPreviousCommand(keyEvent, root, lineNumber, command);
            } else if (keyEvent.getKeyCode() == 40) {
                this.appendNextCommand(keyEvent, root, lineNumber, command);
            } else if (keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 8) {
                this.moveCaretLeft(keyEvent, caretPosition, lineNumber);
            } else if (keyEvent.getKeyCode() == 36) {
                this.moveCaretHome(keyEvent, lineNumber);
            } else if (this.isKeyNotAllowed(keyEvent, caretPosition)) {
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 67 && (keyEvent.getModifiersEx() & 0x80) != 0) {
                this.cancelCommand(keyEvent);
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    private boolean isKeyNotAllowed(KeyEvent keyEvent, int caretPosition) {
        return keyEvent.getKeyCode() == 65 && (keyEvent.getModifiersEx() & 0x80) != 0 || keyEvent.getKeyCode() == 127 && caretPosition == this.terminal.getDocument().getLength() || (keyEvent.getModifiersEx() & 0x80) != 0 && (keyEvent.getModifiersEx() & 0x40) != 0 || keyEvent.getKeyCode() == 33 || keyEvent.getKeyCode() == 34 || keyEvent.getKeyCode() == 9;
    }

    private void cancelCommand(KeyEvent keyEvent) {
        keyEvent.consume();
        this.terminal.append("\n");
        this.terminal.reset();
    }

    private void moveCaretHome(KeyEvent keyEvent, int lineNumber) throws BadLocationException {
        keyEvent.consume();
        this.terminal.setCaretPosition(this.terminal.getLineStartOffset(lineNumber) + this.terminal.getPrompt().length());
    }

    private void moveCaretLeft(KeyEvent keyEvent, int caretPosition, int lineNumber) throws BadLocationException {
        int newCaretPosition = caretPosition - this.terminal.getLineStartOffset(lineNumber);
        if (newCaretPosition <= this.terminal.getPrompt().length()) {
            keyEvent.consume();
        }
    }

    private void appendNextCommand(KeyEvent keyEvent, Element root, int lineNumber, AtomicReference<String> command) throws BadLocationException {
        keyEvent.consume();
        if (this.indexCommandsHistory < this.commandsHistory.size()) {
            ++this.indexCommandsHistory;
        }
        this.terminal.getDocument().remove(root.getElement(lineNumber).getStartOffset() + this.terminal.getPrompt().length(), command.get().length());
        if (this.indexCommandsHistory < this.commandsHistory.size()) {
            this.terminal.append(this.commandsHistory.get(this.indexCommandsHistory));
        }
        this.terminal.setCaretPosition(this.terminal.getDocument().getLength());
    }

    private void appendPreviousCommand(KeyEvent keyEvent, Element root, int lineNumber, AtomicReference<String> command) throws BadLocationException {
        keyEvent.consume();
        if (this.indexCommandsHistory > 0) {
            --this.indexCommandsHistory;
        }
        this.terminal.getDocument().remove(root.getElement(lineNumber).getStartOffset() + this.terminal.getPrompt().length(), command.get().length());
        if (!this.commandsHistory.isEmpty()) {
            this.terminal.append(this.commandsHistory.get(this.indexCommandsHistory));
        }
        this.terminal.setCaretPosition(this.terminal.getDocument().getLength());
    }

    private void runCommand(KeyEvent keyEvent, final AtomicReference<String> command) {
        this.terminal.getIsEdited().set(true);
        keyEvent.consume();
        this.terminal.setEditable(false);
        if (StringUtils.isNotEmpty(command.get())) {
            this.commandsHistory.add(command.get());
            this.indexCommandsHistory = this.commandsHistory.size();
        }
        new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() {
                Thread.currentThread().setName("SwingWorkerKeyAdapterTerminal");
                AbstractExploit terminalCommand = KeyAdapterTerminal.this.terminal;
                terminalCommand.append("\n");
                if (StringUtils.isNotEmpty((CharSequence)command.get())) {
                    terminalCommand.setCaretPosition(terminalCommand.getDocument().getLength());
                    terminalCommand.action((String)command.get(), terminalCommand.getUuidShell(), terminalCommand.getUrlShell(), terminalCommand.getLoginPassword());
                } else {
                    terminalCommand.reset();
                }
                return null;
            }
        }.execute();
    }
}

