/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.table;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.popupmenu.JPopupMenuTable;
import com.jsql.view.swing.table.ActionCloseSearch;
import com.jsql.view.swing.table.ActionShowSearch;
import com.jsql.view.swing.table.AdjusterTableColumn;
import com.jsql.view.swing.table.ButtonClose;
import com.jsql.view.swing.table.ComparatorColumn;
import com.jsql.view.swing.table.FixedColumnTable;
import com.jsql.view.swing.text.JTextFieldPlaceholder;
import com.jsql.view.swing.util.UiStringUtil;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PanelTable
extends JPanel {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final JTable tableValues;

    public PanelTable(String[][] data, String[] columnNames) {
        super(new BorderLayout());
        this.tableValues = new JTable(data, columnNames){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tableValues.setAutoResizeMode(0);
        this.tableValues.setSelectionMode(2);
        this.tableValues.setColumnSelectionAllowed(true);
        this.tableValues.setRowHeight(20);
        this.tableValues.setRowSelectionAllowed(true);
        this.tableValues.setCellSelectionEnabled(true);
        this.initRenderer();
        this.tableValues.getTableHeader().setReorderingAllowed(false);
        this.initMouseEvent();
        this.initTabShortcut();
        AdjusterTableColumn columnAdjuster = new AdjusterTableColumn(this.tableValues);
        columnAdjuster.adjustColumns();
        TableRowSorter<TableModel> rowSorter = new TableRowSorter<TableModel>(this.tableValues.getModel());
        this.tableValues.setRowSorter(rowSorter);
        this.initTableScroller();
        this.initPanelSearch(rowSorter);
        ComparatorColumn comparatorNumeric = new ComparatorColumn();
        for (int i = 0; i < this.tableValues.getColumnCount(); ++i) {
            rowSorter.setComparator(i, comparatorNumeric);
        }
    }

    private void initMouseEvent() {
        this.tableValues.setDragEnabled(true);
        this.tableValues.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PanelTable.this.tableValues.requestFocusInWindow();
                if (SwingUtilities.isRightMouseButton(e)) {
                    Point p = e.getPoint();
                    int rowNumber = PanelTable.this.tableValues.rowAtPoint(p);
                    int colNumber = PanelTable.this.tableValues.columnAtPoint(p);
                    DefaultListSelectionModel modelRow = (DefaultListSelectionModel)PanelTable.this.tableValues.getSelectionModel();
                    DefaultListSelectionModel modelColumn = (DefaultListSelectionModel)PanelTable.this.tableValues.getColumnModel().getSelectionModel();
                    modelRow.moveLeadSelectionIndex(rowNumber);
                    modelColumn.moveLeadSelectionIndex(colNumber);
                }
            }
        });
    }

    private void initRenderer() {
        TableCellRenderer cellRendererHeader = this.tableValues.getTableHeader().getDefaultRenderer();
        this.tableValues.getTableHeader().setDefaultRenderer((table, value, isSelected, hasFocus, row, column) -> cellRendererHeader.getTableCellRendererComponent(table, UiStringUtil.detectUtf8HtmlNoWrap(" " + String.valueOf(value) + " "), isSelected, hasFocus, row, column));
        DefaultTableCellRenderer cellRendererDefault = new DefaultTableCellRenderer();
        this.tableValues.setDefaultRenderer(this.tableValues.getColumnClass(2), (table, value, isSelected, hasFocus, row, column) -> {
            String cellValue = value != null ? value.toString() : "";
            try {
                return cellRendererDefault.getTableCellRendererComponent(table, UiStringUtil.detectUtf8HtmlNoWrap(cellValue), isSelected, hasFocus, row, column);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
                return null;
            }
        });
    }

    private void initTableScroller() {
        JScrollPane scroller = new JScrollPane(this.tableValues);
        FixedColumnTable tableFixedColumn = new FixedColumnTable();
        tableFixedColumn.fixColumnSize(2, scroller);
        this.add((Component)scroller, "Center");
    }

    private void initPanelSearch(final TableRowSorter<TableModel> rowSorter) {
        JPanel panelSearch = new JPanel(new BorderLayout());
        final JTextFieldPlaceholder textFilter = new JTextFieldPlaceholder("Find in table");
        panelSearch.add((Component)textFilter, "Center");
        ActionShowSearch actionShowSearchTable = new ActionShowSearch(panelSearch, textFilter);
        String keySearch = "search";
        this.tableValues.getActionMap().put(keySearch, actionShowSearchTable);
        this.tableValues.getInputMap().put(KeyStroke.getKeyStroke(70, 128), keySearch);
        ActionCloseSearch actionCloseSearch = new ActionCloseSearch(textFilter, panelSearch, this);
        String keyClose = "close";
        textFilter.getActionMap().put(keyClose, actionCloseSearch);
        textFilter.getInputMap().put(KeyStroke.getKeyStroke(27, 0), keyClose);
        textFilter.getDocument().addDocumentListener(new DocumentListener(){

            private void insertUpdateFixed() {
                String text = textFilter.getText();
                if (text.trim().isEmpty()) {
                    rowSorter.setRowFilter(null);
                } else {
                    rowSorter.setRowFilter(RowFilter.regexFilter("(?i)" + Pattern.quote(text), new int[0]));
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.insertUpdateFixed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.insertUpdateFixed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        this.tableValues.setComponentPopupMenu(new JPopupMenuTable(this.tableValues, actionShowSearchTable));
        ButtonClose buttonCloseSearch = new ButtonClose();
        buttonCloseSearch.addActionListener(actionCloseSearch);
        panelSearch.add((Component)buttonCloseSearch, "After");
        panelSearch.setVisible(false);
        this.add((Component)panelSearch, "South");
    }

    private void initTabShortcut() {
        this.tableValues.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0), null);
        this.tableValues.getInputMap(1).put(KeyStroke.getKeyStroke(9, 64), null);
        HashSet<AWTKeyStroke> forward = new HashSet<AWTKeyStroke>(this.tableValues.getFocusTraversalKeys(0));
        forward.add(KeyStroke.getKeyStroke("TAB"));
        this.tableValues.setFocusTraversalKeys(0, forward);
        HashSet<AWTKeyStroke> backward = new HashSet<AWTKeyStroke>(this.tableValues.getFocusTraversalKeys(1));
        backward.add(KeyStroke.getKeyStroke("shift TAB"));
        this.tableValues.setFocusTraversalKeys(1, backward);
    }

    public void selectTable() {
        this.tableValues.selectAll();
    }

    public void copyTable() {
        ActionEvent actionEvent = new ActionEvent(this.tableValues, 1001, "copy");
        this.tableValues.getActionMap().get(actionEvent.getActionCommand()).actionPerformed(actionEvent);
    }

    public JTable getTableValues() {
        return this.tableValues;
    }
}

