/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.panel;

import com.formdev.flatlaf.icons.FlatRadioButtonMenuItemIcon;
import com.jsql.model.injection.method.AbstractMethodInjection;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.ParameterUtil;
import com.jsql.view.swing.panel.address.ActionEnterAddressBar;
import com.jsql.view.swing.panel.address.ModelAddressLine;
import com.jsql.view.swing.panel.address.PanelTrailingAddress;
import com.jsql.view.swing.panel.util.ButtonExpandText;
import com.jsql.view.swing.text.JPopupTextField;
import com.jsql.view.swing.text.JTextFieldPlaceholder;
import com.jsql.view.swing.text.JToolTipI18n;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.RadioItemNonClosing;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PanelAddressBar
extends JPanel {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final AtomicReference<JTextField> atomicTextFieldAddress = new AtomicReference();
    private final AtomicReference<JTextField> atomicTextFieldRequest = new AtomicReference();
    private final AtomicReference<JTextField> atomicTextFieldHeader = new AtomicReference();
    private final AtomicReference<JRadioButton> atomicRadioRequest = new AtomicReference();
    private final AtomicReference<JRadioButton> atomicRadioMethod = new AtomicReference();
    private final AtomicReference<JRadioButton> atomicRadioHeader = new AtomicReference();
    private static final String[] METHODS = new String[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"};
    private JPopupMenu popupMethods;
    private JRadioButton radioCustomMethod;
    private JTextField inputCustomMethod;
    private AdvancedButtonAdapter advancedButtonAdapter;
    public static final String NAME_ADVANCED_BUTTON = "advancedButton";
    private static final String KEY_BUTTON_ADVANCED = "BUTTON_ADVANCED";
    private static final String KEY_ADDRESS_BAR_PLACEHOLDER = "ADDRESS_BAR_PLACEHOLDER";
    private static final String HEADER_SEPARATOR = "\\r\\n";
    private AbstractMethodInjection methodInjection = MediatorHelper.model().getMediatorMethod().getQuery();
    private String typeRequest = "GET";
    private final PanelTrailingAddress panelTrailingAddress;
    private boolean isAdvanceActivated = false;

    public PanelAddressBar() {
        ButtonGroup buttonGroup = new ButtonGroup();
        Stream.of(new ModelAddressLine("URL", MediatorHelper.model().getMediatorMethod().getQuery(), "QUERYSTRING", this.atomicRadioRequest, I18nUtil.valueByKey(KEY_ADDRESS_BAR_PLACEHOLDER), this.atomicTextFieldAddress), new ModelAddressLine("GET", MediatorHelper.model().getMediatorMethod().getRequest(), "REQUEST", this.atomicRadioMethod, "e.g. key=value&injectMe=", this.atomicTextFieldRequest), new ModelAddressLine("Header", MediatorHelper.model().getMediatorMethod().getHeader(), "HEADER", this.atomicRadioHeader, String.format("e.g. key: value\\r\\nCookie: cKey1=cValue1; cKey2=cValue2\\r\\n%s: %s %s\\r\\ninjectMe:", "Authorization", "Basic", "dXNlcjpwYXNz"), this.atomicTextFieldHeader)).forEach(modelLine -> {
            String i18nTooltip = String.format("FIELD_%s_TOOLTIP", modelLine.i18n());
            final AtomicReference<JToolTipI18n> tooltipTextfield = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey(i18nTooltip)));
            modelLine.textfield().set((JTextField)new JPopupTextField(new JTextFieldPlaceholder(modelLine.placeholder(), modelLine.radio() == this.atomicRadioRequest ? 18 : 0){

                @Override
                public JToolTip createToolTip() {
                    return (JToolTip)tooltipTextfield.get();
                }
            }).getProxy());
            I18nViewUtil.addComponentForKey(i18nTooltip, tooltipTextfield.get());
            modelLine.textfield().get().addActionListener(new ActionEnterAddressBar(this));
            modelLine.textfield().get().setVisible(false);
            modelLine.textfield().get().setToolTipText(I18nUtil.valueByKey(i18nTooltip));
            String i18nRadio = String.format("METHOD_%s_TOOLTIP", modelLine.i18n());
            final AtomicReference<JToolTipI18n> tooltipRadio = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey(i18nRadio)));
            modelLine.radio().set(new JRadioButton(modelLine.request()){

                @Override
                public JToolTip createToolTip() {
                    return (JToolTip)tooltipRadio.get();
                }
            });
            I18nViewUtil.addComponentForKey(i18nRadio, tooltipRadio.get());
            modelLine.radio().get().setToolTipText(I18nUtil.valueByKey(i18nRadio));
            modelLine.radio().get().setSelected(modelLine.radio() == this.atomicRadioRequest);
            modelLine.radio().get().setHorizontalTextPosition(2);
            modelLine.radio().get().setVisible(false);
            modelLine.radio().get().setBorder(BorderFactory.createEmptyBorder(modelLine.radio() == this.atomicRadioRequest ? 0 : 6, 3, 0, 3));
            modelLine.radio().get().addActionListener(e -> MediatorHelper.panelAddressBar().setMethodInjection(modelLine.method()));
            buttonGroup.add(modelLine.radio().get());
        });
        final Action originalPaste = this.atomicTextFieldAddress.get().getActionMap().get("paste-from-clipboard");
        this.atomicTextFieldAddress.get().getActionMap().put("paste-from-clipboard", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    String text = (String)cb.getData(DataFlavor.stringFlavor);
                    text = text.replace("\n", "\r\n").replace("\r\r\n", "\r\n");
                    String regexStartLine = "([^\\r\\n]+)";
                    String regexHeaders = "((?:[^\\r\\n]+\\r\\n)*)";
                    String regexBody = "(.*)";
                    Matcher matcher = Pattern.compile("(?s)" + regexStartLine + PanelAddressBar.HEADER_SEPARATOR + regexHeaders + PanelAddressBar.HEADER_SEPARATOR + regexBody).matcher(text);
                    if (matcher.find()) {
                        String startLine = matcher.group(1);
                        Matcher matcherStartLine = Pattern.compile("([^ ]+) +([^ ]+) +([^ ]+)").matcher(startLine);
                        if (matcherStartLine.find()) {
                            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "HTTP request detected");
                            String method = matcherStartLine.group(1);
                            Object requestTarget = matcherStartLine.group(2);
                            String headers = matcher.group(2).trim();
                            String body = matcher.group(3).trim();
                            if (((String)requestTarget).startsWith("/")) {
                                List<AbstractMap.SimpleEntry> listHeaders = Pattern.compile(PanelAddressBar.HEADER_SEPARATOR).splitAsStream(headers).map(keyValue -> Arrays.copyOf(keyValue.split(":"), 2)).map(keyValue -> new AbstractMap.SimpleEntry<String, String>(keyValue[0], keyValue[1] == null ? "" : keyValue[1])).toList();
                                AbstractMap.SimpleEntry<String, String> host = listHeaders.stream().filter(e -> "Host".equalsIgnoreCase((String)e.getKey())).findFirst().orElse(new AbstractMap.SimpleEntry<String, String>("Host", ""));
                                if (host.getValue().isEmpty()) {
                                    LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Missing Host in origin form");
                                    return;
                                }
                                requestTarget = "https://" + host.getValue().trim() + (String)requestTarget;
                            }
                            PanelAddressBar.this.atomicTextFieldAddress.get().setText((String)requestTarget);
                            PanelAddressBar.this.atomicRadioMethod.get().setText(method);
                            if (!Arrays.asList(METHODS).contains(method)) {
                                PanelAddressBar.this.inputCustomMethod.setText(method);
                                PanelAddressBar.this.radioCustomMethod.setSelected(true);
                            } else {
                                Arrays.stream(PanelAddressBar.this.popupMethods.getSubElements()).map(JMenuItem.class::cast).filter(jMenuItem -> method.equals(jMenuItem.getText())).findFirst().ifPresent(jMenuItem -> jMenuItem.setSelected(true));
                            }
                            PanelAddressBar.this.atomicTextFieldRequest.get().setText(body.replace("\n", "\\n").replace("\r", "\\r"));
                            PanelAddressBar.this.atomicTextFieldHeader.get().setText(headers.replace("\n", "\\n").replace("\r", "\\r"));
                            PanelAddressBar.this.advancedButtonAdapter.mouseClicked(true);
                        } else {
                            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Incorrect HTTP request, start line must match 'method target version': {}", (Object)startLine);
                        }
                    } else {
                        originalPaste.actionPerformed(actionEvent);
                    }
                }
                catch (UnsupportedFlavorException | IOException e2) {
                    LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e2, (Throwable)e2);
                }
            }
        });
        this.atomicTextFieldAddress.get().setFont(UiUtil.FONT_NON_MONO_BIG);
        this.atomicTextFieldAddress.get().setName("textFieldAddress");
        this.atomicTextFieldAddress.get().setPreferredSize(new Dimension(50, 32));
        this.atomicTextFieldAddress.get().setVisible(true);
        I18nViewUtil.addComponentForKey(KEY_ADDRESS_BAR_PLACEHOLDER, this.atomicTextFieldAddress.get());
        this.panelTrailingAddress = new PanelTrailingAddress(this);
        this.atomicTextFieldAddress.get().putClientProperty("JTextField.trailingComponent", this.panelTrailingAddress);
        this.atomicTextFieldAddress.get().putClientProperty("JTextField.leadingIcon", UiUtil.GLOBE.getIcon());
        this.atomicTextFieldRequest.get().putClientProperty("JTextField.trailingComponent", new ButtonExpandText(this.atomicTextFieldRequest.get()));
        this.atomicTextFieldHeader.get().putClientProperty("JTextField.trailingComponent", new ButtonExpandText(this.atomicTextFieldHeader.get()));
        this.initLayout();
    }

    private void initLayout() {
        JLabel advancedButton = this.initAdvancedButton();
        this.setLayout(new BoxLayout(this, 3));
        JPanel panelTextFields = new JPanel();
        GroupLayout groupLayout = new GroupLayout(panelTextFields);
        panelTextFields.setLayout(groupLayout);
        panelTextFields.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
        this.add(panelTextFields);
        this.popupMethods = new JPopupMenu();
        ButtonGroup buttonGroupMethods = new ButtonGroup();
        for (String method : METHODS) {
            RadioItemNonClosing newMenuItem = new RadioItemNonClosing(method, "GET".equals(method));
            newMenuItem.addActionListener(actionEvent -> {
                this.typeRequest = newMenuItem.getText();
                this.atomicRadioMethod.get().setText(this.typeRequest);
                this.atomicRadioMethod.get().requestFocusInWindow();
            });
            this.popupMethods.add(newMenuItem);
            buttonGroupMethods.add(newMenuItem);
        }
        final AtomicReference<JToolTipI18n> tooltipMethods = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey("METHOD_CUSTOM_TOOLTIP")));
        JPanel panelCustomMethod = new JPanel(new BorderLayout()){

            @Override
            public JToolTip createToolTip() {
                return (JToolTip)tooltipMethods.get();
            }
        };
        I18nViewUtil.addComponentForKey("METHOD_CUSTOM_TOOLTIP", tooltipMethods.get());
        Supplier<Color> colorBackground = () -> UIManager.getColor("MenuItem.background");
        Supplier<Color> colorSelectionBackground = () -> UIManager.getColor("MenuItem.selectionBackground");
        panelCustomMethod.setBackground(colorBackground.get());
        this.radioCustomMethod = new JRadioButton(){

            @Override
            public JToolTip createToolTip() {
                return (JToolTip)tooltipMethods.get();
            }
        };
        this.radioCustomMethod.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.radioCustomMethod.setIcon(new FlatRadioButtonMenuItemIcon());
        this.radioCustomMethod.setBackground(colorBackground.get());
        buttonGroupMethods.add(this.radioCustomMethod);
        this.inputCustomMethod = (JTextField)new JPopupTextField("CUSTOM"){

            @Override
            public JToolTip createToolTip() {
                return (JToolTip)tooltipMethods.get();
            }
        }.getProxy();
        this.radioCustomMethod.addActionListener(actionEvent -> this.validate(this.inputCustomMethod));
        String tooltipCustomMethod = "<html>Set user defined HTTP method.<br/>A valid method is limited to chars:<br>!#$%&'*+-.^_`|~0123456789<br>abcdefghijklmnopqrstuvwxyz<br>ABCDEFGHIJKLMNOPQRSTUVWXYZ</html>";
        MouseAdapter mouseAdapterSetBackground = new MouseAdapter(panelCustomMethod, colorSelectionBackground, colorBackground){
            final /* synthetic */ 4 val$panelCustomMethod;
            final /* synthetic */ Supplier val$colorSelectionBackground;
            final /* synthetic */ Supplier val$colorBackground;
            {
                this.val$panelCustomMethod = var2_2;
                this.val$colorSelectionBackground = supplier;
                this.val$colorBackground = supplier2;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                this.val$panelCustomMethod.setBackground((Color)this.val$colorSelectionBackground.get());
                PanelAddressBar.this.radioCustomMethod.setBackground((Color)this.val$colorSelectionBackground.get());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                this.val$panelCustomMethod.setBackground((Color)this.val$colorBackground.get());
                PanelAddressBar.this.radioCustomMethod.setBackground((Color)this.val$colorBackground.get());
            }
        };
        Arrays.asList(this.radioCustomMethod, this.inputCustomMethod, panelCustomMethod).forEach(component -> {
            component.addMouseListener(mouseAdapterSetBackground);
            component.setToolTipText(tooltipCustomMethod);
        });
        panelCustomMethod.add((Component)this.radioCustomMethod, "Before");
        panelCustomMethod.add((Component)this.inputCustomMethod, "Center");
        this.popupMethods.insert(panelCustomMethod, this.popupMethods.getComponentCount());
        this.atomicRadioMethod.get().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Arrays.stream(PanelAddressBar.this.popupMethods.getComponents()).map(a -> (JComponent)a).forEach(JComponent::updateUI);
                PanelAddressBar.this.radioCustomMethod.setIcon(new FlatRadioButtonMenuItemIcon());
                PanelAddressBar.this.radioCustomMethod.updateUI();
                PanelAddressBar.this.inputCustomMethod.updateUI();
                PanelAddressBar.this.popupMethods.updateUI();
                if (ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale()))) {
                    PanelAddressBar.this.radioCustomMethod.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
                } else {
                    PanelAddressBar.this.radioCustomMethod.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
                }
                PanelAddressBar.this.popupMethods.show(e.getComponent(), ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale())) ? e.getComponent().getX() - e.getComponent().getWidth() - PanelAddressBar.this.popupMethods.getWidth() : e.getComponent().getX(), e.getComponent().getY() + e.getComponent().getHeight());
                PanelAddressBar.this.popupMethods.setLocation(ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale())) ? e.getComponent().getLocationOnScreen().x + e.getComponent().getWidth() - PanelAddressBar.this.popupMethods.getWidth() : e.getComponent().getLocationOnScreen().x, e.getComponent().getLocationOnScreen().y + e.getComponent().getHeight());
                PanelAddressBar.this.popupMethods.applyComponentOrientation(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale()));
            }
        });
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.atomicRadioRequest.get()).addComponent(this.atomicRadioMethod.get()).addComponent(this.atomicRadioHeader.get())).addGroup(groupLayout.createParallelGroup().addComponent(this.atomicTextFieldAddress.get()).addComponent(this.atomicTextFieldRequest.get()).addComponent(this.atomicTextFieldHeader.get())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(advancedButton)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.atomicRadioRequest.get()).addComponent(this.atomicTextFieldAddress.get()).addComponent(advancedButton)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.atomicRadioMethod.get()).addComponent(this.atomicTextFieldRequest.get())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.atomicRadioHeader.get()).addComponent(this.atomicTextFieldHeader.get())));
    }

    private void validate(JTextField inputCustomMethod) {
        if (StringUtils.isEmpty(inputCustomMethod.getText())) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Missing custom request method, forcing GET");
            Arrays.stream(this.popupMethods.getSubElements()).map(JMenuItem.class::cast).filter(jMenuItem -> "GET".equals(jMenuItem.getText())).findFirst().ifPresent(jMenuItem -> jMenuItem.setSelected(true));
        } else if (ParameterUtil.isInvalidName(inputCustomMethod.getText())) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Illegal request method: {}", (Object)inputCustomMethod.getText());
        } else {
            this.typeRequest = inputCustomMethod.getText();
            this.atomicRadioMethod.get().setText(this.typeRequest);
        }
    }

    private JLabel initAdvancedButton() {
        final AtomicReference<JToolTipI18n> tooltip = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey(KEY_BUTTON_ADVANCED)));
        JLabel advancedButton = new JLabel((Icon)UiUtil.ARROW_DOWN.getIcon()){

            @Override
            public JToolTip createToolTip() {
                return (JToolTip)tooltip.get();
            }
        };
        advancedButton.setName(NAME_ADVANCED_BUTTON);
        advancedButton.setToolTipText(I18nUtil.valueByKey(KEY_BUTTON_ADVANCED));
        I18nViewUtil.addComponentForKey(KEY_BUTTON_ADVANCED, tooltip.get());
        this.advancedButtonAdapter = new AdvancedButtonAdapter(advancedButton);
        advancedButton.addMouseListener(this.advancedButtonAdapter);
        return advancedButton;
    }

    public void setMethodInjection(AbstractMethodInjection methodInjection) {
        this.methodInjection = methodInjection;
    }

    public boolean isAdvanceActivated() {
        return !this.isAdvanceActivated;
    }

    public JTextField getTextFieldAddress() {
        return this.atomicTextFieldAddress.get();
    }

    public JTextField getTextFieldRequest() {
        return this.atomicTextFieldRequest.get();
    }

    public JTextField getTextFieldHeader() {
        return this.atomicTextFieldHeader.get();
    }

    public AbstractMethodInjection getMethodInjection() {
        return this.methodInjection;
    }

    public PanelTrailingAddress getPanelTrailingAddress() {
        return this.panelTrailingAddress;
    }

    public String getTypeRequest() {
        return this.typeRequest;
    }

    public JRadioButton getAtomicRadioRequest() {
        return this.atomicRadioRequest.get();
    }

    public JRadioButton getAtomicRadioMethod() {
        return this.atomicRadioMethod.get();
    }

    public JRadioButton getAtomicRadioHeader() {
        return this.atomicRadioHeader.get();
    }

    private class AdvancedButtonAdapter
    extends MouseAdapter
    implements Serializable {
        private final JLabel advancedButton;

        public AdvancedButtonAdapter(JLabel advancedButton) {
            this.advancedButton = advancedButton;
        }

        public void mouseClicked(boolean isVisible) {
            PanelAddressBar.this.atomicTextFieldRequest.get().setVisible(isVisible);
            PanelAddressBar.this.atomicTextFieldHeader.get().setVisible(isVisible);
            PanelAddressBar.this.atomicRadioRequest.get().setVisible(isVisible);
            PanelAddressBar.this.atomicRadioMethod.get().setVisible(isVisible);
            PanelAddressBar.this.atomicRadioHeader.get().setVisible(isVisible);
            PanelAddressBar.this.isAdvanceActivated = isVisible;
            MediatorHelper.menubar().setVisible(isVisible);
            this.advancedButton.setIcon(isVisible ? UiUtil.ARROW_UP.getIcon() : UiUtil.ARROW_DOWN.getIcon());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            boolean isVisible = this.advancedButton.getIcon() == UiUtil.ARROW_DOWN.getIcon();
            this.mouseClicked(isVisible);
        }
    }
}

