/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager;

import com.jsql.util.I18nUtil;
import com.jsql.util.bruter.ActionCoder;
import com.jsql.util.bruter.Coder;
import com.jsql.view.swing.manager.util.CoderListener;
import com.jsql.view.swing.text.JPopupTextArea;
import com.jsql.view.swing.text.JTextAreaPlaceholder;
import com.jsql.view.swing.text.listener.DocumentListenerEditing;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.JSplitPaneWithZeroSizeDivider;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.LinkedHashMap;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ManagerCoder
extends JPanel {
    public static final String MENU_METHOD_MANAGER_CODER = "menuMethodManagerCoder";
    public static final String TEXT_INPUT_MANAGER_CODER = "textInputManagerCoder";
    public static final String RESULT_MANAGER_CODER = "resultManagerCoder";
    private final JTextArea textInput;
    private final JTextArea result;
    private JLabel menuMethod;
    private static final String ENCODE_TO = "Encode to ";
    private final transient CoderListener actionCoder = new CoderListener(this);

    public ManagerCoder() {
        super(new BorderLayout());
        JTextAreaPlaceholder placeholderInput = new JTextAreaPlaceholder(I18nUtil.valueByKey("CODER_INPUT"));
        this.textInput = (JTextArea)new JPopupTextArea(placeholderInput).getProxy();
        I18nViewUtil.addComponentForKey("CODER_INPUT", placeholderInput);
        this.textInput.getCaret().setBlinkRate(500);
        this.textInput.setLineWrap(true);
        this.textInput.setName(TEXT_INPUT_MANAGER_CODER);
        this.textInput.getDocument().addDocumentListener(new DocumentListenerEditing(){

            @Override
            public void process() {
                ManagerCoder.this.actionCoder.actionPerformed();
            }
        });
        JPanel topMixed = this.getTopPanel();
        JTextAreaPlaceholder placeholderResult = new JTextAreaPlaceholder(I18nUtil.valueByKey("CODER_RESULT"));
        this.result = (JTextArea)new JPopupTextArea(placeholderResult).getProxy();
        I18nViewUtil.addComponentForKey("CODER_RESULT", placeholderResult);
        this.result.setName(RESULT_MANAGER_CODER);
        this.result.setLineWrap(true);
        this.result.setEditable(false);
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.add((Component)new JScrollPane(this.result), "Center");
        JSplitPaneWithZeroSizeDivider divider = new JSplitPaneWithZeroSizeDivider(0);
        divider.setResizeWeight(0.5);
        divider.setTopComponent(topMixed);
        divider.setBottomComponent(bottom);
        this.add((Component)divider, "Center");
    }

    private JPanel getTopPanel() {
        JLabel comboMenubar = this.getLabelMenu();
        JPanel topMixed = new JPanel(new BorderLayout());
        topMixed.add((Component)new JScrollPane(this.textInput), "Center");
        topMixed.add((Component)comboMenubar, "South");
        return topMixed;
    }

    private JLabel getLabelMenu() {
        JLabel labelMenu;
        LinkedHashMap<String, JMenu> mapMenus = new LinkedHashMap<String, JMenu>();
        mapMenus.put(Coder.BASE16.label, new JMenu());
        mapMenus.put(Coder.BASE32.label, new JMenu());
        mapMenus.put(Coder.BASE58.label, new JMenu());
        mapMenus.put(Coder.BASE64.label, new JMenu());
        mapMenus.put(Coder.HEX.label, new JMenu());
        mapMenus.put(Coder.URL.label, new JMenu());
        mapMenus.put(Coder.UNICODE.label, new JMenu());
        JMenu menuHtml = new JMenu();
        mapMenus.put(Coder.HTML.label, menuHtml);
        mapMenus.put(Coder.BASE64_ZIP.label, new JMenu());
        mapMenus.put(Coder.HEX_ZIP.label, new JMenu());
        JMenuItem menuEncodeHtmlDecimal = new JMenuItem(ENCODE_TO + Coder.HTML_DECIMAL.label);
        menuHtml.add(menuEncodeHtmlDecimal);
        menuEncodeHtmlDecimal.addActionListener(this.actionCoder);
        menuEncodeHtmlDecimal.addChangeListener(new ChangeMenuListener(ENCODE_TO + Coder.HTML_DECIMAL.label));
        mapMenus.forEach((label, menu) -> {
            JMenuItem menuEncode = new JMenuItem(ENCODE_TO + label);
            menuEncode.addActionListener(this.actionCoder);
            menuEncode.addChangeListener(new ChangeMenuListener(ENCODE_TO + label));
            menuEncode.setName("encodeTo" + label);
            JMenuItem menuDecode = new JMenuItem("Decode from " + label);
            menuDecode.addActionListener(this.actionCoder);
            menuDecode.addChangeListener(new ChangeMenuListener("Decode from " + label));
            menuDecode.setName("decodeFrom" + label);
            menu.setText((String)label);
            menu.add(menuEncode);
            menu.add(menuDecode);
            menu.setName((String)label);
        });
        mapMenus.put("Hash", new JMenu("Hash"));
        ((JMenu)mapMenus.get("Hash")).setName("Hash");
        ActionCoder.getHashes().forEach(hash -> {
            JMenuItem menuEncode = new JMenuItem("Hash to " + hash);
            menuEncode.addActionListener(this.actionCoder);
            menuEncode.addChangeListener(new ChangeMenuListener("Hash to " + hash));
            menuEncode.setName("hashTo" + hash);
            ((JMenu)mapMenus.get("Hash")).add(menuEncode);
        });
        final JPopupMenu popupMenu = new JPopupMenu();
        for (JMenu menu2 : mapMenus.values()) {
            popupMenu.add(menu2);
        }
        this.menuMethod = labelMenu = new JLabel(UiUtil.ARROW_DOWN.getIcon(), 2);
        labelMenu.setText(ENCODE_TO + Coder.BASE64.label);
        labelMenu.setName(MENU_METHOD_MANAGER_CODER);
        labelMenu.setBorder(UiUtil.BORDER_5PX);
        labelMenu.addMouseListener(new MouseAdapter(this){

            @Override
            public void mousePressed(MouseEvent e) {
                Arrays.stream(popupMenu.getComponents()).map(JMenu.class::cast).forEach(menu -> {
                    menu.updateUI();
                    for (int i = 0; i < menu.getItemCount(); ++i) {
                        menu.getItem(i).updateUI();
                    }
                });
                popupMenu.updateUI();
                popupMenu.show(e.getComponent(), e.getComponent().getX(), e.getComponent().getY() + e.getComponent().getHeight());
                popupMenu.setLocation(e.getComponent().getLocationOnScreen().x, e.getComponent().getLocationOnScreen().y + e.getComponent().getHeight());
            }
        });
        return labelMenu;
    }

    public JTextArea getTextInput() {
        return this.textInput;
    }

    public JLabel getMenuMethod() {
        return this.menuMethod;
    }

    public JTextArea getResult() {
        return this.result;
    }

    private class ChangeMenuListener
    implements ChangeListener {
        private final String nameMethod;

        ChangeMenuListener(String nameMethod) {
            this.nameMethod = nameMethod;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JMenuItem item;
            Object object = e.getSource();
            if (object instanceof JMenuItem && ((item = (JMenuItem)object).isSelected() || item.isArmed())) {
                ManagerCoder.this.actionCoder.actionPerformed(this.nameMethod);
            }
        }
    }
}

