/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.list.ItemList;
import com.jsql.view.swing.manager.AbstractManagerList;
import com.jsql.view.swing.manager.util.StateButton;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.Component;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManagerAdminPage
extends AbstractManagerList {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public static final String LIST_MANAGER_ADMIN_PAGE = "listManagerAdminPage";

    public ManagerAdminPage() {
        super("swing/list/admin-page.txt");
        this.buildRunButton("ADMIN_PAGE_RUN_BUTTON_LABEL", "ADMIN_PAGE_RUN_BUTTON_TOOLTIP");
        this.run.setName("runManagerAdminPage");
        this.run.addActionListener(actionEvent -> this.runSearch());
        this.listPaths.setName(LIST_MANAGER_ADMIN_PAGE);
        this.lastLine.add(this.horizontalGlue);
        this.lastLine.add(this.progressBar);
        this.lastLine.add(this.run);
        this.add((Component)this.lastLine, "South");
    }

    private void runSearch() {
        if (this.listPaths.getSelectedValuesList().isEmpty()) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Select at least one admin page in the list");
            return;
        }
        Object urlAddressBar = MediatorHelper.panelAddressBar().getTextFieldAddress().getText();
        if (!((String)urlAddressBar).isEmpty() && !((String)urlAddressBar).matches("(?i)^https?://.*")) {
            if (!((String)urlAddressBar).matches("(?i)^\\w+://.*")) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, () -> I18nUtil.valueByKey("LOG_ADMIN_NO_PROTOCOL"));
                urlAddressBar = "http://" + (String)urlAddressBar;
            } else {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, () -> I18nUtil.valueByKey("LOG_ADMIN_UNKNOWN_PROTOCOL"));
                return;
            }
        }
        String urlFinal = urlAddressBar;
        new Thread(() -> this.searchAdminPages(urlFinal), "ThreadAdminPage").start();
    }

    private void searchAdminPages(String urlAddressBar) {
        if (this.run.getState() == StateButton.STARTABLE) {
            if (StringUtils.isEmpty(urlAddressBar)) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Missing URL in address bar");
            } else {
                LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} admin pages...", () -> I18nUtil.valueByKey("LOG_CHECKING"));
                this.run.setText(I18nViewUtil.valueByKey("ADMIN_PAGE_RUN_BUTTON_STOP"));
                this.run.setState(StateButton.STOPPABLE);
                this.progressBar.setVisible(true);
                this.horizontalGlue.setVisible(false);
                MediatorHelper.model().getResourceAccess().createAdminPages(urlAddressBar, this.listPaths.getSelectedValuesList().stream().map(ItemList::toString).toList());
                this.endProcess();
            }
        } else if (this.run.getState() == StateButton.STOPPABLE) {
            MediatorHelper.model().getResourceAccess().stopSearchAdmin();
            this.run.setEnabled(false);
            this.run.setState(StateButton.STOPPING);
        }
    }
}

