/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.subscriber;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.subscriber.Seal;
import java.util.concurrent.Flow;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSubscriber
implements Flow.Subscriber<Seal> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private Flow.Subscription subscription;

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    @Override
    public void onNext(Seal request) {
        this.subscription.request(1L);
        String nameThread = Thread.currentThread().getName();
        SwingUtilities.invokeLater(() -> {
            Thread.currentThread().setName("from " + nameThread);
            this.execute(request);
        });
    }

    protected abstract void execute(Seal var1);

    @Override
    public void onError(Throwable e) {
        LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, e);
    }

    @Override
    public void onComplete() {
    }

    public Flow.Subscription getSubscription() {
        return this.subscription;
    }
}

