/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.JSqlException;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import java.util.AbstractMap;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class CookiesUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public static final String COOKIE = "Cookie";
    private final InjectionModel injectionModel;

    public CookiesUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public boolean testParameters(boolean hasFoundInjection) {
        if (!hasFoundInjection) {
            if (!this.injectionModel.getMediatorUtils().preferencesUtil().isCheckingAllCookieParam()) {
                return false;
            }
        } else {
            return true;
        }
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} cookies...", () -> I18nUtil.valueByKey("LOG_CHECKING"));
        String rawHeader = this.injectionModel.getMediatorUtils().parameterUtil().getRawHeader();
        List<AbstractMap.SimpleEntry> cookies = this.injectionModel.getMediatorUtils().parameterUtil().getListHeader().stream().filter(entry -> COOKIE.equalsIgnoreCase((String)entry.getKey())).findFirst().map(cookieHeader -> ((String)cookieHeader.getValue()).split(";")).stream().flatMap(Stream::of).filter(cookie -> cookie != null && cookie.contains("=")).map(cookie -> cookie.split("=", 2)).map(arrayEntry -> new AbstractMap.SimpleEntry<String, String>(arrayEntry[0].trim(), arrayEntry[1] == null ? "" : arrayEntry[1].trim())).toList();
        for (AbstractMap.SimpleEntry cookie2 : cookies) {
            String keyValue = (String)cookie2.getKey() + "=" + (String)cookie2.getValue();
            String headerCookieWithStar = rawHeader.replace(keyValue, keyValue + "*");
            this.injectionModel.getMediatorUtils().parameterUtil().initHeader(headerCookieWithStar);
            try {
                Supplier[] supplierArray = new Supplier[3];
                supplierArray[0] = () -> I18nUtil.valueByKey("LOG_CHECKING");
                supplierArray[1] = cookie2::getKey;
                supplierArray[2] = () -> ((String)cookie2.getValue()).replace("*", "");
                LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} cookie [key:{}, value:{}]", supplierArray);
                if (!this.injectionModel.getMediatorMethod().getHeader().testParameters()) continue;
                return true;
            }
            catch (JSqlException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, String.format("No Cookie injection for %s=%s", cookie2.getKey(), ((String)cookie2.getValue()).replace("*", "")));
            }
        }
        return false;
    }
}

