/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.suspendable;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.suspendable.Input;
import com.jsql.util.LogLevelUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSuspendable {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private boolean isStopped = false;
    private boolean isPaused = false;
    protected final InjectionModel injectionModel;

    protected AbstractSuspendable(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public abstract String run(Input var1) throws JSqlException;

    public String run() throws JSqlException {
        return this.run(null);
    }

    public synchronized boolean isSuspended() {
        while (this.isPaused) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return this.isStopped || this.injectionModel.isStoppedByUser();
    }

    public void stop() {
        this.unpause();
        this.isStopped = true;
    }

    public void pause() {
        this.isPaused = true;
    }

    public void unpause() {
        this.isPaused = false;
        this.resume();
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public synchronized void resume() {
        this.notifyAll();
    }
}

